package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CommuneRegionAgricoleModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/CommuneRegionAgricoleModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Modèle d'import pour les régions agricoles
 * 
 * Columns:
 * <ul>
 * <li>Région
 * <li>Département
 * <li>Arrondissement
 * <li>Pseudo-canton
 * <li>Codecommune
 * <li>Régionagricole
 * <li>Petiterégionagricole
 * <li>Nomdelapetiterégionagricole
 * <li>Préfixecommune
 * <li>Nomdelacommune
 * </ul>
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CommuneRegionAgricoleModel extends AbstractAgrosystModel<RefLocationDto> {

    public CommuneRegionAgricoleModel() {
        super('\t');

        newIgnoredColumn("Région");
        newIgnoredColumn("Département");
        newIgnoredColumn("Arrondissement");
        newIgnoredColumn("Pseudo-canton");
        newMandatoryColumn("Codecommune", "codeInsee");
        newIgnoredColumn("Régionagricole");
        newMandatoryColumn("Petiterégionagricole", "codePetiteRegionAgricole");
        newMandatoryColumn("Nomdelapetiterégionagricole", "nomPetiteRegionAgricole");
        newIgnoredColumn("Préfixecommune");
        newIgnoredColumn("Nomdelacommune");

    }

    @Override
    public RefLocationDto newEmptyInstance() {
        return new RefLocationDto();
    }

}
