package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CommunePostCodeModel.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/CommunePostCodeModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * Modèle d'import pour les codes postaux
 * 
 * Columns:
 * <ul>
 * <li>Commune
 * <li>Codepos
 * <li>Departement
 * <li>INSEE
 * </ul>
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class CommunePostCodeModel extends AbstractAgrosystModel<RefLocationDto> {

    public CommunePostCodeModel() {
        super(';');

        newIgnoredColumn("Commune");
        newMandatoryColumn("Codepos", "codePostal");
        newIgnoredColumn("Departement");
        newMandatoryColumn("INSEE", "codeInsee");
    }

    @Override
    public RefLocationDto newEmptyInstance() {
        return new RefLocationDto();
    }

}
