package fr.inra.agrosyst.services.referential.csv;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CommuneInseeModel.java 3571 2014-03-03 15:23:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/csv/CommuneInseeModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * CommuneInseeModel import model
 * 
 * Columns:
 * <ul>
 * <li>CDC
 * <li>CHEFLIEU
 * <li>REG
 * <li>DEP
 * <li>COM
 * <li>AR
 * <li>CT
 * <li>TNCC
 * <li>ARTMAJ
 * <li>NCC
 * <li>ARTMIN
 * <li>NCCENR
 * </ul>
 * @author David Cossé
 */
public class CommuneInseeModel extends AbstractAgrosystModel<RefLocationDto> {

    public CommuneInseeModel() {
        super(';');

        newIgnoredColumn("CDC");
        newIgnoredColumn("CHEFLIEU");
        newMandatoryColumn("REG", "region", INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("DEP", "departement");
        newMandatoryColumn("COM", "codeCommune");
        newIgnoredColumn("AR");
        newIgnoredColumn("CT");
        newIgnoredColumn("TNCC");
        newIgnoredColumn("ARTMAJ");
        newIgnoredColumn("NCC");
        newMandatoryColumn("ARTMIN", "articleCommune");
        newMandatoryColumn("NCCENR", "nomCommune");
    }

    @Override
    public RefLocationDto newEmptyInstance() {
        return new RefLocationDto();
    }

}
