package fr.inra.agrosyst.services.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ExportServiceImpl.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/referential/ExportServiceImpl.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

import com.google.common.base.Charsets;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.topia.persistence.TopiaDao;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;

import fr.inra.agrosyst.api.entities.referential.*;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referential.ExportService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.referential.csv.*;

/**
 * Implementation du service d'export.
 * 
 * @author Eric Chatellier
 */
public class ExportServiceImpl extends AbstractAgrosystService implements ExportService {

    protected <E extends ReferentialEntity> InputStream runSimpleExport(Iterable<String> entityIds, Class<E> clazz, ExportModel<E> exportModel) {
        InputStream result;

        try {
            // get lazy iterator of entities to export
            final TopiaDao<E> classDao = context.getDaoSupplier().getDao(clazz);
            
            Iterable<E> entities;
            if (entityIds != null) {
                entities = Iterables.transform(entityIds, new Function<String, E>() {
                    @Override
                    public E apply(String input) {
                        E result = classDao.forTopiaIdEquals(input).findUnique();
                        return result;
                    }
                });
            } else {
                entities = classDao.findAll();
            }

            // export iterator
            File tempFile = File.createTempFile("export-" + clazz.getSimpleName() + "-", ".csv");
            Export.exportToFile(exportModel, entities, tempFile, Charsets.UTF_8);
            result = new FileInputStream(tempFile);
        } catch(Exception ex) {
            throw new AgrosystTechnicalException("Can't export", ex);
        }
        
        return result;
    }
    
    @Override
    public InputStream exportOrientationEdiCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefOrientationEDI.class,
                new RefOrientationEdiModel());
        return result;
    }

    @Override
    public InputStream exportSolArvalisCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSolArvalis.class,
                new RefSolArvalisModel());
        return result;
    }

    @Override
    public InputStream exportMaterielTracteursCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefMaterielTraction.class,
                new RefMaterielTracteurModel());
        return result;
    }

    @Override
    public InputStream exportMaterielAutomoteursCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefMaterielAutomoteur.class,
                new RefMaterielAutomoteurModel());
        return result;
    }

    @Override
    public InputStream exportMaterielOutilsCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefMaterielOutil.class,
                new RefMaterielOutilModel());
        return result;
    }

    @Override
    public InputStream exportMaterielIrrigationCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefMaterielIrrigation.class,
                new RefMaterielIrrigationModel());
        return result;
    }

    @Override
    public InputStream exportLegalStatusCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefLegalStatus.class,
                new RefLegalStatusModel());
        return result;
    }

    @Override
    public InputStream exportEspeces(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefEspece.class,
                new RefEspeceModel());
        return result;
    }

    @Override
    public InputStream exportVarietesGeves(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefVarieteGeves.class,
                new RefVarieteGevesModel());
        return result;
    }

    @Override
    public InputStream exportVarietesPlantGrape(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefVarietePlantGrape.class,
                new RefVarietePlantGrapeModel());
        return result;
    }

    @Override
    public InputStream exportClonesPlantGrape(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefClonePlantGrape.class,
                new RefClonePlantGrapeModel());
        return result;
    }

    @Override
    public InputStream exportEspecesToVarietes(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefEspeceToVariete.class,
                new RefEspeceToVarieteModel());
        return result;
    }

    @Override
    public InputStream exportOtexCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefOTEX.class,
                new RefOTEXModel());
        return result;
    }

    @Override
    public InputStream exportInterventionAgrosystTravailEdiCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefInterventionAgrosystTravailEDI.class,
                new RefInterventionAgrosystTravailEDIModel());
        return result;
    }

    @Override
    public InputStream exportTypeTravailEdiCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefTypeTravailEDI.class,
                new RefTypeTravailEDIModel());
        return result;
    }

    @Override
    public InputStream exportStadesEdiCSV(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefStadeEDI.class,
                new RefStadeEDIModel());
        return result;
    }

    @Override
    public InputStream exportSolTextureGeppa(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSolTextureGeppa.class,
                new RefSolTextureGeppaModel());
        return result;
    }

    @Override
    public InputStream exportZonageParcelleEdi(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefParcelleZonageEDI.class,
                new RefParcelleZonageEdiModel());
        return result;
    }

    @Override
    public InputStream exportSolProfondeurIndigo(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSolProfondeurIndigo.class,
                new RefSolProfondeurIndigoModel());
        return result;
    }

    @Override
    public InputStream exportSolCarateristiquesIndigo(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSolCaracteristiqueIndigo.class,
                new RefSolCaracteristiqueIndigoModel());
        return result;
    }

    @Override
    public InputStream exportUniteEDI(Iterable<String> entityIds){
        InputStream result = runSimpleExport(
                entityIds,
                RefUniteEDI.class,
                new RefUniteEDIModel());
        return result;
    }

    @Override
    public InputStream exportFertiMinUNIFA(Iterable<String> entityIds){
        InputStream result = runSimpleExport(
                entityIds,
                RefFertiMinUNIFA.class,
                new RefFertiMinUNIFAModel());
        return result;
    }

    @Override
    public InputStream exportAdventices(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefAdventice.class,
                new RefAdventiceModel());
        return result;
    }

    @Override
    public InputStream exportNuisiblesEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNuisibleEDI.class,
                new RefNuisibleEDIModel());
        return result;
    }

    @Override
    public InputStream exportFertiOrga(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefFertiOrga.class,
                new RefFertiOrgaModel());
        return result;
    }

    @Override
    public InputStream exportFertiEngraisOrg(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefFertiEngraisorg.class,
                new RefFertiEngraisOrgModel()
        );
        return result;
    }

    @Override
    public InputStream exportStationMeteo(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefStationMeteo.class,
                new RefStationMeteoModel()
        );
        return result;
    }

    @Override
    public InputStream exportGesCarburants(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefGesCarburant.class,
                new RefGesCarburantModel()
        );
        return result;
    }

    @Override
    public InputStream exportGesEngrais(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefGesEngrais.class,
                new RefGesEngraisModel()
        );
        return result;
    }

    @Override
    public InputStream exportGesPhyto(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefGesPhyto.class,
                new RefGesPhytoModel()
        );
        return result;
    }

    @Override
    public InputStream exportGesSemences(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefGesSemence.class,
                new RefGesSemenceModel()
        );
        return result;
    }

    @Override
    public InputStream exportNrjCarburants(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNrjCarburant.class,
                new RefNrjCarburantModel()
        );
        return result;
    }

    @Override
    public InputStream exportNrjEngrais(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNrjEngrais.class,
                new RefNrjEngraisModel()
        );
        return result;
    }

    @Override
    public InputStream exportNrjPhyto(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNrjPhyto.class,
                new RefNrjPhytoModel()
        );
        return result;
    }

    @Override
    public InputStream exportNrjSemences(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNrjSemence.class,
                new RefNrjSemenceModel()
        );
        return result;
    }

    @Override
    public InputStream exportNrjGesOutils(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefNrjGesOutil.class,
                new RefNrjGesOutilModel()
        );
        return result;
    }

    @Override
    public InputStream exportMesure(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefMesure.class,
                new RefMesureModel()
        );
        return result;
    }

    @Override
    public InputStream exportSupportOrganeEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSupportOrganeEDI.class,
                new RefSupportOrganeEDIModel()
        );
        return result;
    }

    @Override
    public InputStream exportStadeNuisibleEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefStadeNuisibleEDI.class,
                new RefStadeNuisibleEDIModel()
        );
        return result;
    }

    @Override
    public InputStream exportTypeNotationEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefTypeNotationEDI.class,
                new RefTypeNotationEDIModel()
        );
        return result;
    }

    @Override
    public InputStream exportValeurQualitativeEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefValeurQualitativeEDI.class,
                new RefValeurQualitativeEDIModel()
        );
        return result;
    }

    @Override
    public InputStream exportUnitesQualifiantEDI(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefUnitesQualifiantEDI.class,
                new RefUnitesQualifiantEDIModel()
        );
        return result;
    }

    @Override
    public InputStream exportActaTraitementsProducts(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefActaTraitementsProduit.class,
                new RefActaTraitementsProduitModel()
        );
        return result;
    }

    @Override
    public InputStream exportActaSubstanceActive(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefActaSubstanceActive.class,
                new RefActaSubstanceActiveModel()
        );
        return result;
    }

    @Override
    public InputStream exportProtocoleVgObs(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefProtocoleVgObs.class,
                new RefProtocoleVgObsModel()
        );
        return result;
    }

    @Override
    public InputStream exportElementVoisinage(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefElementVoisinage.class,
                new RefElementVoisinageModel()
        );
        return result;
    }

    @Override
    public InputStream exportPhytoSubstanceActiveIphy(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefPhytoSubstanceActiveIphy.class,
                new RefPhytoSubstanceActiveIphyModel()
        );
        return result;
    }

    @Override
    public InputStream exportTypeAgriculture(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefTypeAgriculture.class,
                new RefTypeAgricultureModel()
        );
        return result;
    }
 
    @Override
    public InputStream exportActaDosageSpc(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefActaDosageSPC.class,
                new RefActaDosageSPCModel()
        );
        return result;
    }

    @Override
    public InputStream exportActaGroupeCultures(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefActaGroupeCultures.class,
                new RefActaGroupeCulturesModel()
        );
        return result;
    }

    @Override
    public InputStream exportLienCulturesEdiActa(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefLienCulturesEdiActa.class,
                new RefLienCulturesEdiActaModel()
        );
        return result;
    }

    @Override
    public InputStream exportSaActaIphy(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefSaActaIphy.class,
                new RefSaActaIphyModel()
        );
        return result;
    }

    @Override
    public InputStream exportTraitSdC(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefTraitSdC.class,
                new RefTraitSdCModel()
        );
        return result;
    }

    @Override
    public InputStream exportCultureEdiGroupeCouvSol(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefCultureEdiGroupeCouvSol.class,
                new RefCultureEdiGroupeCouvSolModel()
        );
        return result;
    }

    @Override
    public InputStream exportCouvSolPerenne(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefCouvSolPerenne.class,
                new RefCouvSolPerenneModel()
        );
        return result;
    }

    @Override
    public InputStream exportCouvSolAnnuelle(Iterable<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefCouvSolAnnuelle.class,
                new RefCouvSolAnnuelleModel()
        );
        return result;
    }

    @Override
    public InputStream exportActaTraitementsProductsCateg(List<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefActaTraitementsProduitsCateg.class,
                new RefActaTraitementsProduitsCategModel()
        );
        return result;
    }

    @Override
    public InputStream exportZoneClimatiqueIphy(List<String> entityIds) {
        InputStream result = runSimpleExport(
                entityIds,
                RefZoneClimatiqueIphy.class,
                new RefZoneClimatiqueIphyModel()
        );
        return result;
    }
}
