package fr.inra.agrosyst.services.practiced.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedSystemMetadata.java 4030 2014-04-29 10:02:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/practiced/export/PracticedSystemMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;

/**
 * @author David Cossé
 */
public class PracticedSystemMetadata {

    public abstract static class PracticedSystemCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("practicedSystemName", "Nom du système synthétisé");
            result.put("campaigns", "Série de campagnes agricoles");
            result.put("growingSystemName", "Système de culture");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");

            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            return result;
        }
    }

    public static class PracticedSystemMainBeanInfo extends PracticedSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Généralités";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(PracticedSystem.PROPERTY_SOURCE, "Source");
            columns.put(PracticedSystem.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();
            return result;
        }

    }

    public static class PracticedSeasonalCropCycleBeanInfo extends PracticedSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Cycles de cultures assolées";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();

            // nodes
            columns.put("label", "Culture");
            columns.put("endCycle", "Fin de cycle");
            columns.put("sameCampaignAsPreviousNode", "Même campagne agricole");
            columns.put("initNodeFrequency", "Fréquence initiale de la culture");// for first node

            // connections
            //   label same field name as node
            columns.put("previousCrop", "Culture précédente");
            columns.put("croppingPlanEntryFrequency", "Fréquence");
            columns.put("intermediateCropName", "Culture intermédiaire");// need to call service

            // nodes
            columns.put("x", "Rang");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();
            return result;
        }
    }

    public static class PracticedPerennialCropCycleBeanInfo extends PracticedSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Cycles de cultures perennes";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();

            columns.put("label", "Culture");
            columns.put("phaseType", "Phase");
            columns.put("phaseDuration", "Durée de la phase");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_YEAR,"Année de plantation");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, "Inter-rang de plantation");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_SPACING, "Espacement de plantation sur le rang");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_DENSITY, "Densité de plantation");
            columns.put(PracticedPerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, "Forme fruitière vergers");
            columns.put(PracticedPerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, "Forme fruitière vigne");
            columns.put(PracticedPerennialCropCycle.PROPERTY_ORIENTATION, "Orientation des rangs");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, "Taux de mortalité dans la plantation");
            columns.put(PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, "Année de mesure de ce taux de mortalité");
            columns.put(PracticedPerennialCropCycle.PROPERTY_WEED_TYPE, "Type d'enherbement");
            columns.put(PracticedPerennialCropCycle.PROPERTY_POLLINATOR, "Pollinisateurs");
            columns.put(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, "% de pollinisateur");
            columns.put(PracticedPerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, "Mode de répartition des pollinisateurs");
            columns.put(PracticedPerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, "Autres caractéristiques du couvert végétal");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();
            return result;
        }
    }

    public static class PracticedPerennialCropCycleSpeciesBeanInfo extends PracticedSystemCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Espèces des phases de production des cultures pérennes";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            // remind the crop from perennial cycle
            columns.put("croppingPlanEntryName", "Culture");
            columns.put("phase", "Phase");

            // species characteristics
            columns.put("speciesEspece", "Espèce");
            columns.put("speciesQualifiant", "Qualifiant");
            columns.put("speciesTypeSaisonnier", "Type saisonnier");
            columns.put("speciesDestination","Destination");
            columns.put("varietyLibelle", "Cépage / Variété");
            columns.put("profil_vegetatif_BBCH", "Profil vegetatif BBCH");
            columns.put("graftSupport", "Porte-greffe");
            columns.put("graftClone", "Clone de la greffe");
            columns.put("plantsCertified", "Certification des plants");
            columns.put("overGraftDate", "Date de sur-greffage");
            return columns;
        }

        //        protected CropCycleGraftDto graftClone;
        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            return result;
        }
    }

    public static class PracticedITKBeanInfo extends PracticedSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Interventions";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            // cycle summary
            columns.put("itk_cycle", "Cycle");
            columns.put("itk_crop", "Culture");
            // ITK
            columns.put("itk_rank", "Rang");
            columns.put("itk_phase", "Phase");
            columns.put("itk_previous_crop", "Culture précédente");

            columns.put(PracticedIntervention.PROPERTY_NAME, "Nom");
            columns.put(PracticedIntervention.PROPERTY_TYPE, "Type d'intervention");
            columns.put(PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE, "Date de début d'intervention");
            columns.put(PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE, "Date de fin d'intervention ");
            columns.put("PSCi", "PSCi");
            columns.put(PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY, "Fréquence spatiale");

            columns.put("toolsCouplings", "Combinaison d'outils");
            columns.put(PracticedIntervention.PROPERTY_PROGRESSION_SPEED, "Vitesse d'avancement");
            columns.put(PracticedIntervention.PROPERTY_INVOLVED_PEOPLE_NUMBER, "Nombre de personnes intervenant");
            columns.put(PracticedIntervention.PROPERTY_WORK_RATE, "Débit de chantier");
            columns.put("spendingTime", "Temps passé");

            columns.put(PracticedIntervention.PROPERTY_INTERMEDIATE_CROP, "Affectation à la culture intermédiaire");

            // stades
            columns.put("species", "Espèce");
            columns.put("stadeMin", "Stade de culture minimum");
            columns.put("stadeMax", "Stade de culture maximum");

            // actions
            columns.put("actionType", "Type d'action");
            columns.put("action", "Action");
            columns.put("mainAction", "Action principale");

            // inputs
            columns.put("inputType", "Type d'intrant");
            columns.put("product", "Produit");
            columns.put("qtMin", "Quantité minimale");
            columns.put("qtAvg", "Quantité moyenne");
            columns.put("qtMed", "Quantité médiane");
            columns.put("qtMax", "Quantité maximale");
            columns.put("unit", "Unité de produit");

            columns.put(PracticedIntervention.PROPERTY_COMMENT, "Commentaire");

            return columns;
        }
    }
}
