package fr.inra.agrosyst.services.practiced.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedSystemEntity.java 3906 2014-03-29 17:08:06Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/practiced/export/PracticedSystemEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author David Cossé
 */
public class PracticedSystemEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 8039851466719159366L;

    protected String practicedSystemName;

    protected String campaigns;

    protected String growingSystemName;

    protected String growingPlanName;

    protected String domainName;

    public String getPracticedSystemName() {
        return practicedSystemName;
    }

    public void setPracticedSystemName(String practicedSystemName) {
        this.practicedSystemName = practicedSystemName;
    }

    public String getCampaigns() {
        return campaigns;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public String getGrowingSystemName() {
        return growingSystemName;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    public String getGrowingPlanName() {
        return growingPlanName;
    }

    public void setGrowingPlanName(String growingPlanName) {
        this.growingPlanName = growingPlanName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PracticedSystemEntity clone = (PracticedSystemEntity) super.clone();
        return clone;
    }
}
