package fr.inra.agrosyst.services.practiced;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PracticedSystemServiceImpl.java 5142 2015-12-01 14:48:46Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/practiced/PracticedSystemServiceImpl.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.SolHorizon;
import fr.inra.agrosyst.api.entities.SolHorizonTopiaDao;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.AbstractInputTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralProductInput;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicProductInput;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherProductInput;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleImpl;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteTopiaDao;
import fr.inra.agrosyst.api.exceptions.AgrosystDuplicationException;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.Equipments;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPerennialCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystems;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.services.security.AnonymizeService;
import fr.inra.agrosyst.api.services.security.BusinessAuthorizationService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.common.export.EntityExportExtra;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.EntityExporter;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.practiced.export.PracticedSeasonalEntityExport;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemEntity;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata.PracticedITKBeanInfo;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata.PracticedPerennialCropCycleBeanInfo;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata.PracticedPerennialCropCycleSpeciesBeanInfo;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata.PracticedSeasonalCropCycleBeanInfo;
import fr.inra.agrosyst.services.practiced.export.PracticedSystemMetadata.PracticedSystemMainBeanInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PracticedSystemServiceImpl extends AbstractAgrosystService implements PracticedSystemService {

    protected BusinessAuthorizationService authorizationService;
    protected DomainService domainService;
    protected PricesService pricesService;
    protected ActionService actionService;
    protected InputService inputService;
    protected AnonymizeService anonymizeService;

    protected PracticedSystemTopiaDao practicedSystemDao;
    protected GrowingSystemTopiaDao growingSystemDao;
    protected PracticedInterventionTopiaDao practicedInterventionDao;
    protected MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao;
    protected PracticedCropCycleSpeciesTopiaDao practicedCropCycleSpeciesDao;
    protected PracticedCropCycleTopiaDao praticedCropCycleDao;
    protected PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao;
    protected PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao;
    protected PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao;
    protected PracticedCropCycleNodeTopiaDao practicedCropCycleNodeDao;
    protected AbstractActionTopiaDao abstractActionDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;
    protected PracticedCropCyclePhaseTopiaDao practicedCropCyclePhaseDao;
    protected CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao;
    protected ToolsCouplingTopiaDao toolsCouplingDao;
    protected OtherActionTopiaDao otherActionDao;
    protected SeedingActionTopiaDao seedingActionDao;
    protected HarvestingActionTopiaDao harvestingActionDao;
    protected PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao;
    protected IrrigationActionTopiaDao irrigationActionDao;
    protected OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao;
    protected MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao;
    protected BiologicalControlActionTopiaDao biologicalControlActionDao;
    protected TillageActionTopiaDao tillageActionDao;
    protected PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao;
    protected AbstractInputTopiaDao inputTopiaDao;
    protected PracticedPlotTopiaDao practicedPlotDao;
    protected SolHorizonTopiaDao solHorizonDao;
    protected RefTypeTravailEDITopiaDao refTypeTravailEDIDao;
    protected RefOrientationEDITopiaDao refOrientationEDIDao;
    protected RefClonePlantGrapeTopiaDao refClonePlantGrapeDao;
    protected RefVarieteTopiaDao varieteDao;
    protected RefStadeEDITopiaDao refStadeEDIDao;

    private static final Log log = LogFactory.getLog(PracticedSystemServiceImpl.class);
    private static final String NEW_NODE = "new-node-";

    protected static Binder<PracticedIntervention, PracticedInterventionDto> PRACTICED_INTERVENTION_TO_DTO_BINDER = BinderFactory.newBinder(PracticedIntervention.class, PracticedInterventionDto.class);

    protected static final Function<CroppingPlanEntryDto, CropCycleModelDto> CROPPING_PLAN_ENTRY_TO_DTO = new Function<CroppingPlanEntryDto, CropCycleModelDto>() {
        @Override
        public CropCycleModelDto apply(CroppingPlanEntryDto input) {
            CropCycleModelDto result = new CropCycleModelDto();
            result.setCroppingPlanEntryCode(input.getCode());
            result.setLabel(input.getName());
            result.setCroppingPlanSellingPrice(input.getSellingPrice());
            result.setIntermediate(input.isIntermediate());
            return result;
        }
    };

    protected static final Function<CroppingPlanEntryDto, String> GET_CROPPING_PLAN_ENTRY_CODE = new Function<CroppingPlanEntryDto, String>() {
        @Override
        public String apply(CroppingPlanEntryDto input) {
            return input.getCode();
        }
    };

    protected static List<PracticedInterventionDto> practicedInterventionToInterventionDtos(
            final String domainCode, List<PracticedIntervention> interventions,
            final Map<String, List<AbstractAction>> actionsByInterventionId,
            final Map<String, List<AbstractInput>> inputsByInterventionId) {

        Iterable<PracticedInterventionDto> view = Iterables.transform(interventions, new Function<PracticedIntervention, PracticedInterventionDto>() {
            @Override
            public PracticedInterventionDto apply(PracticedIntervention intervention) {
                PracticedInterventionDto interventionDto = new PracticedInterventionDto();
                bindInterventionToInterventionDto(PRACTICED_INTERVENTION_TO_DTO_BINDER, intervention, interventionDto);
                interventionDto.setSpeciesStadesDtos(getInterventionSpeciesStadeDtos(intervention));
                interventionDto.setActions(actionsByInterventionId.get(intervention.getTopiaId()));
                interventionDto.setInputs(inputsByInterventionId.get(intervention.getTopiaId()));
                interventionDto.setDomainId(domainCode);
                return interventionDto;
            }
        });
        List<PracticedInterventionDto> interventionDtos = Lists.newArrayList(view);

        return interventionDtos;
    }

    public void setAuthorizationService(BusinessAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setAnonymizeService(AnonymizeService anonymizeService) {
        this.anonymizeService = anonymizeService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPracticedSystemDao(PracticedSystemTopiaDao practicedSystemDao) {
        this.practicedSystemDao = practicedSystemDao;
    }

    public void setGrowingSystemDao(GrowingSystemTopiaDao growingSystemDao) {
        this.growingSystemDao = growingSystemDao;
    }

    public void setPracticedInterventionDao(PracticedInterventionTopiaDao practicedInterventionDao) {
        this.practicedInterventionDao = practicedInterventionDao;
    }

    public void setPraticedCropCycleDao(PracticedCropCycleTopiaDao praticedCropCycleDao) {
        this.praticedCropCycleDao = praticedCropCycleDao;
    }

    public void setPracticedPerennialCropCycleDao(PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleDao) {
        this.practicedPerennialCropCycleDao = practicedPerennialCropCycleDao;
    }

    public void setPracticedSeasonalCropCycleDao(PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleDao) {
        this.practicedSeasonalCropCycleDao = practicedSeasonalCropCycleDao;
    }

    public void setPracticedCropCycleConnectionDao(PracticedCropCycleConnectionTopiaDao practicedCropCycleConnectionDao) {
        this.practicedCropCycleConnectionDao = practicedCropCycleConnectionDao;
    }

    public void setPracticedCropCycleNodeDao(PracticedCropCycleNodeTopiaDao practicedCropCycleNodeDao) {
        this.practicedCropCycleNodeDao = practicedCropCycleNodeDao;
    }

    public void setRefOrientationEDIDao(RefOrientationEDITopiaDao refOrientationEDIDao) {
        this.refOrientationEDIDao = refOrientationEDIDao;
    }

    public void setRefClonePlantGrapeDao(RefClonePlantGrapeTopiaDao refClonePlantGrapeDao) {
        this.refClonePlantGrapeDao = refClonePlantGrapeDao;
    }

    public void setVarieteDao(RefVarieteTopiaDao varieteDao) {
        this.varieteDao = varieteDao;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setPracticedCropCyclePhaseDao(PracticedCropCyclePhaseTopiaDao practicedCropCyclePhaseDao) {
        this.practicedCropCyclePhaseDao = practicedCropCyclePhaseDao;
    }

    public void setCroppingPlanSpeciesDao(CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao) {
        this.croppingPlanSpeciesDao = croppingPlanSpeciesDao;
    }

    public void setToolsCouplingDao(ToolsCouplingTopiaDao toolsCouplingDao) {
        this.toolsCouplingDao = toolsCouplingDao;
    }

    public void setSolHorizonDao(SolHorizonTopiaDao solHorizonDao) {
        this.solHorizonDao = solHorizonDao;
    }

    public void setOtherActionDao(OtherActionTopiaDao otherActionDao) {
        this.otherActionDao = otherActionDao;
    }

    public void setSeedingActionDao(SeedingActionTopiaDao seedingActionDao) {
        this.seedingActionDao = seedingActionDao;
    }

    public void setHarvestingActionDao(HarvestingActionTopiaDao harvestingActionDao) {
        this.harvestingActionDao = harvestingActionDao;
    }

    public void setMineralFertilizersSpreadingActionDao(MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao) {
        this.mineralFertilizersSpreadingActionDao = mineralFertilizersSpreadingActionDao;
    }

    public void setPracticedCropCycleSpeciesDao(PracticedCropCycleSpeciesTopiaDao practicedCropCycleSpeciesDao) {
        this.practicedCropCycleSpeciesDao = practicedCropCycleSpeciesDao;
    }

    public void setPesticidesSpreadingActionDao(PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao) {
        this.pesticidesSpreadingActionDao = pesticidesSpreadingActionDao;
    }

    public void setIrrigationActionDao(IrrigationActionTopiaDao irrigationActionDao) {
        this.irrigationActionDao = irrigationActionDao;
    }

    public void setOrganicFertilizersSpreadingActionDao(OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao) {
        this.organicFertilizersSpreadingActionDao = organicFertilizersSpreadingActionDao;
    }

    public void setMaintenancePruningVinesActionDao(MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao) {
        this.maintenancePruningVinesActionDao = maintenancePruningVinesActionDao;
    }

    public void setBiologicalControlActionDao(BiologicalControlActionTopiaDao biologicalControlActionDao) {
        this.biologicalControlActionDao = biologicalControlActionDao;
    }

    public void setRefTypeTravailEDIDao(RefTypeTravailEDITopiaDao refTypeTravailEDIDao) {
        this.refTypeTravailEDIDao = refTypeTravailEDIDao;
    }

    public void setTillageActionDao(TillageActionTopiaDao tillageActionDao) {
        this.tillageActionDao = tillageActionDao;
    }

    public void setRefStadeEDIDao(RefStadeEDITopiaDao refStadeEDIDao) {
        this.refStadeEDIDao = refStadeEDIDao;
    }

    public void setPracticedSpeciesStadeDao(PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao) {
        this.practicedSpeciesStadeDao = practicedSpeciesStadeDao;
    }

    public void setInputService(InputService inputService) {
        this.inputService = inputService;
    }

    public void setInputTopiaDao(AbstractInputTopiaDao inputTopiaDao) {
        this.inputTopiaDao = inputTopiaDao;
    }

    public void setPracticedPlotDao(PracticedPlotTopiaDao practicedPlotDao) {
        this.practicedPlotDao = practicedPlotDao;
    }

    @Override
    public PracticedSystem getPracticedSystem(String practicedSystemId) {
        PracticedSystem result;
        if (Strings.isNullOrEmpty(practicedSystemId)) {
            result = practicedSystemDao.newInstance();
        } else {
            PracticedSystem practicedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
            result = anonymizeService.checkForPracticedSystemAnonymization(practicedSystem);
        }
        return result;
    }

    @Override
    public ResultList<PracticedSystem> getFilteredPracticedSystems(PracticedSystemFilter filter) {
        ResultList<PracticedSystem> result = practicedSystemDao.getFilteredPracticedSystems(filter, getSecurityContext());
        return result;
    }

    @Override
    public ResultList<PracticedSystemDto> getFilteredPracticedSystemsDto(PracticedSystemFilter filter) {
        ResultList<PracticedSystem> practicedSystems = practicedSystemDao.getFilteredPracticedSystems(filter, getSecurityContext());
        ResultList<PracticedSystemDto> result = ResultList.transform(practicedSystems, anonymizeService.getPracticedSystemToDtoFunction());
        for (PracticedSystemDto practicedSystem : result.getElements()) {
            boolean canValidate = authorizationService.isPracticedSystemValidable(practicedSystem.getTopiaId());
            practicedSystem.setUserCanValidate(canValidate);
        }
        return result;
    }

    protected List<CroppingPlanEntryDto> getCropCycleCroppingPlans(String growingSystemId, String campaigns, boolean includeCropsFromInactiveDomains) {
        List<String> domainIds = getDomainIdsForCampaigns(growingSystemId, campaigns, includeCropsFromInactiveDomains);

        List<CroppingPlanEntryDto> croppingPlans = Lists.newArrayList();
        for (String domainId : domainIds) {
            List<CroppingPlanEntryDto> croppingPlan = domainService.getCroppingPlanDtos(domainId);
            croppingPlans.addAll(croppingPlan);
        }

        return croppingPlans;
    }

    @Override
    public List<String> getToolsCouplingsFromGrowingSystemAndCampaigns(String growingSystemId, String campaigns) {
        String domainCode = getdomainCode(growingSystemId);
        Set<Integer> intCampaigns = getIntCampaigns(campaigns);
        List<String> result = domainService.getToolsCouplingCodeForDomainsAndCampaigns(domainCode, intCampaigns);

        return result;
    }

    @Override
    public List<String> getToolsCouplingsCodesFromDomainAndCampaigns(String domainCode, String campaigns) {
        Set<Integer> intCampaigns = getIntCampaigns(campaigns);
        List<String> result = domainService.getToolsCouplingCodeForDomainsAndCampaigns(domainCode, intCampaigns);

        return result;
    }

    private List<String> getDomainIdsForCampaigns(String growingSystemId, String campaigns, boolean includeCropsFromInactiveDomains) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(growingSystemId));
        List<String> result;
        String domainCode = domainService.getDomainCodeForGrowingSystem(growingSystemId);
        Set<Integer> intCampaigns = getIntCampaigns(campaigns);
        if(!intCampaigns.isEmpty()) {
            result = domainService.findDomainIdsForCodeAndCampaigns(domainCode, intCampaigns, includeCropsFromInactiveDomains);
        } else {
            result = Lists.newArrayList();
        }
        return result;
    }

    @Override
    public List<String> getCropCodesFromGrowingSystemIdForCampaigns(String growingSystemId, String campaigns) {
        Set<Integer> intCampaigns = getIntCampaigns(campaigns);
        String domainCode = domainService.getDomainCodeForGrowingSystem(growingSystemId);
        List<String> result = domainService.getCroppingPlanCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    @Override
    public List<String> getCropCodesFromDomainCodeForCampaigns(String domainCode, String campaigns) {
        Set<Integer> intCampaigns = getIntCampaigns(campaigns);
        List<String> result = domainService.getCroppingPlanCodeForDomainsAndCampaigns(domainCode, intCampaigns);
        return result;
    }

    @Override
    public Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> getCropCycleModelMap(String growingSystemId, String campaigns, boolean includeIntermediate, boolean includeCropsFromInactiveDomains) {
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> result = getCropCycleModelMap0(growingSystemId, campaigns, true, includeIntermediate, includeCropsFromInactiveDomains);
        return result;
    }

    protected Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> getCropCycleModelMap0(String growingSystemId,
                                                                                         String campaigns,
                                                                                         boolean includeSpecies,
                                                                                         boolean includeIntermediate,
                                                                                         boolean includeCropsFromInactiveDomains) {
        // TODO AThimel 06/09/13 Use includeSpecies
        List<CroppingPlanEntryDto> croppingPlans = getCropCycleCroppingPlans(growingSystemId, campaigns, includeCropsFromInactiveDomains);
        if (!includeIntermediate) {
            Iterables.removeIf(croppingPlans, CroppingPlans.IS_ENTRY_INTERMEDIATE);
        }
        ImmutableListMultimap<String, CroppingPlanEntryDto> index = Multimaps.index(croppingPlans, GET_CROPPING_PLAN_ENTRY_CODE);

        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> result = Maps.newLinkedHashMap();
        for (Map.Entry<String, Collection<CroppingPlanEntryDto>> entry : index.asMap().entrySet()) {
            Collection<CroppingPlanEntryDto> dtos = entry.getValue();
            CroppingPlanEntryDto first = dtos.iterator().next();
            CropCycleModelDto modelDto = CROPPING_PLAN_ENTRY_TO_DTO.apply(first);
            Map<String, CroppingPlanSpeciesDto> species = Maps.newLinkedHashMap();
            for (CroppingPlanEntryDto dto : dtos) {

                // Get all species
                if (dto.getSpecies() != null) {
                    species.putAll(Maps.uniqueIndex(dto.getSpecies(), CroppingPlans.GET_SPECIES_DTO_CODE));
                }

            }
            result.put(modelDto, Lists.newArrayList(species.values()));
        }
        return result;
    }

    protected List<ToolsCoupling> getConcernedToolsCouplings(String growingSystemId, String campaigns) {

        Preconditions.checkArgument(!Strings.isNullOrEmpty(growingSystemId) && !Strings.isNullOrEmpty(campaigns));

        List<ToolsCoupling> toolsCouplings = null;
        if (!campaigns.isEmpty()) {
            String domainCode = getdomainCode(growingSystemId);
            Set<Integer> intCampaigns = getIntCampaigns(campaigns);
            toolsCouplings = domainService.getToolsCouplingsForDomainCodeAndCampaigns(domainCode, intCampaigns);

        }

        return toolsCouplings;
    }

    private Set<Integer> getIntCampaigns(String campaigns) {
        Set<Integer> campaignsInt;
        try {
            campaignsInt = CommonService.GET_CAMPAIGNS_SET.apply(campaigns);
        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Unable to parse campaigns: " + campaigns, eee);
            }
            campaignsInt = Sets.newHashSet();
        }
        return campaignsInt;
    }

    @Override
    public List<CropCycleModelDto> getCropCycleModel(String growingSystemId, String campaigns, boolean includeIntermediate, boolean includeCropsFromInactiveDomains) {

        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> model = getCropCycleModelMap0(growingSystemId, campaigns, false, includeIntermediate, includeCropsFromInactiveDomains);
        List<CropCycleModelDto> result = Lists.newArrayList(model.keySet());

        return result;
    }

    @Override
    public PracticedSystem createOrUpdatePracticedSystem(PracticedSystem practicedSystem,
                                                         List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos,
                                                         List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos,
                                                         List<Price> prices) {
        authorizationService.checkCreateOrUpdatePracticedSystem(practicedSystem.getTopiaId());

        createOrUpdatePracticedSystemWithoutCommit(practicedSystem, practicedPerennialCropCycleDtos, practicedSeasonalCropCycleDtos, prices);

        getTransaction().commit();

        return practicedSystem;
    }

    protected PracticedSystem createOrUpdatePracticedSystemWithoutCommit(PracticedSystem practicedSystem, List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos, List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos, List<Price> prices) {
        // PracticedSystem practicedSystem part
        PracticedSystem result;

        practicedSystem.setCampaigns(CommonService.ARRANGE_CAMPAIGNS.apply(practicedSystem.getCampaigns()));
        practicedSystem.setUpdateDate(context.getCurrentDate());

        if (StringUtils.isBlank(practicedSystem.getTopiaId())) {
            // On create, Practiced System should be active (PracticedSystem#active = true)
            practicedSystem.setActive(true);
            result = practicedSystemDao.create(practicedSystem);
        } else {
            result = practicedSystemDao.update(practicedSystem);
        }

        List<String> practicedSystemCroppingPlanEntries = getCropCodesFromGrowingSystemIdForCampaigns(practicedSystem.getGrowingSystem().getTopiaId(), practicedSystem.getCampaigns());

        createOrUpdatePracticedPerennialCropCycle(practicedPerennialCropCycleDtos, result, Lists.newArrayList(practicedSystemCroppingPlanEntries));

        createOrUpdatePracticedSeasonalCropCycle(practicedSeasonalCropCycleDtos, result,  Lists.newArrayList(practicedSystemCroppingPlanEntries));

        updatePracticedPrices(practicedSystem, prices);

        return result;
    }

    protected void createOrUpdatePracticedSeasonalCropCycle(List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos,
                                                            PracticedSystem practicedSystem, List<String> practicedSystemCroppingPlanEntries) {

        List<PracticedSeasonalCropCycle> practicedSeasonalCropCycles = practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        Map<String, PracticedSeasonalCropCycle> practicedSeasonalCropCyclesById = Maps.newHashMap(Maps.uniqueIndex(practicedSeasonalCropCycles, TopiaEntities.getTopiaIdFunction()));

        if (practicedSeasonalCropCycleDtos != null) {
            for (PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto : practicedSeasonalCropCycleDtos) {

                // find cycle to create or update by topiaId
                String topiaId = practicedSeasonalCropCycleDto.getTopiaId();
                PracticedSeasonalCropCycle cycle;
                if (StringUtils.isBlank(topiaId)) {
                    cycle = practicedSeasonalCropCycleDao.newInstance();
                } else {
                    cycle = practicedSeasonalCropCyclesById.remove(topiaId);
                }

                // update cycle with dto data
                List<PracticedCropCycleNodeDto> nodes = practicedSeasonalCropCycleDto.getCropCycleNodeDtos();
                List<PracticedCropCycleConnectionDto> connections = practicedSeasonalCropCycleDto.getCropCycleConnectionDtos();

                createOrUpdatePracticedSeasonalCropCycle(cycle, practicedSystem, nodes, connections, practicedSystemCroppingPlanEntries);
            }
        }

        // delete remaining cycles
        for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCyclesById.values()) {
            List<PracticedCropCycleConnection> practicedCropCycleConnections = practicedCropCycleConnectionDao.findAllByCropCycle(practicedSeasonalCropCycle.getTopiaId());
            removePracticedCropCycleConnections(practicedCropCycleConnections);
            practicedSeasonalCropCycleDao.delete(practicedSeasonalCropCycle);
        }

    }

    protected void createOrUpdatePracticedPerennialCropCycle(List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos,
                                                             PracticedSystem practicedSystem, List<String> practicedSystemCroppingPlanEntries) {

        if (practicedPerennialCropCycleDtos != null) {
            List<PracticedPerennialCropCycle> practicedPerennialCropCycles = practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();

            if (practicedPerennialCropCycles == null) {
                practicedPerennialCropCycles = Lists.newArrayList();
            }
            Map<String, PracticedPerennialCropCycle> immutCurrentPracticedPerennialCropCycles = Maps.uniqueIndex(practicedPerennialCropCycles, Entities.GET_TOPIA_ID);
            Map<String, PracticedPerennialCropCycle> currentPracticedPerennialCropCycles = Maps.newHashMap(immutCurrentPracticedPerennialCropCycles);

            String domainName = practicedSystem.getGrowingSystem().getGrowingPlan().getDomain().getName();

            for (PracticedPerennialCropCycleDto practicedPerennialCropCycleDto : practicedPerennialCropCycleDtos) {

                PracticedPerennialCropCycle newPracticedPerennialCropCycle = practicedPerennialCropCycleDto.getPracticedPerennialCropCycle();

                // valid that crop exists on domain
                Preconditions.checkArgument(
                        newPracticedPerennialCropCycle != null &&
                                StringUtils.isNotBlank(newPracticedPerennialCropCycle.getCroppingPlanEntryCode()) &&
                                practicedSystemCroppingPlanEntries.contains(newPracticedPerennialCropCycle.getCroppingPlanEntryCode()), String.format("The croppingPlanEntry with the code %s was not found on domain %s for campaigns %s", newPracticedPerennialCropCycle == null ? "unknown" : newPracticedPerennialCropCycle.getCroppingPlanEntryCode(), domainName, practicedSystem.getCampaigns()));

                String cycleTopiaId = newPracticedPerennialCropCycle.getTopiaId();

                PracticedPerennialCropCycle cycle = currentPracticedPerennialCropCycles.remove(cycleTopiaId);
                if (cycle == null) {
                    cycle = practicedPerennialCropCycleDao.newInstance();
                }

                List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos = practicedPerennialCropCycleDto.getCropCyclePhaseDtos();
                List<String> croppingPlanSpeciesIds = practicedPerennialCropCycleDto.getCroppingPlanSpeciesIds();
                List<PracticedCropCycleSpeciesDto> cropCyclePerennialSpeciesDto = practicedPerennialCropCycleDto.getSpeciesDto();

                Binder<PracticedPerennialCropCycle, PracticedPerennialCropCycle> binder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
                binder.copyExcluding(newPracticedPerennialCropCycle, cycle,
                        PracticedPerennialCropCycle.PROPERTY_TOPIA_ID,
                        PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES,
                        PracticedPerennialCropCycle.PROPERTY_PRACTICED_CROP_CYCLE_SPECIES);
                createOrUpdatePracticedPerenniaCropCycle(cycle, practicedSystem, cropCyclePhaseDtos, croppingPlanSpeciesIds, cropCyclePerennialSpeciesDto);
            }
            // cycle to remove
            for (PracticedPerennialCropCycle practicedPerennialCropCycle : currentPracticedPerennialCropCycles.values()) {
                removePracticedCropCyclePhasesChildrenObjects(practicedPerennialCropCycle.getCropCyclePhases());
            }
            practicedPerennialCropCycleDao.deleteAll(currentPracticedPerennialCropCycles.values());
        } else {
            removePracticedPerenniaCropCycle(practicedSystem);
        }
    }

    protected void updatePracticedPrices(PracticedSystem practicedSystem, List<Price> prices) {
        pricesService.updatePrices(prices, null, practicedSystem);
    }

    @Override
    public List<ToolsCouplingDto> getToolsCouplingModel(String growingSystemId, String campaigns, AgrosystInterventionType interventionType) {
        Map<String, ToolsCouplingDto> allCampaignsToolsCouplings = Maps.newHashMap();
        List<ToolsCoupling> toolsCouplings = getConcernedToolsCouplings(growingSystemId, campaigns);
        if (toolsCouplings != null) {
            for (ToolsCoupling toolsCoupling : toolsCouplings) {
                boolean found = false;
                for (RefInterventionAgrosystTravailEDI mainAction : toolsCoupling.getMainsActions()) {
                    if (mainAction.getIntervention_agrosyst() == interventionType) {
                        found = true;
                        break;
                    }
                }
                if (found) {
                    String code = toolsCoupling.getCode();
                    if (!allCampaignsToolsCouplings.containsKey(code)) {
                        ToolsCouplingDto dto = Equipments.TOOLS_COUPLING_TO_TOOLS_COUPLING_DTO.apply(toolsCoupling);
                        allCampaignsToolsCouplings.put(code, dto);
                    }
                }
            }
        }

        List<ToolsCouplingDto> result = Lists.newArrayList(allCampaignsToolsCouplings.values());
        return result;
    }

    @Override
    public List<PracticedPerennialCropCycleDto> getAllPracticedPerennialCropCycles(String practicedSystemId) {
        PracticedSystem practicedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        List<PracticedPerennialCropCycle> perennialCropCycles = practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        List<PracticedPerennialCropCycleDto> result = convertPerennialCropCyclesToDto(perennialCropCycles, practicedSystem);
        return result;
    }

    protected List<PracticedPerennialCropCycleDto> convertPerennialCropCyclesToDto(
            List<PracticedPerennialCropCycle> practicedPerennialCropCycles, PracticedSystem practicedSystem) {

        List<PracticedPerennialCropCycleDto> result = Lists.newArrayList();

        for (PracticedPerennialCropCycle perennialCropCycle : practicedPerennialCropCycles) {
            PracticedPerennialCropCycleDto dto = new PracticedPerennialCropCycleDto();

            PracticedPerennialCropCycle lightPracticedPerennialCropCycle = new PracticedPerennialCropCycleImpl();
            Binder<PracticedPerennialCropCycle, PracticedPerennialCropCycle> binder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
            binder.copyExcluding(perennialCropCycle, lightPracticedPerennialCropCycle,
                    PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES,
                    PracticedPerennialCropCycle.PROPERTY_PRACTICED_CROP_CYCLE_SPECIES
            );

            dto.setPracticedPerennialCropCycle(lightPracticedPerennialCropCycle);
            String cpEntryCode = perennialCropCycle.getCroppingPlanEntryCode();
            dto.setCroppingPlanEntryName(getCroppingPlanEntryName(cpEntryCode));

            List<PracticedCropCyclePhaseDto> phases =  getPhasesDTOs(perennialCropCycle);
            dto.setCropCyclePhaseDtos(phases);

            List<PracticedCropCycleSpeciesDto> species = getCropCyclePerennialSpecies(
                    cpEntryCode, perennialCropCycle, practicedSystem.getCampaigns());
            dto.setSpeciesDto(species);

            result.add(dto);
        }
        return result;
    }

    @Override
    public List<PracticedSeasonalCropCycleDto> getAllPracticedSeasonalCropCycles(String practicedSystemId) {
        PracticedSystem practicedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        List<PracticedSeasonalCropCycle> seasonalCropCycles = practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
//        List<PracticedSeasonalCropCycleDto> result = convertSeasonalCropCyclesToDtoOriginal(seasonalCropCycles);
        List<PracticedSeasonalCropCycleDto> result = convertSeasonalCropCyclesToDto(seasonalCropCycles);
        return result;
    }

    protected static Map<PracticedCropCycleConnection, List<PracticedIntervention>> getInterventionsByConnection(List<PracticedIntervention> interventions) {
        Map<PracticedCropCycleConnection, List<PracticedIntervention>> interventionsByConnection = Maps.newHashMap();
        for (PracticedIntervention intervention : interventions) {
            List<PracticedIntervention> interventionsForConnection = interventionsByConnection.get(intervention.getPracticedCropCycleConnection());
            if (interventionsForConnection == null) {
                interventionsForConnection = Lists.newArrayList();
                interventionsByConnection.put(intervention.getPracticedCropCycleConnection(), interventionsForConnection);
            }
            interventionsForConnection.add(intervention);
        }
        return interventionsByConnection;
    }

    protected static Map<String, List<PracticedCropCycleConnection>> getConnexionsByCycleId(List<PracticedCropCycleConnection> connections) {
        Map<String, List<PracticedCropCycleConnection>> connectionsByCycleId = Maps.newHashMap();
        for (PracticedCropCycleConnection connection : connections) {
            String cycleId = connection.getTarget().getPracticedSeasonalCropCycle().getTopiaId();
            List<PracticedCropCycleConnection> cropCycleConnections = connectionsByCycleId.get(cycleId);
            if (cropCycleConnections == null) {
                cropCycleConnections = Lists.newArrayList();
                connectionsByCycleId.put(cycleId, cropCycleConnections);
            }
            cropCycleConnections.add(connection);
        }
        return connectionsByCycleId;
    }

    /**
     * Convert database seasonal entity to dto.
     */
    protected List<PracticedSeasonalCropCycleDto> convertSeasonalCropCyclesToDto(List<PracticedSeasonalCropCycle> practicedSeasonalCropCycles) {
        // Exécution convertSeasonalCropCyclesToDto() en:43617ms
        // Exécution convertSeasonalCropCyclesToDtoOriginal() en:5298ms
        long begin = System.currentTimeMillis();

        List<PracticedSeasonalCropCycleDto> result = Lists.newArrayList();

        Map<String, PracticedSeasonalCropCycle> practicedSeasonalCropCycleByIds = Maps.uniqueIndex(practicedSeasonalCropCycles, Entities.GET_TOPIA_ID);
        Set<String> practicedSystemIds = practicedSeasonalCropCycleByIds.keySet();

        if (CollectionUtils.isNotEmpty(practicedSystemIds)) {
            List<PracticedCropCycleConnection> connections = practicedCropCycleConnectionDao.findAllByCropCycles(practicedSystemIds);
            Map<String, List<PracticedCropCycleConnection>> connectionsByCycleId = getConnexionsByCycleId(connections);

            List<PracticedIntervention> interventions = practicedInterventionDao.forPracticedCropCycleConnectionIn(connections).setOrderByArguments(PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, PracticedIntervention.PROPERTY_RANK).findAll();

            Map<PracticedCropCycleConnection, List<PracticedIntervention>> interventionsByConnection = getInterventionsByConnection(interventions);

            List<AbstractAction> abstractActions = abstractActionDao.forPracticedInterventionIn(interventions).findAll();
            Map<String, List<AbstractAction>> actionsByInterventionId = getActionsByIntervention(abstractActions);

            Map<String, List<AbstractInput>> inputsByInterventionId = Maps.newHashMap();
            for (PracticedIntervention intervention : interventions) {
                inputsByInterventionId.put(intervention.getTopiaId(), inputTopiaDao.findAllByPracticedIntervention(intervention));
            }

            for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCycles) {
                String domainCode = practicedSeasonalCropCycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();

                PracticedSeasonalCropCycleDto dto = new PracticedSeasonalCropCycleDto();
                dto.setTopiaId(practicedSeasonalCropCycle.getTopiaId());

                // graph data for each cycle
                List<PracticedCropCycleNodeDto> nodes = Lists.newArrayList();
                Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> nodesToSpecies = getNodesForCycle(practicedSeasonalCropCycle);
                for (Map.Entry<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> entry : nodesToSpecies.entrySet()) {
                    PracticedCropCycleNodeDto cycleNodeDto = entry.getKey();
                    nodes.add(cycleNodeDto);
                }
                dto.setCropCycleNodeDtos(nodes);

                List<PracticedCropCycleConnection> cycleConnections = connectionsByCycleId.get(practicedSeasonalCropCycle.getTopiaId());
                List<PracticedCropCycleConnectionDto> connectionDtos = Lists.newArrayList();

                for (PracticedCropCycleConnection connection : cycleConnections) {
                    PracticedCropCycleConnectionDto connectionDto = PracticedSystems.CROP_CYCLE_CONNECTION_TO_DTO.apply(connection);

                    // add all connection interventions
                    List<PracticedIntervention> connectionInterventions = interventionsByConnection.get(connection);
                    if (connectionInterventions != null) {
                        List<PracticedInterventionDto> interventionDtos = practicedInterventionToInterventionDtos(domainCode, connectionInterventions, actionsByInterventionId, inputsByInterventionId);
                        connectionDto.setInterventions(interventionDtos);
                    }
                    // add connection
                    connectionDtos.add(connectionDto);
                }

                dto.setCropCycleConnectionDtos(connectionDtos);

                // add dto
                result.add(dto);
            }
        }

        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.info("Exécution convertSeasonalCropCyclesToDto() en:" + (end - begin) + "ms");
        }
        return result;
    }

    // TODO Dcossé Remove it if convertSeasonalCropCyclesToDto() validated
    @Deprecated
    protected List<PracticedSeasonalCropCycleDto> convertSeasonalCropCyclesToDtoOriginal(
            List<PracticedSeasonalCropCycle> practicedSeasonalCropCycles) {

        long begin = System.currentTimeMillis();
        List<PracticedSeasonalCropCycleDto> result = Lists.newArrayList();

        for (PracticedSeasonalCropCycle practicedSeasonalCropCycle : practicedSeasonalCropCycles) {
            String domainCode = practicedSeasonalCropCycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();

            PracticedSeasonalCropCycleDto dto = new PracticedSeasonalCropCycleDto();
            dto.setTopiaId(practicedSeasonalCropCycle.getTopiaId());

            // graph data for each cycle
            List<PracticedCropCycleNodeDto> nodes = Lists.newArrayList();
            Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> nodesToSpecies = getNodes(practicedSeasonalCropCycle.getTopiaId());
            for (Map.Entry<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> entry : nodesToSpecies.entrySet()) {
                PracticedCropCycleNodeDto cycleNodeDto = entry.getKey();
                nodes.add(cycleNodeDto);
            }
            dto.setCropCycleNodeDtos(nodes);
            List<PracticedCropCycleConnectionDto> connections = getConnectionDTOs(practicedSeasonalCropCycle.getTopiaId(), domainCode);
            dto.setCropCycleConnectionDtos(connections);

            // add dto
            result.add(dto);
        }

        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.info("Exécution convertSeasonalCropCyclesToDtoOriginal() en:" + (end - begin) + "ms");
        }        return result;
    }

    @Override
    public PracticedSeasonalCropCycle getPracticedSeasonalCropCycle(String cycleId) {
        PracticedSeasonalCropCycle result;
        if (Strings.isNullOrEmpty(cycleId)) {
            result = practicedSeasonalCropCycleDao.newInstance();
        } else {
            result = practicedSeasonalCropCycleDao.forTopiaIdEquals(cycleId).findUniqueOrNull();
        }
        Preconditions.checkState(result != null, "Expected PracticedSeasonalCropCycle not found: " + cycleId);
        return result;
    }

    @Override
    public PracticedPerennialCropCycle getPracticedPerennialCropCycle(String cycleId) {
        PracticedPerennialCropCycle result;
        if (Strings.isNullOrEmpty(cycleId)) {
            result = practicedPerennialCropCycleDao.newInstance();
        } else {
            result = practicedPerennialCropCycleDao.forTopiaIdEquals(cycleId).findUnique();
        }

        Preconditions.checkState(result != null, "Expected practicedPerennialCropCycle not found: " + cycleId);
        return result;
    }


    protected PracticedSeasonalCropCycle createOrUpdatePracticedSeasonalCropCycle(PracticedSeasonalCropCycle cycle,
                                                                                  PracticedSystem practicedSystem,
                                                                                  List<PracticedCropCycleNodeDto> nodes,
                                                                                  List<PracticedCropCycleConnectionDto> connections,
                                                                                  List<String> practicedSystemCroppingPlanEntries) {

        Preconditions.checkNotNull(cycle);
        Preconditions.checkNotNull(nodes);
        Preconditions.checkNotNull(connections);

        PracticedSeasonalCropCycle result;

        // Make multimap of current connections
        MultiKeyMap<String, PracticedCropCycleConnection> cycleConnBySourceTarget = new MultiKeyMap<String, PracticedCropCycleConnection>();

        if (!cycle.isPersisted()) {
            Preconditions.checkNotNull(practicedSystem);
            cycle.setPracticedSystem(practicedSystem);
            result = practicedSeasonalCropCycleDao.create(cycle);
        } else {
            result = practicedSeasonalCropCycleDao.update(cycle);
            List<PracticedCropCycleConnection> cycleConnections = practicedCropCycleConnectionDao.findAllByCropCycle(result.getTopiaId());
            for (PracticedCropCycleConnection conn : cycleConnections) {
                cycleConnBySourceTarget.put(conn.getSource().getTopiaId(), conn.getTarget().getTopiaId(), conn);
            }
        }

        Domain domain = cycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain();
        String domainCode = domain.getCode();

        // Make sure list is not empty to avoid breaking code
        if (cycle.getCropCycleNodes() == null) {
            cycle.setCropCycleNodes(new ArrayList<PracticedCropCycleNode>());
        }

        final Map<String, PracticedCropCycleNode> nodeIdToEntity = Maps.newHashMap();

        // manage cycle nodes
        Collection<PracticedCropCycleNode> cycleNodes = cycle.getCropCycleNodes();
        if (cycleNodes == null) {
            cycleNodes = Lists.newArrayList();
            cycle.setCropCycleNodes(cycleNodes);
        }

        for (PracticedCropCycleNodeDto dtoNode : nodes) {
            String croppingPlanEntryCode = dtoNode.getCroppingPlanEntryCode();
            Preconditions.checkArgument(practicedSystemCroppingPlanEntries.contains(croppingPlanEntryCode), String.format("The croppingPlanEntry with the code %s was not found on domain %s for campaigns %s", croppingPlanEntryCode, domain.getName(), practicedSystem.getCampaigns()));

            String nodeId = Entities.UNESCAPE_TOPIA_ID.apply(dtoNode.getNodeId());
            PracticedCropCycleNode entityNode;
            if (nodeId.startsWith(NEW_NODE)) {
                entityNode = practicedCropCycleNodeDao.newInstance();
                entityNode.setCroppingPlanEntryCode(croppingPlanEntryCode);
                // the node is added to the practicedSeasonalCropCycle nodes collection
                result.addCropCycleNodes(entityNode);
            } else {
                entityNode = TopiaEntities.findByTopiaId(cycle.getCropCycleNodes(), nodeId);
            }
            entityNode.setRank(dtoNode.getX());
            entityNode.setY(dtoNode.getY());
            entityNode.setEndCycle(dtoNode.isEndCycle());
            entityNode.setSameCampaignAsPreviousNode(dtoNode.isSameCampaignAsPreviousNode());
            entityNode.setInitNodeFrequency(dtoNode.getInitNodeFrequency());

            PracticedCropCycleNode persistentNode;
            if (entityNode.isPersisted()) {
                persistentNode = practicedCropCycleNodeDao.update(entityNode);
            } else {
                persistentNode = practicedCropCycleNodeDao.create(entityNode);
            }

            nodeIdToEntity.put(nodeId, persistentNode);
        }

        for (PracticedCropCycleConnectionDto connectionDto : connections) {
            if (StringUtils.isNotBlank(connectionDto.getIntermediateCroppingPlanEntryCode())) {
                Preconditions.checkArgument(practicedSystemCroppingPlanEntries.contains(connectionDto.getIntermediateCroppingPlanEntryCode()) , "The croppingPlanEntry with the code:" + connectionDto.getIntermediateCroppingPlanEntryCode() + " was not found");
            }
            Preconditions.checkArgument(StringUtils.isNotBlank(connectionDto.getSourceId()));
            Preconditions.checkArgument(StringUtils.isNotBlank(connectionDto.getTargetId()));

            String sourceId = Entities.UNESCAPE_TOPIA_ID.apply(connectionDto.getSourceId());
            String targetId = Entities.UNESCAPE_TOPIA_ID.apply(connectionDto.getTargetId());

            List<PracticedIntervention> interventions = Lists.newArrayList();

            // get from cache and removed if (still exists to be not deleted after loop)
            PracticedCropCycleConnection connection = cycleConnBySourceTarget.removeMultiKey(sourceId, targetId);
            if (connection == null) {
                PracticedCropCycleNode sourceNode = nodeIdToEntity.get(sourceId);
                if (sourceNode == null) {
                    sourceNode = practicedCropCycleNodeDao.forTopiaIdEquals(sourceId).findUnique();
                }

                PracticedCropCycleNode targetNode = nodeIdToEntity.get(targetId);
                if (targetNode == null) {
                    targetNode = practicedCropCycleNodeDao.forTopiaIdEquals(targetId).findUnique();
                }

                connection = practicedCropCycleConnectionDao.create(PracticedCropCycleConnection.PROPERTY_SOURCE, sourceNode,
                        PracticedCropCycleConnection.PROPERTY_TARGET, targetNode);
            } else {
                interventions = this.getCropCycleNodeConnectionInterventions(connection);
            }

            // culuture intermédiaire de la connexion
            connection.setIntermediateCroppingPlanEntryCode(connectionDto.getIntermediateCroppingPlanEntryCode());
            connection.setCroppingPlanEntryFrequency(connectionDto.getCroppingPlanEntryFrequency());
            connection.setNotUsedForThisCampaign(connectionDto.isNotUsedForThisCampaign());

            convertSeasonalInterventionDto(interventions, connection, connectionDto, domainCode);
        }

        // connections have first to be removed
        Set<PracticedCropCycleConnection> unusedPracticedCropCycleConnections = new HashSet<PracticedCropCycleConnection>(cycleConnBySourceTarget.values());
        Collection<PracticedCropCycleNode> toDeleteNodes = CollectionUtils.subtract(cycleNodes, nodeIdToEntity.values());
        for (PracticedCropCycleNode nodeToDelete : toDeleteNodes) {
            unusedPracticedCropCycleConnections.addAll(practicedCropCycleConnectionDao.forTargetEquals(nodeToDelete).findAll());
            unusedPracticedCropCycleConnections.addAll(practicedCropCycleConnectionDao.forSourceEquals(nodeToDelete).findAll());

        }
        removePracticedCropCycleConnections(unusedPracticedCropCycleConnections);

        // delete node (after connections)
        cycleNodes.retainAll(nodeIdToEntity.values());

        return result;
    }

    protected PracticedPerennialCropCycle createOrUpdatePracticedPerenniaCropCycle(PracticedPerennialCropCycle cycle,
                                                                                   PracticedSystem practicedSystem,
                                                                                   List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos,
                                                                                   List<String> croppingPlanSpeciesIds,
                                                                                   List<PracticedCropCycleSpeciesDto> cropCyclePerennialSpeciesDtos) {

        Preconditions.checkNotNull(cycle);
        Preconditions.checkNotNull(practicedSystem);
        Preconditions.checkNotNull(cropCyclePhaseDtos);
        Preconditions.checkArgument(cropCyclePhaseDtos.size() > 0);

        PracticedPerennialCropCycle result;

        cycle.setPracticedSystem(practicedSystem);
        Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> phasesDtoPhase = convertCropCyclePhaseDto(cropCyclePhaseDtos, cycle);

        if (cycle.isPersisted()) {
            result = practicedPerennialCropCycleDao.update(cycle);
        } else {
            result = practicedPerennialCropCycleDao.create(cycle);
        }

        convertCropCyclePerennialSpeciesDto(cropCyclePerennialSpeciesDtos, result);

        String domainCode = result.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
        convertPerenialInterventionDto(phasesDtoPhase, domainCode);

        return result;
    }

    protected void removePracticedCropCycleConnections(Collection<PracticedCropCycleConnection> practicedCropCycleConnections) {
        if (practicedCropCycleConnections != null) {
            for (PracticedCropCycleConnection practicedCropCycleConnection : practicedCropCycleConnections) {
                List<PracticedIntervention> practicedInterventions = practicedInterventionDao.forPracticedCropCycleConnectionEquals(practicedCropCycleConnection).findAll();
                removePracticedInterventions(practicedInterventions);
            }
            practicedCropCycleConnectionDao.deleteAll(practicedCropCycleConnections);
        }
    }

    protected void removePracticedPerenniaCropCycle(PracticedSystem practicedSystem) {
        List<PracticedPerennialCropCycle> practicedPerennialCropCycles = practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        if (practicedPerennialCropCycles != null) {
            for (PracticedPerennialCropCycle practicedPerennialCropCycle : practicedPerennialCropCycles) {
                Collection<PracticedCropCyclePhase> practicedCropCyclePhases = practicedPerennialCropCycle.getCropCyclePhases();
                removePracticedCropCyclePhasesChildrenObjects(practicedCropCyclePhases);
            }
            practicedPerennialCropCycleDao.deleteAll(practicedPerennialCropCycles);
        }
    }

    protected void removePracticedCropCyclePhasesChildrenObjects(Collection<PracticedCropCyclePhase> practicedCropCyclePhases) {
        // practicedCropCyclePhases ne peut être null
        for (PracticedCropCyclePhase practicedCropCyclePhase : practicedCropCyclePhases) {
            List<PracticedIntervention> practicedInterventions = practicedInterventionDao.forPracticedCropCyclePhaseEquals(practicedCropCyclePhase).findAll();
            removePracticedInterventions(practicedInterventions);
        }
    }

    protected void removePracticedCropCycleSpecies(Collection<PracticedCropCycleSpecies> allPracticedCropCycleSpecies) {
        if (allPracticedCropCycleSpecies != null) {
            practicedCropCycleSpeciesDao.deleteAll(allPracticedCropCycleSpecies);
        }

    }

    protected void removePracticedInterventions(Collection<PracticedIntervention> practicedInterventions) {
        if (practicedInterventions != null) {
            List<AbstractInput> allInputsToRemove = Lists.newArrayList();
            List<AbstractAction> allActionsToRemove = Lists.newArrayList();
            for (PracticedIntervention practicedIntervention : practicedInterventions) {
                List<AbstractInput> abstractInputs = inputTopiaDao.findAllByPracticedIntervention(practicedIntervention);
                if (abstractInputs != null) {
                    allInputsToRemove.addAll(abstractInputs);
                }

                List<AbstractAction> abstractActions = abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();
                // ne peut-être null
                allActionsToRemove.addAll(abstractActions);

            }
            inputTopiaDao.deleteAll(allInputsToRemove);
            practicedInterventionDao.deleteAll(practicedInterventions);
            abstractActionDao.deleteAll(allActionsToRemove);
        }
    }

    protected void convertCropCyclePerennialSpeciesDto(List<PracticedCropCycleSpeciesDto> speciesDtos, PracticedPerennialCropCycle cycle) {
        Collection<PracticedCropCycleSpecies> currentSpecies = cycle.getPracticedCropCycleSpecies();
        Collection<PracticedCropCycleSpecies> nonDeleted = Lists.newArrayList();
        if (currentSpecies == null) {
            currentSpecies = Lists.newArrayList();
            cycle.setPracticedCropCycleSpecies(currentSpecies);
        }

        // update list with dto
        Map<String, PracticedCropCycleSpecies> currentSpeciesMap = Maps.uniqueIndex(currentSpecies, new Function<PracticedCropCycleSpecies, String>() {
            @Override
            public String apply(PracticedCropCycleSpecies input) {
                return input.getCroppingPlanSpeciesCode();
            }
        });

        if (speciesDtos != null) {
            for (PracticedCropCycleSpeciesDto cropCyclePerennialSpeciesDto : speciesDtos) {
                String code = cropCyclePerennialSpeciesDto.getCode();
                PracticedCropCycleSpecies cropCyclePerennialSpecies = currentSpeciesMap.get(code);
                if (cropCyclePerennialSpecies == null) {
                    cropCyclePerennialSpecies = practicedCropCycleSpeciesDao.newInstance();
                    cropCyclePerennialSpecies.setCroppingPlanSpeciesCode(code);
                    cropCyclePerennialSpecies.setCycle(cycle);
                    cycle.addPracticedCropCycleSpecies(cropCyclePerennialSpecies);
                }

                cropCyclePerennialSpecies.setPlantsCertified(cropCyclePerennialSpeciesDto.isPlantCertified());
                cropCyclePerennialSpecies.setOverGraftDate(cropCyclePerennialSpeciesDto.getOverGraftDate());

                if (cropCyclePerennialSpeciesDto.getGraftClone() != null) {
                    String graftTopiaId = cropCyclePerennialSpeciesDto.getGraftClone().getTopiaId();
                    if (StringUtils.isNotBlank(graftTopiaId)) {
                        RefClonePlantGrape clonePlantGrape = refClonePlantGrapeDao.forTopiaIdEquals(graftTopiaId).findUnique();
                        cropCyclePerennialSpecies.setGraftClone(clonePlantGrape);
                    }
                }
                if (cropCyclePerennialSpeciesDto.getGraftSupport() != null) {
                    String graftTopiaId = cropCyclePerennialSpeciesDto.getGraftSupport().getTopiaId();
                    if (StringUtils.isNotBlank(graftTopiaId)) {
                        RefVariete variete = varieteDao.forTopiaIdEquals(graftTopiaId).findUnique();
                        cropCyclePerennialSpecies.setGraftSupport(variete);
                    }
                }

                if (cropCyclePerennialSpecies.isPersisted()) {
                    practicedCropCycleSpeciesDao.update(cropCyclePerennialSpecies);
                } else {
                    practicedCropCycleSpeciesDao.create(cropCyclePerennialSpecies);
                }
                nonDeleted.add(cropCyclePerennialSpecies);
            }
        }
        currentSpecies.retainAll(nonDeleted);
    }

    protected Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> convertCropCyclePhaseDto(List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos, PracticedPerennialCropCycle cycle) {
        Collection<PracticedCropCyclePhase> currentPhases = cycle.getCropCyclePhases();
        if (currentPhases == null) {
            currentPhases = Lists.newArrayList();
            cycle.setCropCyclePhases(currentPhases);
        }

        Map<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> result = Maps.newHashMap();
        // update list with dto
        Map<String, PracticedCropCyclePhase> immutCurrentPhasesMap = Maps.uniqueIndex(currentPhases, Entities.GET_TOPIA_ID);
        Map<String, PracticedCropCyclePhase> currentPhasesMap = Maps.newHashMap(immutCurrentPhasesMap);

        // there is at least one CropCyclePhase
        for (PracticedCropCyclePhaseDto cropCyclePhaseDto : cropCyclePhaseDtos) {
            String phaseId = cropCyclePhaseDto.getTopiaId();
            PracticedCropCyclePhase phase;
            if (StringUtils.isBlank(phaseId)) {
                phase = practicedCropCyclePhaseDao.newInstance();
            } else {
                phase = currentPhasesMap.remove(phaseId);
            }
            result.put(cropCyclePhaseDto, phase);

            phase.setType(cropCyclePhaseDto.getType());
            phase.setDuration(cropCyclePhaseDto.getDuration());
            if (StringUtils.isBlank(phaseId)) {
                currentPhases.add(phase);
            }
        }

        removePracticedCropCyclePhasesChildrenObjects(currentPhasesMap.values());
        currentPhases.removeAll(currentPhasesMap.values());

        return result;
    }

    protected void convertSeasonalInterventionDto(List<PracticedIntervention> interventions,
                                                  PracticedCropCycleConnection persistentConnection,
                                                  PracticedCropCycleConnectionDto connectionDto,
                                                  String domainCode) {

        List<PracticedInterventionDto> interventionDtos = connectionDto.getInterventions();
        boolean intermediateCrop = !Strings.isNullOrEmpty(connectionDto.getIntermediateCroppingPlanEntryCode());
        convertIntervention(interventionDtos, interventions, null, persistentConnection, domainCode, intermediateCrop);
    }

    protected void convertPerenialInterventionDto(Map<PracticedCropCyclePhaseDto,
            PracticedCropCyclePhase> phaseDtosPhases,
                                                  String domainCode) {

        for (Map.Entry<PracticedCropCyclePhaseDto, PracticedCropCyclePhase> phasesDtoEntry : phaseDtosPhases.entrySet()) {
            PracticedCropCyclePhaseDto phasesDto = phasesDtoEntry.getKey();
            PracticedCropCyclePhase phase = phasesDtoEntry.getValue();

            List<PracticedInterventionDto> interventionDtos = phasesDto.getInterventions();
            List<PracticedIntervention> interventions = getCropCyclePhaseInterventions(phase);

            convertIntervention(interventionDtos, interventions, phase, null, domainCode, false);
        }
    }

    protected Set<String> getInterventionSpecies(PracticedIntervention practicedIntervention) {
        Set<String> speciesCodes = new HashSet<String>();
        if (practicedIntervention != null) {
            Collection<PracticedSpeciesStade> pss = practicedIntervention.getSpeciesStades();
            if (pss != null) {
                for (PracticedSpeciesStade ps : pss) {
                    speciesCodes.add(ps.getSpeciesCode());
                }
            }
        }
        return speciesCodes;
    }

    protected void convertIntervention(List<PracticedInterventionDto> interventionDtos,
                                       List<PracticedIntervention> interventions, PracticedCropCyclePhase phase,
                                       PracticedCropCycleConnection connection, String domainCode, boolean intermediateCrop) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }

        // remove new interventionDtos witch domainId doesn't match the domain code.
        if (interventionDtos != null) {
            Iterator<PracticedInterventionDto> validInterventionDtos = interventionDtos.iterator();
            while(validInterventionDtos.hasNext()) {
                PracticedInterventionDto interventionDto = validInterventionDtos.next();
                if (Strings.isNullOrEmpty(interventionDto.getTopiaId()) && (Strings.isNullOrEmpty(interventionDto.getDomainId()) ||
                        !interventionDto.getDomainId().equals(domainCode))) {
                    validInterventionDtos.remove();
                }
            }
        }

        Map<String, PracticedIntervention> imutCurrentInterventionsMap = Maps.uniqueIndex(interventions, Entities.GET_TOPIA_ID);
        Map<String, PracticedIntervention> currentInterventionsMap = Maps.newHashMap(imutCurrentInterventionsMap);

        if (interventionDtos != null && !interventionDtos.isEmpty()) {

            for (int i = 0; i < interventionDtos.size(); i++) {
                // reordered interventions according the position into the list
                PracticedInterventionDto interventionDto = interventionDtos.get(i);
                interventionDto.setRank(i);

                if (!intermediateCrop) {
                    interventionDto.setIntermediateCrop(false);
                }

                PracticedIntervention intervention = null;

                if (!StringUtils.isBlank(interventionDto.getTopiaId())) {
                    intervention = currentInterventionsMap.remove(interventionDto.getTopiaId());
                }

                if (intervention == null) {
                    intervention = practicedInterventionDao.newInstance();
                }

                addAllSpeciesStades(intervention, interventionDto);
                interventionDto.setPracticedCropCyclePhase(phase);
                interventionDto.setPracticedCropCycleConnection(connection);

                Binder<PracticedIntervention, PracticedIntervention> binder = BinderFactory.newBinder(PracticedIntervention.class);
                binder.copyExcluding(interventionDto, intervention,
                        PracticedIntervention.PROPERTY_TOPIA_ID,
                        PracticedIntervention.PROPERTY_TOPIA_CREATE_DATE,
                        PracticedIntervention.PROPERTY_TOPIA_VERSION,
                        PracticedIntervention.PROPERTY_SPECIES_STADES);

                PracticedIntervention persistedIntervention;
                if (intervention.isPersisted()) {
                    persistedIntervention = practicedInterventionDao.update(intervention);
                    Set<String> speciesCodes = getInterventionSpecies(persistedIntervention);
                    Map<String, AbstractAction> actions = actionService.updatePracticedInterventionActions(persistedIntervention, interventionDto.getActions(), speciesCodes);
                    inputService.updateInterventionInputs(persistedIntervention, null, interventionDto.getInputs(), actions);
                } else {
                    persistedIntervention = practicedInterventionDao.create(intervention);
                    interventions.add(persistedIntervention);
                    Set<String> speciesCodes = getInterventionSpecies(persistedIntervention);
                    Map<String, AbstractAction> actions = actionService.createPracticedInterventionActions(persistedIntervention, interventionDto.getActions(), speciesCodes);
                    inputService.updateInterventionInputs(persistedIntervention, null, interventionDto.getInputs(), actions);
                }
            }

        }

        removePracticedInterventions(currentInterventionsMap.values());
    }

    protected void addAllSpeciesStades(PracticedIntervention intervention, PracticedInterventionDto interventionDto) {
        List<SpeciesStadeDto> speciesStadesDtos = interventionDto.getSpeciesStadesDtos();

        Collection<PracticedSpeciesStade> allOriginalSpeciesStades = intervention.getSpeciesStades();
        if (allOriginalSpeciesStades == null) {
            allOriginalSpeciesStades = Lists.newArrayList();
            intervention.setSpeciesStades(allOriginalSpeciesStades);
        }

        List<PracticedSpeciesStade> nonDeleted = Lists.newArrayList();

        if (speciesStadesDtos != null && !speciesStadesDtos.isEmpty()) {

            Map<String, PracticedSpeciesStade> allOriginalSpeciesStadesMap = Maps.uniqueIndex(allOriginalSpeciesStades, Entities.GET_TOPIA_ID);

            for (SpeciesStadeDto speciesStadeDto : speciesStadesDtos) {

                PracticedSpeciesStade editedSpeciesStades;

                if (StringUtils.isBlank(speciesStadeDto.getTopiaId())) {
                    editedSpeciesStades = practicedSpeciesStadeDao.newInstance();
                    allOriginalSpeciesStades.add(editedSpeciesStades);
                } else {
                    editedSpeciesStades = allOriginalSpeciesStadesMap.get(speciesStadeDto.getTopiaId());
                    if (editedSpeciesStades == null) {
                        editedSpeciesStades = practicedSpeciesStadeDao.forTopiaIdEquals(speciesStadeDto.getTopiaId()).findUnique();
                        allOriginalSpeciesStades.add(editedSpeciesStades);
                    }
                }

                editedSpeciesStades.setSpeciesCode(speciesStadeDto.getSpeciesCode());
                // if there are no sepciesStadeMin
                if (speciesStadeDto.getStadeMin() == null) {
                    editedSpeciesStades.setStadeMin(null);
                } else {
                    String refStadeEdiTopiaIdMin = speciesStadeDto.getStadeMin().getTopiaId();
                    // we look for the sepciesStadeMin if there were no previous ones or if the previous one was different.
                    if (editedSpeciesStades.getStadeMin() == null ||
                            !editedSpeciesStades.getStadeMin().getTopiaId().contentEquals(refStadeEdiTopiaIdMin)) {
                        editedSpeciesStades.setStadeMin(refStadeEDIDao.forTopiaIdEquals(refStadeEdiTopiaIdMin).findUnique());
                    }

                    // if no sepciesStadeMax
                    if (speciesStadeDto.getStadeMax() == null) {
                        editedSpeciesStades.setStadeMax(null);
                    } else {
                        String refStadeEdiTopiaIdMax = speciesStadeDto.getStadeMax().getTopiaId();

                        // we look for the sepciesStadeMax if there were no previous ones or if the previous one was different.
                        if (editedSpeciesStades.getStadeMax() == null ||
                                !refStadeEdiTopiaIdMax.contentEquals(editedSpeciesStades.getStadeMax().getTopiaId())) {
                            // no needs to look for the speciesStadeMax's refStadeEDIDao if it's the same of speciesStadeMin
                            if (!refStadeEdiTopiaIdMin.contentEquals(refStadeEdiTopiaIdMax)) {
                                editedSpeciesStades.setStadeMax(refStadeEDIDao.forTopiaIdEquals(refStadeEdiTopiaIdMax).findUnique());
                            } else {
                                // the sepciesStadeMax is the same of the speciesStadeMin
                                editedSpeciesStades.setStadeMax(editedSpeciesStades.getStadeMin());
                            }
                        }
                    }
                }

                PracticedSpeciesStade persistedSpeciesStade;
                if (editedSpeciesStades.isPersisted()) {
                    persistedSpeciesStade = practicedSpeciesStadeDao.update(editedSpeciesStades);
                } else {
                    persistedSpeciesStade = practicedSpeciesStadeDao.create(editedSpeciesStades);
                }

                nonDeleted.add(persistedSpeciesStade);
            }
        }
        allOriginalSpeciesStades.retainAll(nonDeleted);
    }

    protected List<PracticedCropCyclePhaseDto> getPhasesDTOs(PracticedPerennialCropCycle cycle) {

        String domainCode = cycle.getPracticedSystem().getGrowingSystem().getGrowingPlan().getDomain().getCode();
        Collection<PracticedCropCyclePhase> currentPhases = cycle.getCropCyclePhases();
        List<PracticedCropCyclePhaseDto> currentPhasesDtos = Lists.newArrayListWithCapacity(currentPhases.size());
        for (PracticedCropCyclePhase currentPhase : currentPhases) {
            PracticedCropCyclePhaseDto currentPhaseDto = new PracticedCropCyclePhaseDto();
            currentPhaseDto.setType(currentPhase.getType());
            currentPhaseDto.setDuration(currentPhase.getDuration());
            currentPhaseDto.setTopiaId(currentPhase.getTopiaId());

            List<PracticedIntervention> interventions = getCropCyclePhaseInterventions(currentPhase);
            if (interventions != null) {
                List<PracticedInterventionDto> interventionDtos = practicedInterventionToInterventionDtos(domainCode, interventions);
                currentPhaseDto.setInterventions(interventionDtos);
            }
            currentPhasesDtos.add(currentPhaseDto);

        }

        return currentPhasesDtos;
    }

    protected List<PracticedCropCycleConnectionDto> getConnectionDTOs(String cycleId, String domainCode) {
        List<PracticedCropCycleConnection> connections = practicedCropCycleConnectionDao.findAllByCropCycle(cycleId);
        List<PracticedCropCycleConnectionDto> result = Lists.newArrayList();

        for (PracticedCropCycleConnection connection : connections) {
            PracticedCropCycleConnectionDto connectionDto = PracticedSystems.CROP_CYCLE_CONNECTION_TO_DTO.apply(connection);

            // add all connection interventions
            List<PracticedIntervention> interventions = practicedInterventionDao.forPracticedCropCycleConnectionEquals(connection).setOrderByArguments(PracticedIntervention.PROPERTY_RANK).findAll();
            if (interventions != null) {
                List<PracticedInterventionDto> interventionDtos = practicedInterventionToInterventionDtos(domainCode, interventions);
                connectionDto.setInterventions(interventionDtos);
            }
            // add connection
            result.add(connectionDto);
        }

        return result;
    }

    protected List<PracticedInterventionDto> practicedInterventionToInterventionDtos(String domainCode, List<PracticedIntervention> interventions) {
        List<PracticedInterventionDto> interventionDtos = Lists.newArrayListWithCapacity(interventions.size());
        Binder<PracticedIntervention, PracticedInterventionDto> binder = BinderFactory.newBinder(PracticedIntervention.class, PracticedInterventionDto.class);

        List<AbstractAction> abstractActions = abstractActionDao.forPracticedInterventionIn(interventions).findAll();
        Map<String, List<AbstractAction>> actionsByInterventionId = getActionsByIntervention(abstractActions);

        for (PracticedIntervention intervention : interventions) {

            PracticedInterventionDto interventionDto = new PracticedInterventionDto();
            interventionDtos.add(interventionDto);

            bindInterventionToInterventionDto(binder, intervention, interventionDto);
            interventionDto.setSpeciesStadesDtos(getInterventionSpeciesStadeDtos(intervention));
            interventionDto.setActions(actionsByInterventionId.get(intervention.getTopiaId()));
            interventionDto.setInputs(inputTopiaDao.findAllByPracticedIntervention(interventionDto));
            interventionDto.setDomainId(domainCode);

        }
        return interventionDtos;
    }

    protected static Map<String, List<AbstractAction>> getActionsByIntervention(List<AbstractAction> abstractActions) {
        Map<String, List<AbstractAction>> actionsByInterventionId = Maps.newHashMap();
        for (AbstractAction abstractAction : abstractActions) {
            String interId = abstractAction.getPracticedIntervention().getTopiaId();
            List<AbstractAction> actions = actionsByInterventionId.get(interId);
            if (actions == null) {
                actions = Lists.newArrayList();
                actionsByInterventionId.put(interId, actions);
            }
            actions.add(abstractAction);
        }
        return actionsByInterventionId;
    }

    protected static void bindInterventionToInterventionDto(Binder<PracticedIntervention, PracticedInterventionDto> binder, PracticedIntervention intervention, PracticedInterventionDto interventionDto) {
        binder.copyExcluding(intervention, interventionDto,
                PracticedIntervention.PROPERTY_SPECIES_STADES,
                PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE,
                PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION
        );
    }

    protected static List<SpeciesStadeDto> getInterventionSpeciesStadeDtos(PracticedIntervention intervention) {
        Collection<PracticedSpeciesStade> speciesStades = intervention.getSpeciesStades();
        return Lists.newArrayList(Iterables.transform(speciesStades, PracticedSystems.SPECIES_STADE_TO_DTO));
    }

    @Override
    public Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> getNodes(String cycleId) {
        PracticedSeasonalCropCycle cycle = getPracticedSeasonalCropCycle(cycleId);
        Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> result = getNodesForCycle(cycle);

        return result;
    }

    protected Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> getNodesForCycle(PracticedSeasonalCropCycle cycle) {
        Collection<PracticedCropCycleNode> allByPracticedCropCycle = cycle.getCropCycleNodes();

        Map<PracticedCropCycleNodeDto, List<CroppingPlanSpeciesDto>> result = Maps.newLinkedHashMap();
        if (allByPracticedCropCycle != null) {
            Iterable<PracticedCropCycleNodeDto> nodeDtos = Iterables.transform(allByPracticedCropCycle, PracticedSystems.CROP_CYCLE_NODE_TO_DTO);

            ImmutableMap<String, PracticedCropCycleNode> nodesById = Maps.uniqueIndex(allByPracticedCropCycle, Entities.GET_TOPIA_ID);

            for (PracticedCropCycleNodeDto nodeDto : nodeDtos) {
                List<CroppingPlanSpeciesDto> speciesDtos = Lists.newArrayList();
                result.put(nodeDto, speciesDtos);

                String nodeId = Entities.UNESCAPE_TOPIA_ID.apply(nodeDto.getNodeId());
                PracticedCropCycleNode nodeEntity = nodesById.get(nodeId);

                Preconditions.checkState(nodeEntity != null, "Node Entity should not be null with ID: ");
                Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> entryAndSpecies = findEntryAndSpeciesFromCode(nodeEntity.getCroppingPlanEntryCode(), cycle.getPracticedSystem().getCampaigns());
                nodeDto.setLabel(entryAndSpecies.getLeft().getName());
                Iterables.addAll(speciesDtos, Iterables.transform(entryAndSpecies.getRight().values(), CroppingPlans.CROPPING_PLAN_SPECIES_TO_DTO));
            }
        }
        return result;
    }

    protected Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> findEntryAndSpeciesFromCode(String croppingPlanEntryCode, String campaigns) {
        Set<Integer> campaignsSet = getIntCampaigns(campaigns);

        Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> result = domainService.getEntryAndSpeciesFromCode(croppingPlanEntryCode, campaignsSet);
        return result;
    }

    protected List<PracticedIntervention> getCropCyclePhaseInterventions(PracticedCropCyclePhase cropCyclePhase) {
        List<PracticedIntervention> result = practicedInterventionDao.
                forPracticedCropCyclePhaseEquals(cropCyclePhase).
                setOrderByArguments(PracticedIntervention.PROPERTY_RANK).
                findAll();
        return result;
    }

    protected List<PracticedIntervention> getCropCycleNodeConnectionInterventions(PracticedCropCycleConnection cropCycleNodeConnection) {
        List<PracticedIntervention> result = practicedInterventionDao.
                forPracticedCropCycleConnectionEquals(cropCycleNodeConnection).
                setOrderByArguments(PracticedIntervention.PROPERTY_RANK).
                findAll();
        return result;
    }

    @Override
    public List<PracticedCropCycleSpeciesDto> getCropCyclePerennialSpecies(String croppingPlanEntryCode,
                                                                           PracticedPerennialCropCycle cycle,
                                                                           String campaigns) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(croppingPlanEntryCode));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(campaigns));

        final Map<String, PracticedCropCycleSpecies> speciesCodeToCycleEntity;

        if (cycle == null) {
            speciesCodeToCycleEntity = Maps.newHashMap();
        } else {
            speciesCodeToCycleEntity = Maps.uniqueIndex(cycle.getPracticedCropCycleSpecies(), PracticedSystems.GET_CROP_CYCLE_PERENNIAL_SPECIES_CODE);
        }

        // Chargement de la liste des espèces (sans doublon)
        Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> entryAndSpeciesFromCode =
                findEntryAndSpeciesFromCode(croppingPlanEntryCode, campaigns);

        // Dto -> Decoration
        Function<CroppingPlanSpeciesDto, PracticedCropCycleSpeciesDto> decorateFunction = new Function<CroppingPlanSpeciesDto, PracticedCropCycleSpeciesDto>() {
            @Override
            public PracticedCropCycleSpeciesDto apply(CroppingPlanSpeciesDto input) {
                String croppingPlanSpeciesCode = input.getCode();
                PracticedCropCycleSpeciesDto result = new PracticedCropCycleSpeciesDto(input);
                PracticedCropCycleSpecies cropCyclePerennialSpecies = speciesCodeToCycleEntity.get(croppingPlanSpeciesCode);
                if (cropCyclePerennialSpecies != null) {
                    result.setOverGraftDate(cropCyclePerennialSpecies.getOverGraftDate());
                    result.setPlantCertified(cropCyclePerennialSpecies.isPlantsCertified());
                    result.setGraftSupport(PracticedSystems.REF_VARIETE_TO_GRAPH_DTO.apply(cropCyclePerennialSpecies.getGraftSupport()));
                    result.setGraftClone(PracticedSystems.REF_CLONE_TO_GRAPH_DTO.apply(cropCyclePerennialSpecies.getGraftClone()));
                }
                return result;
            }
        };

        // La transformation se fait en 2 temps : Entity -> Dto -> Decoration
        Function<CroppingPlanSpecies, PracticedCropCycleSpeciesDto> transformFunction = Functions.compose(decorateFunction, CroppingPlans.CROPPING_PLAN_SPECIES_TO_DTO);
        Iterable<PracticedCropCycleSpeciesDto> transformed = Iterables.transform(entryAndSpeciesFromCode.getRight().values(), transformFunction);

        List<PracticedCropCycleSpeciesDto> result = Lists.newArrayList(transformed);

        return result;
    }

    @Override
    public String getCroppingPlanEntryName(String croppingPlanEntryCode) {
        CroppingPlanEntry croppingPlanEntry = croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
        return croppingPlanEntry.getName();
    }

    @Override
    public List<Price> getPracticedPrices(String practicedSystemId) {
        List<Price> result = pricesService.getPracticedSystemPrices(practicedSystemId);
        return result;
    }

    @Override
    public PracticedSystem duplicatePracticedSystem(String practicedSystemId, String growingSystemId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(practicedSystemId));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(growingSystemId));

        PracticedSystem fromPracticedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        GrowingSystem targetedGrowingSystem = growingSystemDao.forTopiaIdEquals(growingSystemId).findUnique();

        Set<Integer> campaigns = getIntCampaigns(fromPracticedSystem.getCampaigns());
        String targetedDomainCode = targetedGrowingSystem.getGrowingPlan().getDomain().getCode();

        List<String> croppingPlanCodes = domainService.getCroppingPlanCodeForDomainsAndCampaigns(targetedDomainCode, campaigns);
        Preconditions.checkArgument(!croppingPlanCodes.isEmpty());

        // perform clone
        PracticedSystem duplicatedPracticedSystem = bindPracticedSystemCommonData(fromPracticedSystem, targetedGrowingSystem);

        DuplicateCropCyclesContext duplicateContext = getDuplicateCropCyclesContext(fromPracticedSystem, campaigns, targetedDomainCode, croppingPlanCodes, duplicatedPracticedSystem);

        duplicatePracticedSystemPlot(fromPracticedSystem, duplicatedPracticedSystem);

        duplicateSeasonalCycles(fromPracticedSystem, targetedDomainCode, croppingPlanCodes, duplicatedPracticedSystem, duplicateContext);

        duplicatePerennialCropCycles(fromPracticedSystem, croppingPlanCodes, duplicatedPracticedSystem, duplicateContext);

        // duplication des prix lié au systeme synthétisé
        pricesService.duplicatePracticedSystemPrices(duplicateContext);

        getTransaction().commit();
        return duplicatedPracticedSystem;
    }

    protected PracticedSystem bindPracticedSystemCommonData(PracticedSystem practicedSystem, GrowingSystem targetedGrowingSystem) {
        Binder<PracticedSystem, PracticedSystem> practicedSystemBinder = BinderFactory.newBinder(PracticedSystem.class);
        PracticedSystem duplicatedPracticedSystem = practicedSystemDao.newInstance();
        practicedSystemBinder.copyExcluding(practicedSystem, duplicatedPracticedSystem,
                PracticedSystem.PROPERTY_TOPIA_ID,
                PracticedSystem.PROPERTY_TOPIA_VERSION,
                PracticedSystem.PROPERTY_TOPIA_CREATE_DATE,
                PracticedSystem.PROPERTY_VALIDATED,
                PracticedSystem.PROPERTY_VALIDATION_DATE,
                PracticedSystem.PROPERTY_GROWING_SYSTEM);
        duplicatedPracticedSystem.setUpdateDate(context.getCurrentDate());
        duplicatedPracticedSystem.setGrowingSystem(targetedGrowingSystem);
        duplicatedPracticedSystem = practicedSystemDao.create(duplicatedPracticedSystem);
        return duplicatedPracticedSystem;
    }

    protected DuplicateCropCyclesContext getDuplicateCropCyclesContext(PracticedSystem practicedSystem, Set<Integer> campaigns, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone) {
        Map<String, Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>>> speciesByCrop = domainService.findSpeciesCodeByCropCodeForCampaigns(croppingPlanCodes, campaigns);
        List<String> toolsCouplingsCodes = getToolsCouplingsCodesFromDomainAndCampaigns(targetedDomainCode, practicedSystem.getCampaigns());
        // context de duplication pour l'ensemble de la graphe "system synthétisé"
        DuplicateCropCyclesContext duplicateContext = new DuplicateCropCyclesContext();

        duplicateContext.setSpeciesByCropCode(speciesByCrop);
        duplicateContext.setToolsCouplingsCode(toolsCouplingsCodes);
        duplicateContext.setPracticedSystem(practicedSystem);
        duplicateContext.setPracticedSystemClone(practicedSystemClone);
        return duplicateContext;
    }

    protected void duplicatePerennialCropCycles(PracticedSystem practicedSystem, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone, DuplicateCropCyclesContext duplicateContext) {
        Collection<PracticedPerennialCropCycle> perennialCropCycles = practicedPerennialCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder<PracticedPerennialCropCycle, PracticedPerennialCropCycle> perennialCropCycleBinder = BinderFactory.newBinder(PracticedPerennialCropCycle.class);
        for (PracticedPerennialCropCycle cycle : perennialCropCycles) {
            if (croppingPlanCodes.contains(cycle.getCroppingPlanEntryCode())){

                PracticedPerennialCropCycle cycleClone = practicedPerennialCropCycleDao.newInstance();
                perennialCropCycleBinder.copyExcluding(cycle, cycleClone,
                        PracticedPerennialCropCycle.PROPERTY_TOPIA_ID,
                        PracticedPerennialCropCycle.PROPERTY_TOPIA_VERSION,
                        PracticedPerennialCropCycle.PROPERTY_TOPIA_CREATE_DATE,
                        PracticedPerennialCropCycle.PROPERTY_PRACTICED_SYSTEM,
                        PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES,
                        PracticedPerennialCropCycle.PROPERTY_PRACTICED_CROP_CYCLE_SPECIES);
                cycleClone.setPracticedSystem(practicedSystemClone);

                // copy phases
                Collection<PracticedCropCyclePhase> phases = cycle.getCropCyclePhases();
                if (phases != null) {
                    Binder<PracticedCropCyclePhase, PracticedCropCyclePhase> phaseBinder = BinderFactory.newBinder(PracticedCropCyclePhase.class);
                    for (PracticedCropCyclePhase phase : phases) {
                        PracticedCropCyclePhase phaseClone = practicedCropCyclePhaseDao.newInstance();
                        phaseBinder.copyExcluding(phase, phaseClone,
                                PracticedCropCyclePhase.PROPERTY_TOPIA_ID,
                                PracticedCropCyclePhase.PROPERTY_TOPIA_VERSION,
                                PracticedCropCyclePhase.PROPERTY_TOPIA_CREATE_DATE);
                        cycleClone.addCropCyclePhases(phaseClone);

                        // save phase
                        phaseClone= practicedCropCyclePhaseDao.create(phaseClone);

                        // continue to intervention copy
                        duplicateInterventions(duplicateContext, cycle.getCroppingPlanEntryCode(), phase, phaseClone, null, null);
                    }
                }

                // copy species
                Collection<PracticedCropCycleSpecies> cycleSpecies = cycle.getPracticedCropCycleSpecies();
                if (cycleSpecies != null && duplicateContext.getSpeciesByCropCode() != null && duplicateContext.getSpeciesByCropCode().get(cycle.getCroppingPlanEntryCode()) != null) {
                    Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> pair = duplicateContext.getSpeciesByCropCode().get(cycle.getCroppingPlanEntryCode());
                    Map<String, CroppingPlanSpecies> speciesByCode = pair.getValue();

                    Binder<PracticedCropCycleSpecies, PracticedCropCycleSpecies> speciesBinder = BinderFactory.newBinder(PracticedCropCycleSpecies.class);
                    for (PracticedCropCycleSpecies species : cycleSpecies) {

                        if (speciesByCode != null && speciesByCode.containsKey(species.getCroppingPlanSpeciesCode())) {
                            PracticedCropCycleSpecies speciesClone = practicedCropCycleSpeciesDao.newInstance();
                            speciesBinder.copyExcluding(species, speciesClone,
                                    PracticedCropCycleSpecies.PROPERTY_TOPIA_ID,
                                    PracticedCropCycleSpecies.PROPERTY_TOPIA_VERSION,
                                    PracticedCropCycleSpecies.PROPERTY_TOPIA_CREATE_DATE);
                            cycleClone.addPracticedCropCycleSpecies(speciesClone);
                        }
                    }
                }

                practicedPerennialCropCycleDao.create(cycleClone);
            }
        }
    }

    protected void duplicateSeasonalCycles(PracticedSystem practicedSystem, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSystem practicedSystemClone, DuplicateCropCyclesContext duplicateContext) {
        Collection<PracticedSeasonalCropCycle> seasonalCropCycles = practicedSeasonalCropCycleDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder<PracticedSeasonalCropCycle, PracticedSeasonalCropCycle> seasonalCropCycleBinder = BinderFactory.newBinder(PracticedSeasonalCropCycle.class);

        for (PracticedSeasonalCropCycle cycle : seasonalCropCycles) {

            PracticedSeasonalCropCycle duplicatedSeasonalCycle = bindPracticedSeasonalCropCycle(seasonalCropCycleBinder, cycle);
            duplicatedSeasonalCycle.setPracticedSystem(practicedSystemClone);

            Map<PracticedCropCycleNode, PracticedCropCycleNode> nodeCache = duplicateSeasonalNodes(practicedSystem, targetedDomainCode, croppingPlanCodes, cycle, duplicatedSeasonalCycle);

            practicedSeasonalCropCycleDao.create(duplicatedSeasonalCycle);

            // clone seasonal connections
            duplicateSeasonalConnection(croppingPlanCodes, duplicateContext, cycle, nodeCache);
        }
    }

    protected void duplicateSeasonalConnection(List<String> croppingPlanCodes, DuplicateCropCyclesContext duplicateContext, PracticedSeasonalCropCycle cycle, Map<PracticedCropCycleNode, PracticedCropCycleNode> nodeCache) {
        Collection<PracticedCropCycleConnection> seasonalConnections = practicedCropCycleConnectionDao.findAllByCropCycle(cycle.getTopiaId());
        Binder<PracticedCropCycleConnection, PracticedCropCycleConnection> seasonalConnectionBinder = BinderFactory.newBinder(PracticedCropCycleConnection.class);
        for (PracticedCropCycleConnection seasonalConnection : seasonalConnections) {

            PracticedCropCycleConnection duplicatedConnection = bindPracticedCropCycleConnection(seasonalConnectionBinder, seasonalConnection);
            duplicatedConnection.setSource(nodeCache.get(seasonalConnection.getSource()));
            duplicatedConnection.setTarget(nodeCache.get(seasonalConnection.getTarget()));
            setDuplicatedConnectionIntermediateCrop(croppingPlanCodes, seasonalConnection, duplicatedConnection);

            duplicatedConnection = practicedCropCycleConnectionDao.create(duplicatedConnection);

            duplicateInterventions(duplicateContext, null, null, null, seasonalConnection, duplicatedConnection);

        }
    }

    protected void setDuplicatedConnectionIntermediateCrop(List<String> croppingPlanCodes, PracticedCropCycleConnection seasonalConnection, PracticedCropCycleConnection duplicatedConnection) {
        if (seasonalConnection.getIntermediateCroppingPlanEntryCode() != null && croppingPlanCodes.contains(seasonalConnection.getIntermediateCroppingPlanEntryCode())) {
            duplicatedConnection.setIntermediateCroppingPlanEntryCode(seasonalConnection.getIntermediateCroppingPlanEntryCode());
        }
    }

    protected PracticedCropCycleConnection bindPracticedCropCycleConnection(Binder<PracticedCropCycleConnection, PracticedCropCycleConnection> seasonalConnectionBinder, PracticedCropCycleConnection seasonalConnection) {
        PracticedCropCycleConnection connectionClone = practicedCropCycleConnectionDao.newInstance();
        seasonalConnectionBinder.copyExcluding(seasonalConnection, connectionClone,
                PracticedCropCycleConnection.PROPERTY_TOPIA_ID,
                PracticedCropCycleConnection.PROPERTY_TOPIA_VERSION,
                PracticedCropCycleConnection.PROPERTY_TOPIA_CREATE_DATE,
                PracticedCropCycleConnection.PROPERTY_SOURCE,
                PracticedCropCycleConnection.PROPERTY_TARGET,
                PracticedCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY_CODE
        );
        return connectionClone;
    }

    protected Map<PracticedCropCycleNode, PracticedCropCycleNode> duplicateSeasonalNodes(PracticedSystem practicedSystem, String targetedDomainCode, List<String> croppingPlanCodes, PracticedSeasonalCropCycle cycle, PracticedSeasonalCropCycle duplicatedSeasonalCycle) {
        Collection<PracticedCropCycleNode> seasonalNodes = cycle.getCropCycleNodes();
        Binder<PracticedCropCycleNode, PracticedCropCycleNode> seasonalNodeBinder = BinderFactory.newBinder(PracticedCropCycleNode.class);
        Map<PracticedCropCycleNode, PracticedCropCycleNode> nodeCache = Maps.newHashMap();
        for (PracticedCropCycleNode seasonalNode : seasonalNodes) {
            if (croppingPlanCodes.contains(seasonalNode.getCroppingPlanEntryCode())){
                PracticedCropCycleNode nodeClone = practicedCropCycleNodeDao.newInstance();
                seasonalNodeBinder.copyExcluding(seasonalNode, nodeClone,
                        PracticedCropCycleNode.PROPERTY_TOPIA_ID,
                        PracticedCropCycleNode.PROPERTY_TOPIA_VERSION,
                        PracticedCropCycleNode.PROPERTY_TOPIA_CREATE_DATE,
                        PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE);
                nodeClone.setPracticedSeasonalCropCycle(duplicatedSeasonalCycle);
                duplicatedSeasonalCycle.addCropCycleNodes(nodeClone);

                // add to cache to link connection to cloned instance
                nodeCache.put(seasonalNode, nodeClone);
            } else {
                throw new AgrosystDuplicationException(String.format("Un noeud du cycle de culture saisonnaire n'a pu être créé, " +
                        "la culture dont le code est '%s' n'a pu être retrouvée sur le domaine au code '%s' et les campagnes:%s", seasonalNode.getCroppingPlanEntryCode(), targetedDomainCode, practicedSystem.getCampaigns()));
            }
        }
        return nodeCache;
    }

    protected PracticedSeasonalCropCycle bindPracticedSeasonalCropCycle(Binder<PracticedSeasonalCropCycle, PracticedSeasonalCropCycle> seasonalCropCycleBinder, PracticedSeasonalCropCycle cycle) {
        PracticedSeasonalCropCycle duplicatedSeasonalCycle = practicedSeasonalCropCycleDao.newInstance();
        seasonalCropCycleBinder.copyExcluding(cycle, duplicatedSeasonalCycle,
                PracticedSeasonalCropCycle.PROPERTY_TOPIA_ID,
                PracticedSeasonalCropCycle.PROPERTY_TOPIA_VERSION,
                PracticedSeasonalCropCycle.PROPERTY_TOPIA_CREATE_DATE,
                PracticedSeasonalCropCycle.PROPERTY_PRACTICED_SYSTEM,
                PracticedSeasonalCropCycle.PROPERTY_CROP_CYCLE_NODES);
        return duplicatedSeasonalCycle;
    }

    public void duplicatePracticedSystemPlot(PracticedSystem practicedSystem, PracticedSystem practicedSystemClone) {
        // clone practiced plots
        Collection<PracticedPlot> practicedPlots = practicedPlotDao.forPracticedSystemEquals(practicedSystem).findAll();
        Binder<PracticedPlot, PracticedPlot> practicedPlotBinder = BinderFactory.newBinder(PracticedPlot.class);
        for (PracticedPlot practicedPlot : practicedPlots) {
            PracticedPlot plotClone = practicedPlotDao.newInstance();
            practicedPlotBinder.copyExcluding(practicedPlot, plotClone,
                    PracticedPlot.PROPERTY_TOPIA_ID,
                    PracticedPlot.PROPERTY_TOPIA_VERSION,
                    PracticedPlot.PROPERTY_TOPIA_CREATE_DATE,
                    PracticedPlot.PROPERTY_PRACTICED_SYSTEM,
                    PracticedPlot.PROPERTY_SOL_HORIZON,
                    PracticedPlot.PROPERTY_PLOT_ZONINGS,
                    PracticedPlot.PROPERTY_ADJACENT_ELEMENTS);
            plotClone.setPracticedSystem(practicedSystemClone);

            // clone sol horizon
            if (practicedPlot.getSolHorizon() != null) {
                Binder<SolHorizon, SolHorizon> binderSH = BinderFactory.newBinder(SolHorizon.class);
                for (SolHorizon solHorizon : practicedPlot.getSolHorizon()) {
                    SolHorizon solHorizonClone = solHorizonDao.newInstance();
                    binderSH.copyExcluding(solHorizon, solHorizonClone,
                            SolHorizon.PROPERTY_TOPIA_ID,
                            SolHorizon.PROPERTY_TOPIA_VERSION,
                            SolHorizon.PROPERTY_TOPIA_CREATE_DATE);
                    plotClone.addSolHorizon(solHorizonClone);
                }
            }

            // force collection copy instead of collection reference copy
            if (practicedPlot.getPlotZonings() != null) {
                plotClone.setPlotZonings(Lists.newArrayList(practicedPlot.getPlotZonings()));
            }
            if (practicedPlot.getAdjacentElements() != null) {
                plotClone.setAdjacentElements(Lists.newArrayList(practicedPlot.getAdjacentElements()));
            }

            practicedPlotDao.create(plotClone);
        }
    }

    @Override
    public void unactivatePracticedSystem(List<String> practicedSystemIds, boolean activate) {
        if (practicedSystemIds != null && !practicedSystemIds.isEmpty()) {

            for (String practicedSystemId : practicedSystemIds) {
                PracticedSystem practicedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
                practicedSystem.setActive(activate);
                practicedSystemDao.update(practicedSystem);
            }
            getTransaction().commit();
        }
    }

    /**
     * Duplicate phase or connection interventions.
     *
     * @param duplicateContext duplicate context
     * @param phaseTargetedCropCode phase or connection crop code
     * @param phase phase to get intervention
     * @param phaseClone phase to clone intervention to
     * @param connection connection to get intervention
     * @param connectionClone connection to clone intervention to
     */
    protected void duplicateInterventions(DuplicateCropCyclesContext duplicateContext, String phaseTargetedCropCode, PracticedCropCyclePhase phase, PracticedCropCyclePhase phaseClone,
                                          PracticedCropCycleConnection connection, PracticedCropCycleConnection connectionClone) {

        Preconditions.checkArgument(phase != null ^ connection != null);
        Preconditions.checkArgument(phaseClone != null ^ connectionClone != null);

        Collection<PracticedIntervention> practicedInterventions = getPracticedSystemInterventions(phase, connection);

        Binder<PracticedIntervention, PracticedIntervention> interventionBinder = BinderFactory.newBinder(PracticedIntervention.class);
        for (PracticedIntervention practicedIntervention : practicedInterventions) {

            PracticedIntervention interventionClone = bindPracticedIntervention(interventionBinder, practicedIntervention);

            setInterventionIntermedaiteStatus(phaseClone, connectionClone, interventionClone);

            addToolsCouplingCodesToIntervention(duplicateContext, practicedIntervention, interventionClone);

            duplicateContext.setTargetedCropCode(getInterventionCropTarget(phaseTargetedCropCode, phaseClone, connectionClone, interventionClone));
            addSpeciesStadesToIntervention(duplicateContext, practicedIntervention, interventionClone);

            // save intervention
            practicedInterventionDao.create(interventionClone);

            // duplication des actions liés à l'intervention
            actionService.duplicatePracticedActions(duplicateContext, practicedIntervention, interventionClone);
        }
    }

    protected Collection<PracticedIntervention> getPracticedSystemInterventions(PracticedCropCyclePhase phase, PracticedCropCycleConnection connection) {
        Collection<PracticedIntervention> practicedInterventions;
        if (phase != null) {
            practicedInterventions = practicedInterventionDao.forPracticedCropCyclePhaseEquals(phase).findAll();
        } else {
            practicedInterventions = practicedInterventionDao.forPracticedCropCycleConnectionEquals(connection).findAll();
        }
        return practicedInterventions;
    }

    protected void addSpeciesStadesToIntervention(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention interventionClone) {
        if (practicedIntervention.getSpeciesStades() != null) {
            Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> pair = duplicateContext.getSpeciesByCropCode().get(duplicateContext.getTargetedCropCode());
            if (pair != null) {
                Map<String, CroppingPlanSpecies> speciesByCode = pair.getValue();
                Binder<PracticedSpeciesStade, PracticedSpeciesStade> speciesBinder = BinderFactory.newBinder(PracticedSpeciesStade.class);
                for (PracticedSpeciesStade speciesStade : practicedIntervention.getSpeciesStades()) {
                    if (speciesByCode != null && speciesByCode.containsKey(speciesStade.getSpeciesCode())) {
                        PracticedSpeciesStade speciesClone = practicedSpeciesStadeDao.newInstance();
                        speciesBinder.copyExcluding(speciesStade, speciesClone,
                                PracticedIntervention.PROPERTY_TOPIA_ID,
                                PracticedIntervention.PROPERTY_TOPIA_VERSION,
                                PracticedIntervention.PROPERTY_TOPIA_CREATE_DATE);

                        interventionClone.addSpeciesStades(speciesClone);
                    }
                }
            }
        }
    }

    protected void addToolsCouplingCodesToIntervention(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention interventionClone) {
        Collection<String> practicedSystemToolsCouplingsCodes = duplicateContext.getToolsCouplingsCode();
        if (practicedIntervention.getToolsCouplingCodes() != null && practicedSystemToolsCouplingsCodes != null) {
            List<String> interventionToolsCouplingCodes = Lists.newArrayList();
            for (String toolsCouplingCode : practicedIntervention.getToolsCouplingCodes()) {
                if (practicedSystemToolsCouplingsCodes.contains(toolsCouplingCode)) {
                    interventionToolsCouplingCodes.add(toolsCouplingCode);
                }
            }
            interventionClone.setToolsCouplingCodes(interventionToolsCouplingCodes);
        }
    }

    protected PracticedIntervention bindPracticedIntervention(Binder<PracticedIntervention, PracticedIntervention> interventionBinder, PracticedIntervention practicedIntervention) {
        PracticedIntervention interventionClone = practicedInterventionDao.newInstance();
        interventionBinder.copyExcluding(practicedIntervention, interventionClone,
                PracticedIntervention.PROPERTY_TOPIA_ID,
                PracticedIntervention.PROPERTY_TOPIA_VERSION,
                PracticedIntervention.PROPERTY_TOPIA_CREATE_DATE,
                PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION,
                PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE,
                PracticedIntervention.PROPERTY_SPECIES_STADES,
                PracticedIntervention.PROPERTY_TOOLS_COUPLING_CODES);
        return interventionClone;
    }

    protected void setInterventionIntermedaiteStatus(PracticedCropCyclePhase phaseClone, PracticedCropCycleConnection connectionClone, PracticedIntervention interventionClone) {
        if (phaseClone != null) {
            interventionClone.setPracticedCropCyclePhase(phaseClone);
        } else {
            if (connectionClone.getIntermediateCroppingPlanEntryCode() != null && interventionClone.isIntermediateCrop()) {
                interventionClone.setIntermediateCrop(true);
            } else {
                interventionClone.setIntermediateCrop(false);
            }
            interventionClone.setPracticedCropCycleConnection(connectionClone);
        }
    }

    protected String getInterventionCropTarget(String phaseTargetedCropCode, PracticedCropCyclePhase phaseClone, PracticedCropCycleConnection connectionClone, PracticedIntervention interventionClone) {
        String cropCode;
        if (phaseClone != null) {
            cropCode = phaseTargetedCropCode;
        } else {
            if (connectionClone.getIntermediateCroppingPlanEntryCode() != null && interventionClone.isIntermediateCrop()) {
                cropCode = connectionClone.getIntermediateCroppingPlanEntryCode();
            } else {
                cropCode = connectionClone.getTarget().getCroppingPlanEntryCode();
            }
        }
        return cropCode;
    }

    @Override
    public String getdomainCode(String growingSystemId) {
        String domainCode = domainService.getDomainCodeForGrowingSystem(growingSystemId);
        return domainCode;
    }

    @Override
    public PracticedSystem validate(String practicedSystemId) {

        authorizationService.checkValidatePracticedSystem(practicedSystemId);

        // AThimel 09/12/13 Perform DB update is more powerful
        practicedSystemDao.validatePracticedSystem(practicedSystemId, context.getCurrentDate());

        getTransaction().commit();

        // AThimel 09/12/13 The next line makes sure that cache state is synchronized with database state
        getPersistenceContext().getHibernateSupport().getHibernateSession().clear();

        PracticedSystem practicedSystem = practicedSystemDao.forTopiaIdEquals(practicedSystemId).findUnique();
        return practicedSystem;
    }

    @Override
    public InputStream exportPracticedSystemsAsXlsStream(List<String> practicesSystemIds) {
        // contains all tabs
        Map<EntityExportTabInfo, List<? extends EntityExportExtra>> sheet = Maps.newLinkedHashMap();

        PracticedSystemMainBeanInfo practicedSystemMainTab = new PracticedSystemMainBeanInfo();
        PracticedSeasonalCropCycleBeanInfo seasonalCropCycleTab = new PracticedSeasonalCropCycleBeanInfo();
        PracticedPerennialCropCycleBeanInfo perennialCropCycleTab = new PracticedPerennialCropCycleBeanInfo();
        PracticedPerennialCropCycleSpeciesBeanInfo perennialCropCycleSpeciesTab = new PracticedPerennialCropCycleSpeciesBeanInfo();
        PracticedITKBeanInfo itkTab = new PracticedITKBeanInfo();

        // add all bean infos
        ExportUtils.addAllBeanInfo(sheet, practicedSystemMainTab, seasonalCropCycleTab, perennialCropCycleTab, perennialCropCycleSpeciesTab, itkTab);

        try {
            if (CollectionUtils.isNotEmpty(practicesSystemIds)) {
                Iterable<PracticedSystem> practicedSystems = practicedSystemDao.forTopiaIdIn(practicesSystemIds).findAllLazy(100);
                for (PracticedSystem practicedSystem : practicedSystems) {

                    // anonymize practiced system
                    practicedSystem = anonymizeService.checkForPracticedSystemAnonymization(practicedSystem);

                    // main tab
                    PracticedSystemEntity model = new PracticedSystemEntity();
                    model.setPracticedSystemName(practicedSystem.getName());
                    model.setCampaigns(practicedSystem.getCampaigns());
                    model.setGrowingSystemName(practicedSystem.getGrowingSystem().getName());
                    model.setGrowingPlanName(practicedSystem.getGrowingSystem().getGrowingPlan().getName());
                    model.setDomainName(practicedSystem.getGrowingSystem().getGrowingPlan().getDomain().getName());

                    ExportUtils.export(sheet, model, practicedSystem,practicedSystemMainTab);

                    // seasonal crops cycles
                    List<PracticedSeasonalCropCycleDto> seasonalCropCycleDtos = getAllPracticedSeasonalCropCycles(practicedSystem.getTopiaId());
                    List<PracticedPerennialCropCycleDto> perennialCycleDtos = getAllPracticedPerennialCropCycles(practicedSystem.getTopiaId());
                    List<PracticedSystemEntity> phaseEntities = (List<PracticedSystemEntity>)sheet.get(perennialCropCycleTab);
                    List<PracticedSystemEntity> speciesEntities = (List<PracticedSystemEntity>)sheet.get(perennialCropCycleSpeciesTab);
                    List<PracticedSystemEntity> itkEntities = (List<PracticedSystemEntity>)sheet.get(itkTab);

                    if (seasonalCropCycleDtos != null) {

                        for (PracticedSeasonalCropCycleDto seasonalCropCycleDto:seasonalCropCycleDtos) {

                            // build entity for seasonal crop cycle exports
                            Map<String, PracticedSeasonalEntityExport> seasonalCropCycleEntityExports = Maps.newHashMap();
                            List<PracticedCropCycleNodeDto> nodeDtos = seasonalCropCycleDto.getCropCycleNodeDtos();

                            for(PracticedCropCycleNodeDto node:nodeDtos) {
                                PracticedSeasonalEntityExport entityExport = new PracticedSeasonalEntityExport();
                                entityExport.setLabel(node.getLabel());
                                entityExport.setEndCycle(node.isEndCycle());
                                entityExport.setSameCampaignAsPreviousNode(node.isSameCampaignAsPreviousNode());
                                entityExport.setInitNodeFrequency(node.getInitNodeFrequency());
                                entityExport.setX(node.getX());

                                seasonalCropCycleEntityExports.put(node.getNodeId(), entityExport);
                            }

                            List<PracticedCropCycleConnectionDto> cropCycleConnectionDtos = seasonalCropCycleDto.getCropCycleConnectionDtos();
                            for(PracticedCropCycleConnectionDto connection:cropCycleConnectionDtos) {

                                // intermediateCropName
                                if (StringUtils.isNotBlank(connection.getIntermediateCropName())) {
                                    PracticedSeasonalEntityExport entityExport = seasonalCropCycleEntityExports.get(connection.getTargetId());
                                    entityExport.setIntermediateCropName(connection.getIntermediateCropName());
                                }
                                // previousCrop
                                if (StringUtils.isNotBlank(connection.getSourceId())) {
                                    PracticedSeasonalEntityExport sourceEntityExport = seasonalCropCycleEntityExports.get(connection.getSourceId());
                                    PracticedSeasonalEntityExport targetEntityExport = seasonalCropCycleEntityExports.get(connection.getTargetId());
                                    targetEntityExport.setPreviousCrop(sourceEntityExport.getLabel());
                                }
                                // croppingPlanEntryFrequency
                                if (connection.getCroppingPlanEntryFrequency() != null) {
                                    PracticedSeasonalEntityExport targetEntityExport = seasonalCropCycleEntityExports.get(connection.getTargetId());
                                    targetEntityExport.setCroppingPlanEntryFrequency(connection.getCroppingPlanEntryFrequency());
                                }
                            }

                            // seasonal crop cycle tab
                            for (PracticedSeasonalEntityExport entityExport: seasonalCropCycleEntityExports.values()){
                                PracticedSystemEntity export = (PracticedSystemEntity) model.clone();
                                ExportUtils.export(sheet, export, entityExport, seasonalCropCycleTab);
                            }

                            // sesonal ITK
                            for (PracticedCropCycleConnectionDto connection:cropCycleConnectionDtos) {
                                List<PracticedInterventionDto> itks = connection.getInterventions();
                                PracticedSeasonalEntityExport node = seasonalCropCycleEntityExports.get(connection.getTargetId());
                                String cropName = node.getLabel();
                                Integer rank = node.getX();
                                String previousCropName = node.getPreviousCrop();
                                if (itks != null) {
                                    for (PracticedInterventionDto itk : itks) {
                                        PracticedSystemEntity export = exportCommonInterventionFields(model, true, cropName, previousCropName, rank, null, itk);
                                        // add tools couplings, species, actions, inputs fields
                                        exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, itk, export);
                                    }
                                }
                            }

                        }
                    }

                    // perennial crop cycle tab
                    if (!sheet.containsKey(perennialCropCycleTab)) {
                        sheet.put(perennialCropCycleTab, phaseEntities);
                    }

                    //species tab
                    if (!sheet.containsKey(perennialCropCycleSpeciesTab)) {
                        sheet.put(perennialCropCycleSpeciesTab, speciesEntities);
                    }

                    if(!sheet.containsKey(itkTab)) {
                        sheet.put(itkTab, itkEntities);
                    }
                    if (perennialCycleDtos != null && !perennialCycleDtos.isEmpty()) {
                        for (PracticedPerennialCropCycleDto cycleDto: perennialCycleDtos) {
                            String cropName = cycleDto.getCroppingPlanEntryName();
                            // phases
                            for(PracticedCropCyclePhaseDto phase: cycleDto.getCropCyclePhaseDtos()) {
                                PracticedSystemEntity export = (PracticedSystemEntity) model.clone();
                                ExportUtils.copyFields(cycleDto.getPracticedPerennialCropCycle(), export, null,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_YEAR,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_SPACING,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_DENSITY,
                                        PracticedPerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM,
                                        PracticedPerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM,
                                        PracticedPerennialCropCycle.PROPERTY_ORIENTATION,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE,
                                        PracticedPerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR,
                                        PracticedPerennialCropCycle.PROPERTY_WEED_TYPE,
                                        PracticedPerennialCropCycle.PROPERTY_POLLINATOR,
                                        PracticedPerennialCropCycle.PROPERTY_POLLINATOR_PERCENT,
                                        PracticedPerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE,
                                        PracticedPerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS);
                                ExportUtils.setExtraField(export, "label", cropName);
                                ExportUtils.setExtraField(export, "phaseType", phase.getType());
                                ExportUtils.setExtraField(export, "phaseDuration", phase.getDuration());
                                phaseEntities.add(export);

                                // itks
                                List<PracticedInterventionDto> itks = phase.getInterventions();

                                if (itks != null && !itks.isEmpty()){
                                    for (PracticedInterventionDto itk : itks) {
                                        export = exportCommonInterventionFields(model, true, cropName, null, null, phase.getType(), itk);
                                        // add tools couplings, species, actions, inputs fields
                                        exportToolsCouplingsSpeciesActionsInputsFields(itkEntities, itk, export);
                                    }
                                }
                            }

                            // species
                            List<PracticedCropCycleSpeciesDto> speciesDtos = cycleDto.getSpeciesDto();
                            if (!speciesDtos.isEmpty()) {
                                for(PracticedCropCyclePhaseDto phase: cycleDto.getCropCyclePhaseDtos()) {
                                    for (PracticedCropCycleSpeciesDto speciesDto : speciesDtos) {
                                        PracticedSystemEntity export = (PracticedSystemEntity) model.clone();

                                        ExportUtils.setExtraField(export, "croppingPlanEntryName", cycleDto.getCroppingPlanEntryName());
                                        ExportUtils.setExtraField(export, "phase", phase.getType());

                                        ExportUtils.copyFields(speciesDto, export, null,
                                                "speciesEspece",
                                                "speciesQualifiant",
                                                "speciesTypeSaisonnier",
                                                "speciesDestination",
                                                "varietyLibelle",
                                                "profil_vegetatif_BBCH",
                                                "plantCertified",
                                                "overGraftDate"
                                        );
                                        String graftSupport = speciesDto.getGraftSupport() !=null ? speciesDto.getGraftSupport().getLabel() : null;
                                        ExportUtils.setExtraField(export, "graftSupport",graftSupport);

                                        String graftClone = speciesDto.getGraftClone() != null ? speciesDto.getGraftClone().getLabel() : null;
                                        ExportUtils.setExtraField(export, "graftClone",graftClone);
                                        speciesEntities.add(export);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception ex) {
            throw new AgrosystTechnicalException("Can't copy properties", ex);
        }
        // technical export
        EntityExporter exporter = new EntityExporter();
        InputStream stream = exporter.exportAsXlsStream(sheet);

        return stream;
    }

    @Override
    public void importPZ0PracticedSystems(Map<Class, ImportResults> allResults) {
        ImportResults importResults = allResults.remove(PracticedSystem.class);
        if (importResults != null && importResults.getIgnoredRecords() == 0) {
            try {
                Map<String, EntityAndDependencies> entitiesAndDependencies = importResults.getEntityAndDepsByCsvIds();

                for (EntityAndDependencies entityAndDependencies : entitiesAndDependencies.values()) {

                    PracticedSystemAndDependencies practicedSystemAndDependencies = (PracticedSystemAndDependencies) entityAndDependencies;
                    PracticedSystem practicedSystem = practicedSystemAndDependencies.getEntity();

                    List<Pz0PracticedPerennialCropCycle> pz0PracticedPerennialCropCycles = practicedSystemAndDependencies.getPz0PracticedPerennialCropCycles();

                    List<PracticedPerennialCropCycleDto> practicedPerennialCropCycleDtos = getPracticedPerennialCropCycleDtos(pz0PracticedPerennialCropCycles);

                    List<Pz0PracticedSeasonalCropCycle> pz0PracticedSeasonalCropCycles = practicedSystemAndDependencies.getPz0PracticedSeasonalCropCycles();

                    List<PracticedSeasonalCropCycleDto> practicedSeasonalCropCycleDtos = getPracticedSeasonalCropCycleDtos(pz0PracticedSeasonalCropCycles);

                    List<Price> prices = practicedSystemAndDependencies.getPrices();
                    practicedSystem = createOrUpdatePracticedSystemWithoutCommit(practicedSystem, practicedPerennialCropCycleDtos, practicedSeasonalCropCycleDtos, prices);
                    practicedSystemAndDependencies.setEntity(practicedSystem);

                }
            } catch (Exception e) {
                throw (new AgrosystImportException("Echec de persistance des systèmes synthétisé", e));
            }
        }
    }

    protected List<PracticedPerennialCropCycleDto> getPracticedPerennialCropCycleDtos(List<Pz0PracticedPerennialCropCycle> pz0PracticedPerennialCropCycles) {
        Iterable<PracticedPerennialCropCycleDto> PracticedPerennialCropCycleDtoView = Iterables.transform(
                pz0PracticedPerennialCropCycles,
                Pz0PracticedPerennialCropCycleToPracticedPerennialCropCycleDto());
        return Lists.newArrayList(PracticedPerennialCropCycleDtoView);
    }

    protected List<PracticedSeasonalCropCycleDto> getPracticedSeasonalCropCycleDtos(List<Pz0PracticedSeasonalCropCycle> pz0PracticedSeasonalCropCycles) {
        Iterable<PracticedSeasonalCropCycleDto> pz0PracticedSeasonalCropCyclesView = Iterables.transform(
                pz0PracticedSeasonalCropCycles,
                pz0PracticedSeasonalCropCycleToPracticedSeasonalCropCycleDto());
        return Lists.newArrayList(pz0PracticedSeasonalCropCyclesView);
    }

    protected Function<Pz0PracticedPerennialCropCycle, PracticedPerennialCropCycleDto> Pz0PracticedPerennialCropCycleToPracticedPerennialCropCycleDto() {
        return new Function<Pz0PracticedPerennialCropCycle, PracticedPerennialCropCycleDto>() {
            @Override
            public PracticedPerennialCropCycleDto apply(Pz0PracticedPerennialCropCycle input) {
                return input.getPracticedPerennialCropCycleDto();
            }
        };
    }

    protected Function<Pz0PracticedSeasonalCropCycle, PracticedSeasonalCropCycleDto> pz0PracticedSeasonalCropCycleToPracticedSeasonalCropCycleDto() {
        return new Function<Pz0PracticedSeasonalCropCycle, PracticedSeasonalCropCycleDto>() {
            @Override
            public PracticedSeasonalCropCycleDto apply(Pz0PracticedSeasonalCropCycle input) {
                return input.getPracticedSeasonalCropCycleDto();
            }
        };
    }

    protected void exportToolsCouplingsSpeciesActionsInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity model) throws CloneNotSupportedException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        //EffectiveCropCycleExportEntity export;
        if (itk.getToolsCouplingCodes() != null && !itk.getToolsCouplingCodes().isEmpty()) {
            Collection<String> tcCodes = itk.getToolsCouplingCodes();
            for (String tcCode : tcCodes) {
                ToolsCoupling toolsCoupling = toolsCouplingDao.forProperties(ToolsCoupling.PROPERTY_CODE, tcCode).findAny();
                ExportUtils.setExtraField(model, "toolsCouplings", toolsCoupling.getToolsCouplingName());
                // add species, actions, inputs fields
                exportSpeciesActionsInputsFields(itkEntities, itk, model);
            }

        } else {
            // add species, actions, inputs fields
            exportSpeciesActionsInputsFields(itkEntities, itk, model);
        }
    }

    protected void exportSpeciesActionsInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity model) throws CloneNotSupportedException {
        if (itk.getSpeciesStadesDtos() != null && !itk.getSpeciesStadesDtos().isEmpty()) {
            for(SpeciesStadeDto stade : itk.getSpeciesStadesDtos()) {
                // add actions and inputs fields
                Collection<AbstractAction> actions = itk.getActions();
                for (AbstractAction action:actions) {
                    exportSpeciesStadeFields(stade, model);
                    exportActionFields(action, model);

                    // inputs
                    exportInputsFields(itkEntities, itk, model);

                }
            }
        } else {
            // add actions and inputs fields
            Collection<AbstractAction> actions = itk.getActions();
            for (AbstractAction action:actions) {
                exportActionFields(action, model);
                // inputs
                exportInputsFields(itkEntities, itk, model);
            }
        }
    }

    protected void exportSpeciesStadeFields(SpeciesStadeDto speciesStadeDto, PracticedSystemEntity model) {
        ExportUtils.setExtraField(model, "species", speciesStadeDto.getSpeciesName());
        String stadeMin = speciesStadeDto.getStadeMin() != null ? speciesStadeDto.getStadeMin().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMin", stadeMin);
        String stadeMax = speciesStadeDto.getStadeMax() != null ? speciesStadeDto.getStadeMax().getLabel() : null;
        ExportUtils.setExtraField(model, "stadeMax",stadeMax);
    }

    protected void exportActionFields(AbstractAction action, PracticedSystemEntity export) {
        ExportUtils.setExtraField(export, "actionType", action.getMainAction().getIntervention_agrosyst());
        ExportUtils.setExtraField(export, "action", action.getMainAction().getReference_label());
        ExportUtils.setExtraField(export, "mainAction", StringUtils.isNotBlank(action.getToolsCouplingCode()));
    }

    protected void exportInputsFields(List<PracticedSystemEntity> itkEntities, PracticedInterventionDto itk, PracticedSystemEntity export) throws CloneNotSupportedException {
        List<AbstractInput> inputs = itk.getInputs();
        if (inputs != null && !inputs.isEmpty()) {
            for (AbstractInput input: inputs) {
                PracticedSystemEntity model = (PracticedSystemEntity) export.clone();
                String unit = "";
                AgrosystInterventionType actionType = input.getInputType();
                switch (actionType) {
                    case APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX:
                        unit = ((MineralProductInput)input).getMineralProductUnit().name();
                        break;
                    case EPANDAGES_ORGANIQUES:
                        unit = ((OrganicProductInput)input).getOrganicProductUnit().name();
                        break;
                    case APPLICATION_DE_PRODUITS_PHYTOSANITAIRES:
                    case LUTTE_BIOLOGIQUE:
                    case SEMIS:
                        if (((PhytoProductInput)input).getPhytoProductUnit() != null) {
                            unit = ((PhytoProductInput)input).getPhytoProductUnit().name();
                        }
                        break;
                    case AUTRE:
                        unit = ((OtherProductInput)input).getOtherProductQtUnit();
                        break;
                    default:
                        throw new UnsupportedOperationException("Unsupported input type: " + actionType);
                }

                ExportUtils.setExtraField(model, "inputType", input.getInputType());
                ExportUtils.setExtraField(model, "product", input.getProductName());
                ExportUtils.setExtraField(model, "qtMin", input.getQtMin());
                ExportUtils.setExtraField(model, "qtAvg", input.getQtAvg());
                ExportUtils.setExtraField(model, "qtMed", input.getQtMed());
                ExportUtils.setExtraField(model, "qtMax", input.getQtMax());
                ExportUtils.setExtraField(model, "unit", unit);

                itkEntities.add(model);
            }
        } else {
            PracticedSystemEntity model = (PracticedSystemEntity) export.clone();
            itkEntities.add(model);
        }
    }

    protected PracticedSystemEntity exportCommonInterventionFields(
            PracticedSystemEntity model,
            boolean isSeasonal,
            String cropName,
            String previousCropName,
            Integer rank,
            CropCyclePhaseType phaseType,
            PracticedInterventionDto itk) throws CloneNotSupportedException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {

        PracticedSystemEntity export;
        export = (PracticedSystemEntity) model.clone();

        String cycle = isSeasonal ? "Assolé" : "Pérenne";
        ExportUtils.setExtraField(export, "itk_cycle", cycle);

        ExportUtils.setExtraField(export, "itk_crop", cropName);

        ExportUtils.setExtraField(export, "itk_previous_crop", previousCropName);

        ExportUtils.setExtraField(export, "itk_rank", rank == null ? null : rank + 1);

        ExportUtils.setExtraField(export, "itk_phase", phaseType);

        ExportUtils.copyFields(itk, export, null,
                PracticedIntervention.PROPERTY_NAME,
                PracticedIntervention.PROPERTY_TYPE,
                PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE,
                PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE,
                // psci
                PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY,
                // toolsCouplings
                PracticedIntervention.PROPERTY_PROGRESSION_SPEED,
                PracticedIntervention.PROPERTY_INVOLVED_PEOPLE_NUMBER,
                PracticedIntervention.PROPERTY_WORK_RATE,
                // spendingTime
                PracticedIntervention.PROPERTY_INTERMEDIATE_CROP,
                PracticedIntervention.PROPERTY_COMMENT);
        Double workRate = itk.getWorkRate();
        Double spendingTime = (workRate != null && workRate != 0) ? ((1/workRate) * 1000)/1000 : null;

        Double psci = itk.getTemporalFrequency() * itk.getSpatialFrequency();
        ExportUtils.setExtraField(export, "PSCi", psci);

        ExportUtils.setExtraField(export, "spendingTime", spendingTime);

        return export;
    }


}
