package fr.inra.agrosyst.services.plot.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PlotExportEntity.java 3929 2014-03-31 13:00:58Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/plot/export/PlotExportEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Map;

import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class PlotExportEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 8510145353855036360L;

    protected String plotName;

    protected String domainName;

    protected Integer campaign;

    protected Map<String, Object> extra;

    public String getPlotName() {
        return plotName;
    }

    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PlotExportEntity clone = (PlotExportEntity) super.clone();
        return clone;
    }
}
