package fr.inra.agrosyst.services.performance;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: PerformanceThread.java 3450 2014-02-24 17:13:06Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/performance/PerformanceThread.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.services.ServiceContext;

/**
 * Thread lancé après la creation ou la mise à jour d'une performance pour générer le fichier
 * Excel.
 * 
 * @author Eric Chatellier
 */
public class PerformanceThread extends Thread {

    private static final Log log = LogFactory.getLog(PerformanceThread.class);

    /** Service context dédié au thread. */
    protected ServiceContext serviceContext;

    /** Performance to generate file. */
    protected String performanceId;

    public PerformanceThread(ServiceContext serviceContext, String performanceId) {
        super("PerformanceThread-" + performanceId);
        this.serviceContext = serviceContext;
        this.performanceId = performanceId;
    }

    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info("Starting performance thread for performance " + performanceId);
        }
        try {
            PerformanceService performanceService = serviceContext.newService(PerformanceService.class);
            performanceService.generatePerformanceFile(performanceId);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate performance file", ex);
            }
        } finally {
            serviceContext.close();
        }
        if (log.isInfoEnabled()) {
            log.info("Performance thread finished for " + performanceId);
        }
    }
}
