package fr.inra.agrosyst.services.performance;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: IndicatorWriter.java 4324 2014-09-11 13:06:43Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/performance/IndicatorWriter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;

public interface IndicatorWriter {

    /**
     * Init writer if needed.
     */
    void init();

    /**
     * Finalize writer if needed.
     */
    void finish();

    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, Double value);
    
    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, Double value);

    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem, Double value);
    
    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Double value);

    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Double value);

    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone, Double value);

    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem,
            CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value);
    
    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem,
            CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, Double value);
    
    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem,
            CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, Double value);
    
    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem,
            CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, Double value);

    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem,
            CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, PracticedIntervention intervention,
            Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value);
    
    void writePracticed(String indicatorCategory, String indicatorName, String campaigns, Domain domain, GrowingSystem growingSystem, PracticedSystem practicedSystem,
            CroppingPlanEntry croppingPlanEntry, PracticedCropCyclePhase phase, PracticedIntervention intervention,
            Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value);

    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone,
            CroppingPlanEntry croppingPlanEntry, CroppingPlanEntry previousPlanEntry, EffectiveIntervention intervention,
            Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value);
    
    void writeEffective(String indicatorCategory, String indicatorName, int campaign, Domain domain, GrowingSystem growingSystem, Plot plot, Zone zone,
            CroppingPlanEntry croppingPlanEntry, EffectiveCropCyclePhase phase, EffectiveIntervention intervention,
            Collection<AbstractAction> actions, Collection<AbstractInput> inputs, Double value);
}
