package fr.inra.agrosyst.services.network;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: Networks.java 3338 2014-02-19 13:49:29Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/network/Networks.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.services.network.NetworkManagerDto;
import fr.inra.agrosyst.api.services.users.Users;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class Networks {

    public static final Function<NetworkManager, NetworkManagerDto> TO_MANAGER_DTO = new Function<NetworkManager, NetworkManagerDto>() {
        @Override
        public NetworkManagerDto apply(NetworkManager input) {
            NetworkManagerDto result = new NetworkManagerDto();
            result.setTopiaId(input.getTopiaId());
            result.setActive(input.isActive());
            result.setFromDate(input.getFromDate());
            result.setToDate(input.getToDate());
            result.setUser(Users.TO_USER_DTO.apply(input.getAgrosystUser()));
            return result;
        }
    };

}
