package fr.inra.agrosyst.services.network;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: NetworkImportModel.java 3452 2014-02-24 23:58:35Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/network/NetworkImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

/**
 * Modele d'import des réseaux.
 * 
 * <ul>
 * <li>Reseau
 * <li>Responsable
 * <li>
 * </ul>
 * 
 * @author Eric Chatellier
 */
public class NetworkImportModel extends AbstractAgrosystModel<NetworkImportDto> {

    public NetworkImportModel() {
        super(';');

        newMandatoryColumn("Reseau", NetworkImportDto.PROPERTY_NAME);
        newMandatoryColumn("Responsable", NetworkImportDto.PROPERTY_RESPONSIBLE);
        newMandatoryColumn("Reseaux parents", NetworkImportDto.PROPERTY_PARENT_NETWORKS);
    }

    @Override
    public NetworkImportDto newEmptyInstance() {
        return new NetworkImportDto();
    }
}
