package fr.inra.agrosyst.services.measurement.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: MeasurementExportMetadata.java 4279 2014-08-29 15:16:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/measurement/export/MeasurementExportMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefAdventiceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.ExportUtils;
import fr.inra.agrosyst.services.common.export.UniqueDualLinkedHashMap;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import java.util.Map;

/**
 * @author David Cossé
 */
public class MeasurementExportMetadata {

    public abstract static class MeasurementCommonBeanInfo implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new UniqueDualLinkedHashMap<String, String>();
            result.put("zoneName", "Zone");
            result.put("plotName", "Parcelle");
            result.put("growingSystemName", "Système De Culture");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");

            result.put(MeasurementSession.PROPERTY_START_DATE, "Date de début");
            result.put(MeasurementSession.PROPERTY_END_DATE, "Date de fin");

            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new UniqueDualLinkedHashMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            result.put(Measurement.PROPERTY_MEASUREMENT_TYPE, ExportUtils.allStringOf(MeasurementType.class));
            result.put(Measure.PROPERTY_MEASURE_TYPE, ExportUtils.allStringOf(MeasureType.class));
            return result;
        }
    }

    public static class MeasurementMainBeanInfo extends MeasurementCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Synthèse";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(Measurement.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measurement.PROPERTY_MEASUREMENT_TYPE, "Type d’observation");
            // variable
            columns.put("variable", "Variable");
            // valeur
            columns.put("value", "Valeur");

            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put("variable", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String variable = "";

                    if (input != null) {
                        if (input instanceof Measure) {
                            Measure measure = (Measure) input;
                            if (measure.getRefMesure() != null) {
                                variable += measure.getRefMesure().getVariable_mesuree();
                            }
                        } else if (input instanceof Observation) {
                            Observation observation = (Observation) input;
                            if (observation.getMeasurementType() == MeasurementType.ADVENTICES) {

                                if (observation.getMeasuredAdventice() != null
                                        && !Strings.isNullOrEmpty(observation.getMeasuredAdventice().getAdventice())) {
                                    variable += observation.getMeasuredAdventice().getAdventice();
                                }
                            }
                            if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {
                                if (observation.getPest() != null && !Strings.isNullOrEmpty(observation.getPest().getReference_label())) {
                                    variable += observation.getPest().getReference_label();
                                } else if (observation.getProtocol() != null
                                        && !Strings.isNullOrEmpty(observation.getProtocol().getProtocole_libelle())) {
                                    variable += observation.getProtocol().getProtocole_libelle();
                                }
                            }
                        }
                    }

                    return variable;
                }
            });

            result.put("value", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String value = "";
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (!Strings.isNullOrEmpty(measure.getMeasureValue())) {
                            value += measure.getMeasureValue() + " ";
                        }
                        if (!Strings.isNullOrEmpty(measure.getMeasureUnit())) {
                            value += measure.getMeasureUnit() + " ";
                        }
                    } else if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getMeasurementType() == MeasurementType.ADVENTICES) {
                            if (observation.getAdventiceStage() != null) {
                                value += observation.getAdventiceStage().getColonne2() + " ";
                            }
                        }
                        if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {
                            value += observation.getQuantitativeValue() != null ? String.valueOf(observation.getQuantitativeValue()) : "";
                        }
                        if (observation.getMeasurementType() == MeasurementType.STADE_CULTURE) {
                            if (observation.getCropNumberObserved() != null) {
                                value += observation.getCropNumberObserved() + " ";
                            }
                        }

                        if (observation.getMeasurementType() == MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES) {

                            if (observation.isProtocolVgObs()) {
                                if (observation.getProtocol() != null
                                        && !Strings.isNullOrEmpty(observation.getProtocol().getReleve_qualifiant_unite_mesure())) {
                                    value += observation.getProtocol().getReleve_qualifiant_unite_mesure();
                                }
                            } else {
                                if (observation.getCropUnitQualifier() != null
                                        && !Strings.isNullOrEmpty(observation.getCropUnitQualifier().getReference_label())) {
                                    value += observation.getCropUnitQualifier().getReference_label();
                                } else if (!Strings.isNullOrEmpty(observation.getUnitEDI())) {
                                    value += observation.getUnitEDI();
                                }
                            }
                        }
                    }

                    return value;
                }
            });

            return result;
        }
    }

    public static class MeasurementStadeCultureBeanInfo extends MeasurementCommonBeanInfo {
        protected RefEspeceTopiaDao refEspeceTopiaDao;
        protected RefStadeEDITopiaDao refStadeEDITopiaDao;
        public void setRefEspeceTopiaDao(RefEspeceTopiaDao refEspeceTopiaDao) {
            this.refEspeceTopiaDao = refEspeceTopiaDao;
        }
        public void setRefStadeEDITopiaDao(RefStadeEDITopiaDao refStadeEDITopiaDao) {
            this.refStadeEDITopiaDao = refStadeEDITopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Stade de culture";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Observation.PROPERTY_MEASUREMENT_TYPE, "Type d’observation");
            columns.put(RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE, "Espèce");
            columns.put(RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE, "Qualifiant");
            columns.put(RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE, "Type saisonnier");
            columns.put(RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE, "Destination");
            columns.put(Observation.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Observation.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Observation.PROPERTY_CROP_NUMBER_OBSERVED, "Nombre de plantes observées");
            columns.put(Observation.PROPERTY_CROP_STAGE_MIN, "Stade mini");
            columns.put(Observation.PROPERTY_CROP_STAGE_AVERAGE, "Stade moyen");
            columns.put(Observation.PROPERTY_CROP_STAGE_MEDIUM, "Stade median");
            columns.put(Observation.PROPERTY_CROP_STAGE_MAX, "Stade maxi");
            columns.put(Observation.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCroppingPlanSpecies() != null) {
                            result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_espece_botanique();
                        }
                    }
                    return result;
                }
            });
            result.put(RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCroppingPlanSpecies() != null) {
                            result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_qualifiant_AEE();
                        }
                    }
                    return result;
                }
            });
            result.put(RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCroppingPlanSpecies() != null) {
                            result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_type_saisonnier_AEE();
                        }
                    }
                    return result;
                }
            });
            result.put(RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCroppingPlanSpecies() != null) {
                            result = observation.getCroppingPlanSpecies().getSpecies().getLibelle_destination_AEE();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_STAGE_MIN, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropStageMin() != null) {
                            result = observation.getCropStageMin().getColonne2();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_STAGE_AVERAGE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropStageMin() != null) {
                            result = observation.getCropStageAverage().getColonne2();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_STAGE_MAX, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropStageMin() != null) {
                            result = observation.getCropStageMax().getColonne2();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(CroppingPlanEntry.PROPERTY_TYPE, ExportUtils.allStringOf(CroppingEntryType.class));
            result.put(RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE, refEspeceTopiaDao.findPropertyDistinctValues(RefEspece.PROPERTY_LIBELLE_ESPECE_BOTANIQUE));
            result.put(RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE, refEspeceTopiaDao.findPropertyDistinctValues(RefEspece.PROPERTY_LIBELLE_QUALIFIANT__AEE));
            result.put(RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE, refEspeceTopiaDao.findPropertyDistinctValues(RefEspece.PROPERTY_LIBELLE_TYPE_SAISONNIER__AEE));
            result.put(RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE, refEspeceTopiaDao.findPropertyDistinctValues(RefEspece.PROPERTY_LIBELLE_DESTINATION__AEE));
            result.put(Observation.PROPERTY_CROP_STAGE_MIN, refStadeEDITopiaDao.findPropertyDistinctValues(RefStadeEDI.PROPERTY_COLONNE2));
            result.put(Observation.PROPERTY_CROP_STAGE_MAX, refStadeEDITopiaDao.findPropertyDistinctValues(RefStadeEDI.PROPERTY_COLONNE2));
            result.put(Observation.PROPERTY_CROP_STAGE_AVERAGE, refStadeEDITopiaDao.findPropertyDistinctValues(RefStadeEDI.PROPERTY_COLONNE2));
            result.put(Observation.PROPERTY_CROP_STAGE_MEDIUM, refStadeEDITopiaDao.findPropertyDistinctValues(RefStadeEDI.PROPERTY_COLONNE2));
            
            return result;
        }
    }

    public static class MeasurementAdventicesBeanInfo extends MeasurementCommonBeanInfo {
        protected RefStadeEDITopiaDao refStadeEDITopiaDao;
        protected RefAdventiceTopiaDao refAdventiceTopiaDao;
        public void setRefAdventiceTopiaDao(RefAdventiceTopiaDao refAdventiceTopiaDao) {
            this.refAdventiceTopiaDao = refAdventiceTopiaDao;
        }
        public void setRefStadeEDITopiaDao(RefStadeEDITopiaDao refStadeEDITopiaDao) {
            this.refStadeEDITopiaDao = refStadeEDITopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Adventices";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Observation.PROPERTY_MEASUREMENT_TYPE, "Type d’observation");
            columns.put(Observation.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Observation.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Observation.PROPERTY_MEASURED_ADVENTICE, "Adventice mesurée");
            columns.put(Observation.PROPERTY_ADVENTICE_STAGE, "Stade adventice");
            columns.put(Observation.PROPERTY_ADVENTICE_MIN, "Nombre mini/m²");
            columns.put(Observation.PROPERTY_ADVENTICE_AVERAGE, "Nombre moyen/m²");
            columns.put(Observation.PROPERTY_ADVENTICE_MAX, "Nombre maxi/m²");
            columns.put(Observation.PROPERTY_ADVENTICE_MEDIAN, "Nombre median/m²");
            columns.put(Observation.PROPERTY_COMMENT, "Commentaire");

            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(Observation.PROPERTY_MEASURED_ADVENTICE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getMeasuredAdventice() != null) {
                            result = observation.getMeasuredAdventice().getAdventice();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_ADVENTICE_STAGE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getAdventiceStage() != null) {
                            result = observation.getAdventiceStage().getColonne2();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(Observation.PROPERTY_MEASURED_ADVENTICE, refAdventiceTopiaDao.findPropertyDistinctValues(RefAdventice.PROPERTY_ADVENTICE));
            result.put(Observation.PROPERTY_ADVENTICE_STAGE, refStadeEDITopiaDao.findPropertyDistinctValues(RefStadeEDI.PROPERTY_COLONNE2));
            
            return result;
        }
    }

    public static class MeasurementNuisibleMaladiesPhysiologiquesAuxBeanInfo extends MeasurementCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            // warn, can't set very long tab title in hssf
            return "Nuisibles-Maladies-Auxiliaires";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Observation.PROPERTY_MEASUREMENT_TYPE, "Type d’observation");

            columns.put(Observation.PROPERTY_PROTOCOL, "Protocole VgObs");
            columns.put(Observation.PROPERTY_MEASURING_PROTOCOL, "Autre protocole");
            columns.put(Observation.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Observation.PROPERTY_CROP_NUMBER_OBSERVED, "Nombre de plantes observées");
            columns.put(Observation.PROPERTY_PEST, "Nuisible");
            columns.put(Observation.PROPERTY_CROP_ORGANISM_STAGE, "Stade organisme observé");
            columns.put(Observation.PROPERTY_CROP_ORGAN_SUPPORT, "Support organe observé");
            columns.put(Observation.PROPERTY_CROP_NOTATION_TYPE, "Type de notation");
            columns.put(Observation.PROPERTY_CROP_QUALITITIVE_VALUE, "Valeur qualitative");
            columns.put(Observation.PROPERTY_QUANTITATIVE_VALUE, "Valeur quantitative");
            columns.put(Observation.PROPERTY_UNIT_EDI, "Unite EDI");
            columns.put(Observation.PROPERTY_CROP_UNIT_QUALIFIER, "Qualifiant EDI");
            columns.put(Observation.PROPERTY_UNIT_OTHER, "Unite autre");
            columns.put(Observation.PROPERTY_OTHER_QUALIFIER, "Qualifiant autre");

            columns.put(Observation.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(Observation.PROPERTY_PROTOCOL, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getProtocol() != null) {
                            result = observation.getProtocol().getProtocole_libelle();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_PEST, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getPest() != null) {
                            result = observation.getPest().getReference_label();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_ORGANISM_STAGE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropOrganismStage() != null) {
                            result = observation.getCropOrganismStage().getReference_label();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_ORGAN_SUPPORT, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropOrganSupport() != null) {
                            result = observation.getCropOrganSupport().getReference_label();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_NOTATION_TYPE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropNotationType() != null) {
                            result = observation.getCropNotationType().getReference_label();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_QUALITITIVE_VALUE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropQualititiveValue() != null) {
                            result = observation.getCropQualititiveValue().getReference_label();
                        }
                    }
                    return result;
                }
            });

            result.put(Observation.PROPERTY_CROP_UNIT_QUALIFIER, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Observation) {
                        Observation observation = (Observation) input;
                        if (observation.getCropUnitQualifier() != null) {
                            result = observation.getCropUnitQualifier().getReference_label();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
    }

    public static class MeasurementPlanteInfo extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Plantes";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Measure.PROPERTY_MEASUREMENT_TYPE, "Catégorie de mesure");
            columns.put(Measure.PROPERTY_CROPPING_PLAN_SPECIES, "Espèce");
            columns.put(Measure.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Measure.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measure.PROPERTY_EFFECTIVE_OR_AREA_TAKEN, "Effectif ou surface prélevée");
            columns.put(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, "Type de variable mesurée");
            columns.put(RefMesure.PROPERTY_VARIABLE_MESUREE, "Variable mesurée");
            columns.put(Measure.PROPERTY_MEASURE_TYPE, "Type de mesure");
            columns.put(Measure.PROPERTY_MEASURE_VALUE, "Valeur de mesure");
            columns.put(Measure.PROPERTY_MEASURE_UNIT, "Unité de mesure");
            columns.put(Measure.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(Measure.PROPERTY_CROPPING_PLAN_SPECIES, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getCroppingPlanSpecies() != null) {
                            result = measure.getCroppingPlanSpecies().getSpecies().getEspece();
                        }
                    }
                    return result;
                }
            });

            result.put(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    VariableType result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getType_variable_mesuree();
                        }
                    }
                    return result;
                }
            });

            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getVariable_mesuree();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, refMesureTopiaDao.findPropertyDistinctValues(RefMesure.PROPERTY_VARIABLE_MESUREE));
            return result;
        }
    }

    public static class MeasurementSolInfo extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Sol";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Measure.PROPERTY_MEASUREMENT_TYPE, "Catégorie de mesure");
            columns.put(Measure.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Measure.PROPERTY_HORIZON_TYPE, "Horizon mesuré");
            columns.put(Measure.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measure.PROPERTY_SAMPLING, "Echantillonnage");
            columns.put(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, "Type de variable mesurée");
            columns.put(RefMesure.PROPERTY_VARIABLE_MESUREE, "Variable mesurée");
            columns.put(Measure.PROPERTY_MEASURE_TYPE, "Type de mesure");
            columns.put(Measure.PROPERTY_MEASURE_VALUE, "Valeur de mesure");
            columns.put(Measure.PROPERTY_MEASURE_UNIT, "Unité de mesure");
            columns.put(Measure.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(Measure.PROPERTY_CROPPING_PLAN_SPECIES, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getCroppingPlanSpecies() != null) {
                            result = measure.getCroppingPlanSpecies().getSpecies().getEspece();
                        }
                    }
                    return result;
                }
            });

            result.put(RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    VariableType result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getType_variable_mesuree();
                        }
                    }
                    return result;
                }
            });

            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getVariable_mesuree();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(Measure.PROPERTY_HORIZON_TYPE, ExportUtils.allStringOf(HorizonType.class));
            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, refMesureTopiaDao.findPropertyDistinctValues(RefMesure.PROPERTY_VARIABLE_MESUREE));
            return result;
        }
    }

    public static class MeasurementTransferDeSolutesInfo extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        protected RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao;
        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }
        public void setRefActaSubstanceActiveTopiaDao(RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao) {
            this.refActaSubstanceActiveTopiaDao = refActaSubstanceActiveTopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Transfer de solutés";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Measure.PROPERTY_MEASUREMENT_TYPE, "Catégorie de mesure");
            columns.put(Measure.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Measure.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measure.PROPERTY_SAMPLING, "Echantillonnage");
            columns.put(RefMesure.PROPERTY_VARIABLE_MESUREE, "Variable mesurée");
            columns.put(Measure.PROPERTY_ACTIVE_SUBSTANCE, "Molécule phytosanitaire mesurée");
            columns.put(Measure.PROPERTY_NITROGEN_MOLECULE, "Molécule azotée mesurée");
            columns.put(Measure.PROPERTY_MEASURE_TYPE, "Type de mesure");
            columns.put(Measure.PROPERTY_MEASURE_VALUE, "Valeur de mesure");
            columns.put(Measure.PROPERTY_MEASURE_UNIT, "Unité de mesure");
            columns.put(Measure.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getVariable_mesuree();
                        }
                    }
                    return result;
                }
            });

            result.put(Measure.PROPERTY_ACTIVE_SUBSTANCE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getActiveSubstance() != null) {
                            result = measure.getActiveSubstance().getNom_produit();
                        }
                    }
                    return result;
                }
            });

            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(Measure.PROPERTY_NITROGEN_MOLECULE, ExportUtils.allStringOf(NitrogenMolecule.class));
            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, refMesureTopiaDao.findPropertyDistinctValues(RefMesure.PROPERTY_VARIABLE_MESUREE));
            result.put(Measure.PROPERTY_ACTIVE_SUBSTANCE, refActaSubstanceActiveTopiaDao.findPropertyDistinctValues(RefActaSubstanceActive.PROPERTY_NOM_PRODUIT));
            return result;
        }
    }

    public static class MeasurementGesInfo extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Gaz à effet de serre";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Measure.PROPERTY_MEASUREMENT_TYPE, "Catégorie de mesure");
            columns.put(Measure.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Measure.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measure.PROPERTY_SAMPLING, "Echantillonnage");
            columns.put(RefMesure.PROPERTY_VARIABLE_MESUREE, "Variable mesurée");
            columns.put(Measure.PROPERTY_MEASURE_TYPE, "Type de mesure");
            columns.put(Measure.PROPERTY_MEASURE_VALUE, "Valeur de mesure");
            columns.put(Measure.PROPERTY_MEASURE_UNIT, "Unité de mesure");
            columns.put(Measure.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getVariable_mesuree();
                        }
                    }
                    return result;
                }
            });
            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, refMesureTopiaDao.findPropertyDistinctValues(RefMesure.PROPERTY_VARIABLE_MESUREE));
            return result;
        }
    }

    public static class MeasurementMeteoInfo extends MeasurementCommonBeanInfo {
        protected RefMesureTopiaDao refMesureTopiaDao;
        public void setRefMesureTopiaDao(RefMesureTopiaDao refMesureTopiaDao) {
            this.refMesureTopiaDao = refMesureTopiaDao;
        }
        @Override
        public String getBeanTitle() {
            return "Météo";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(Measure.PROPERTY_MEASUREMENT_TYPE, "Catégorie de mesure");
            columns.put(Measure.PROPERTY_MEASURING_PROTOCOL, "Protocole de mesure");
            columns.put(Measure.PROPERTY_REPETITION_NUMBER, "Numéro de répétition");
            columns.put(Measure.PROPERTY_SAMPLING, "Echantillonnage");
            columns.put(RefMesure.PROPERTY_VARIABLE_MESUREE, "Variable mesurée");
            columns.put(Measure.PROPERTY_MEASURE_TYPE, "Type de mesure");
            columns.put(Measure.PROPERTY_MEASURE_VALUE, "Valeur de mesure");
            columns.put(Measure.PROPERTY_MEASURE_UNIT, "Unité de mesure");
            columns.put(Measure.PROPERTY_COMMENT, "Commentaire");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String result = null;
                    if (input instanceof Measure) {
                        Measure measure = (Measure) input;
                        if (measure.getRefMesure() != null) {
                            result = measure.getRefMesure().getVariable_mesuree();
                        }
                    }
                    return result;
                }
            });
            return result;
        }
        
        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = super.getCustomDropDownList();
            result.put(RefMesure.PROPERTY_VARIABLE_MESUREE, refMesureTopiaDao.findPropertyDistinctValues(RefMesure.PROPERTY_VARIABLE_MESUREE));
            return result;
        }
    }
}
