package fr.inra.agrosyst.services.measurement.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: MeasurementExportEntity.java 3906 2014-03-29 17:08:06Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/measurement/export/MeasurementExportEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Date;

import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author David Cossé
 */
public class MeasurementExportEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 4350120641572612423L;

    protected String zoneName;

    protected String plotName;

    protected String growingSystemName;

    protected String growingPlanName;

    protected String domainName;

    protected Integer campaign;

    protected Date startDate;

    protected Date endDate;

    public String getPlotName() {
        return plotName;
    }

    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    public String getGrowingSystemName() {
        return growingSystemName;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    public String getGrowingPlanName() {
        return growingPlanName;
    }

    public void setGrowingPlanName(String growingPlanName) {
        this.growingPlanName = growingPlanName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    public String getZoneName() {
        return zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    
    @Override
    public Object clone() throws CloneNotSupportedException {
        MeasurementExportEntity clone = (MeasurementExportEntity) super.clone();
        return clone;
    }
}
