package fr.inra.agrosyst.services.managementmode.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ManagementModeExportMetadata.java 3937 2014-03-31 16:03:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/managementmode/export/ManagementModeExportMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.Section;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;

/**
 * @author David Cossé
 */
public class ManagementModeExportMetadata {

    public abstract static class ManagementModeCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("category", "Modes de gestion");
            result.put("growingSystemName", "Système de culture");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");
            result.put("campaign", "campagne");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            return result;
        }

    }

    public static class ManagementModeMainBeanInfo extends ManagementModeCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Généralités";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(ManagementMode.PROPERTY_MAIN_CHANGES, "Principaux changements");
            columns.put(ManagementMode.PROPERTY_CHANGE_REASON, "Motifs de changement");
            columns.put(ManagementMode.PROPERTY_CHANGE_REASON_FROM_PLANNED, "Principaux changements depuis le prévu");
            columns.put(ManagementMode.PROPERTY_MAIN_CHANGES_FROM_PLANNED, "Motifs de changement depuis le prévu");
            //columns.put(ManagementMode.PROPERTY_HISTORICAL, "Historique");
            return columns;
        }
    }


    public static class ManagementModeSectionBeanInfo extends ManagementModeCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Rubriques";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();

            // section;
            columns.put(Section.PROPERTY_SECTION_TYPE, "Type de rubrique");
            columns.put(Section.PROPERTY_AGRONOMIC_OBJECTIVE, "Objectifs agronomiques");
            columns.put(Section.PROPERTY_CATEGORY_OBJECTIVE, "Catégorie d'objectif");
            columns.put(Section.PROPERTY_EXPECTED_RESULT, "Résultats attendus");
            columns.put(Section.PROPERTY_BIO_AGRESSOR_TYPE, "Type de bio-agresseur");
            columns.put(Section.PROPERTY_BIO_AGRESSOR, "Bio-agresseur considéré");
            columns.put(Section.PROPERTY_CATEGORY_STRATEGY, "Catégorie de stratégie globale");

            // startegies
            columns.put("StrategyMultiannual", "Type de stratégie");
            columns.put("StrategyExplanation", "Explication");
            columns.put("StrategyCroppingPlanEntry", "Culture");

            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(Section.PROPERTY_BIO_AGRESSOR, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    Preconditions.checkArgument(input instanceof Section);
                    Section section = (Section) input;
                    RefBioAgressor bioAgressor = section.getBioAgressor();
                    String result = null;
                    if (bioAgressor != null) {
                        result = bioAgressor.getLabel();
                    }
                    return result;
                }
            });

            return result;
        }
    }

}
