package fr.inra.agrosyst.services.managementmode.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ManagementModeExportEntity.java 3906 2014-03-29 17:08:06Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/managementmode/export/ManagementModeExportEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author David Cossé
 */
public class ManagementModeExportEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {


    private static final long serialVersionUID = 3157632741261632044L;

    protected ManagementModeCategory category;

    protected Integer versionNumber;

    protected String growingSystemName;

    protected String growingPlanName;

    protected String domainName;

    protected Integer campaign;

    public ManagementModeCategory getCategory() {
        return category;
    }

    public void setCategory(ManagementModeCategory category) {
        this.category = category;
    }

    public Integer getVersionNumber() {
        return versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getGrowingSystemName() {
        return growingSystemName;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    public String getGrowingPlanName() {
        return growingPlanName;
    }

    public void setGrowingPlanName(String growingPlanName) {
        this.growingPlanName = growingPlanName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ManagementModeExportEntity clone = (ManagementModeExportEntity) super.clone();
        return clone;
    }
}
