package fr.inra.agrosyst.services.managementmode.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: DecisionRuleExportMetadata.java 3947 2014-03-31 17:36:10Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/managementmode/export/DecisionRuleExportMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;

/**
 * @author David Cossé
 */
public class DecisionRuleExportMetadata {

    public abstract static class DecisionRuleCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        protected CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao;

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("domainName","Domaine");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            return result;
        }

        public void setCroppingPlanEntryTopiaDao(CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao) {
            this.croppingPlanEntryTopiaDao = croppingPlanEntryTopiaDao;
        }
    }

    public static class DecisionRuleMainBeanInfo extends DecisionRuleCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Généralités";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {

            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(DecisionRule.PROPERTY_NAME, "Nom");
            columns.put(DecisionRule.PROPERTY_INTERVENTION_TYPE, "Type d'intervention");
            columns.put("croppingPlanEntry", "Culture concernée");
            columns.put(DecisionRule.PROPERTY_BIO_AGRESSOR_TYPE, "Type de bio-agresseur");
            columns.put(DecisionRule.PROPERTY_BIO_AGRESSOR, "Bio-agresseur concerné");
            columns.put(DecisionRule.PROPERTY_VERSION_NUMBER, "Version");
            columns.put(DecisionRule.PROPERTY_DOMAIN_VALIDITY, "Domaine de validité");
            columns.put(DecisionRule.PROPERTY_DECISION_OBJECT, "Objet de la décision");
            columns.put(DecisionRule.PROPERTY_USAGE_COMMENT, "Commentaire sur l'utilisation de la règle de décision");
            columns.put(DecisionRule.PROPERTY_OBJECTIVE, "Objectif");
            columns.put(DecisionRule.PROPERTY_EXPECTED_RESULT, "Résultat attendu ");
            columns.put(DecisionRule.PROPERTY_SOLUTION, "Solution");
            columns.put(DecisionRule.PROPERTY_DECISION_CRITERIA, "Critère de décision ou seuil");
            columns.put(DecisionRule.PROPERTY_OBSERVATION, "Observation ou outil");
            columns.put(DecisionRule.PROPERTY_RESULT_CRITERIA, "Critère d'évaluation du résultat attendu");
            columns.put(DecisionRule.PROPERTY_SOLUTION_COMMENT, "Commentaire sur la solution");
            columns.put(DecisionRule.PROPERTY_VERSION_REASON, "Motif de changement de version");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put(DecisionRule.PROPERTY_BIO_AGRESSOR, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule) input;
                    RefBioAgressor bioAgressor = decisionRule.getBioAgressor();
                    String result = null;
                    if (bioAgressor != null) {
                        result = bioAgressor.getLabel();
                    }
                    return result;
                }
            });

            result.put("croppingPlanEntry", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule) input;
                    String croppingPlanEntryCode = decisionRule.getCroppingPlanEntryCode();
                    String result = null;
                    if (StringUtils.isNotBlank(croppingPlanEntryCode)) {
                        CroppingPlanEntry crop = croppingPlanEntryTopiaDao.forCodeEquals(croppingPlanEntryCode).findAny();
                        result = crop.getName();
                    }
                    return result;
                }
            });

            result.put(DecisionRule.PROPERTY_SOLUTION, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    DecisionRule decisionRule = (DecisionRule) input;
                    String solution = decisionRule.getSolution();
                    String result = null;
                    if (StringUtils.isNotBlank(solution)) {
                        solution = solution.replaceAll("\\<[^>]*>","");
                        result = StringEscapeUtils.unescapeHtml4(solution);
                    }
                    return result;
                }
            });

            return result;
        }
    }
}
