package fr.inra.agrosyst.services.history;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: MessageServiceImpl.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/history/MessageServiceImpl.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.history.MessageTopiaDao;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.history.MessageFilter;
import fr.inra.agrosyst.api.services.history.MessageService;
import fr.inra.agrosyst.services.AbstractAgrosystService;

import java.util.Date;
import java.util.List;

/**
 * Created by davidcosse on 14/10/14.
 */
public class MessageServiceImpl extends AbstractAgrosystService implements MessageService {

    MessageTopiaDao messageTopiaDao;

    public void setMessageTopiaDao(MessageTopiaDao messageTopiaDao) {
        this.messageTopiaDao = messageTopiaDao;
    }

    @Override
    public void publishMessage(String title, String content) {
        Preconditions.checkNotNull(title);
        Message message = messageTopiaDao.newInstance();
        message.setTitle(title);
        message.setContent(content == null ? "" : content);
        message.setMessageDate(new Date());
        messageTopiaDao.create(message);
        getTransaction().commit();
    }


    @Override
    public ResultList<Message> getFilteredMessages(MessageFilter filter) {
        ResultList<Message> result = messageTopiaDao.getAllMessageByPage(filter);
        return result;
    }

    @Override
    public List<Message> getMessagesFromDate(Date fromDate) {
        List<Message> result;

        if (fromDate == null) {
            result = messageTopiaDao.geAllMessages();
        } else {
            result = messageTopiaDao.geMessageFromDate(fromDate);
        }
        return result;
    }

    @Override
    public Date getLastMessageDate() {
        Date result = messageTopiaDao.getLastMassageDate();
        return result;
    }
}
