package fr.inra.agrosyst.services.growingsystem.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ExportGrowingSystemMetadata.java 4567 2014-11-26 14:16:20Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/growingsystem/export/ExportGrowingSystemMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;

/**
 * @author David Cossé
 */
public class ExportGrowingSystemMetadata {

    public abstract static class GrowingSystemCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("growingSystemName", "Système De Culture");
            result.put("sector","Filière");
            result.put("startingDate","Date de début d'utilisation");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            return result;
        }
    }

    public static class GrowingSystemMainBeanInfo extends GrowingSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Généralités";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(GrowingSystem.PROPERTY_DEPHY_NUMBER, "Numéro DEPHY");
            columns.put("allNetworks", "Réseau(x) de rattachement");
            columns.put(GrowingSystem.PROPERTY_DESCRIPTION, "Description");
            columns.put(GrowingSystem.PROPERTY_ENDING_DATE, "Date de fin d'utilisation");
            columns.put(GrowingSystem.PROPERTY_END_ACTIVITY_COMMENT, "Motif de fin d'utilisation");
            columns.put(GrowingSystem.PROPERTY_AFFECTED_AREA_RATE, "Pourcentage de surface du domaine affectée");
            columns.put(GrowingSystem.PROPERTY_AFFECTED_WORK_FORCE_RATE, "Pourcentage de la main d’oeuvre affectée");
            columns.put(GrowingSystem.PROPERTY_DOMAINS_TOOLS_USAGE_RATE, "Taux d'utilisation des outils et installations du domaine");
        return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put("allNetworks", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    GrowingSystem gs = (GrowingSystem)input;
                    String result = "";
                    if (gs.getNetworks() != null && !gs.getNetworks().isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (Network network : gs.getNetworks()) {
                            sb.append(network.getName());
                            sb.append(", ");
                        }
                        result = sb.toString();
                        result = result.substring(0, result.length() - 2); // remove the last ', '
                    }
                    return result;
                }
            });

            return result;
        }
    }

    public static class GrowingSystemCaracteristicsBeanInfo extends GrowingSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Principaux traits";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put("typeAgriculture", "Type de conduite");
            columns.put("categoryStrategy", "Catégorie de stratégie globale");
//            columns.put("cultureManagement", "Conduite des cultures");
//            columns.put("cycleManagement", "Gestion du cycle pluriannuel");
//            columns.put("parcelsManagement", "Gestion extra-parcellaire ou Paysage");
//            columns.put("groudWork", "Travail du sol");
            columns.put("type_trait_sdc", "Type de charactéristiques");
            columns.put("nom_trait", "Charactéristiques");
            columns.put("characteristicComment", "Commentaires");


            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            return result;
        }
    }

    public static class GrowingSystemPlotsBeanInfo extends GrowingSystemCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Parcelles";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put(Plot.PROPERTY_NAME, "Nom de la parcelle");
            columns.put(Plot.PROPERTY_PAC_ILOT_NUMBER, "Numéro d'ilôt PAC");
            columns.put("plotOutComment", "Commentaires");


            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            return result;
        }
    }
}
