package fr.inra.agrosyst.services.growingsystem.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ExportGrowingSystemEntity.java 3947 2014-03-31 17:36:10Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/growingsystem/export/ExportGrowingSystemEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Date;

import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author David Cossé
 */
public class ExportGrowingSystemEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 6524266417729221933L;

    protected String growingSystemName;

    protected Sector sector;

    protected Date startingDate;

    protected String growingPlanName;

    protected String domainName;

    protected Integer campaign;

    public String getGrowingSystemName() {
        return growingSystemName;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    public Sector getSector() {
        return sector;
    }

    public void setSector(Sector sector) {
        this.sector = sector;
    }

    public Date getStartingDate() {
        return startingDate;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public String getGrowingPlanName() {
        return growingPlanName;
    }

    public void setGrowingPlanName(String growingPlanName) {
        this.growingPlanName = growingPlanName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExportGrowingSystemEntity clone = (ExportGrowingSystemEntity) super.clone();
        return clone;
    }
}
