package fr.inra.agrosyst.services.growingplan.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: GrowingPlanExportMetadata.java 4783 2015-02-11 16:36:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/growingplan/export/GrowingPlanExportMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;
import fr.inra.agrosyst.services.common.export.ExportUtils;

/**
 * @author David Cossé
 */
public class GrowingPlanExportMetadata{

    public abstract static class GrowingPlanCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");
            result.put("growingPlanName", "Nom du dispositif");
            result.put("typeName", "Type");
            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            result.put("typeName", ExportUtils.typeDephyToString());
            return result;
        }
    }

    public static class GrowingPlanMainBeanInfo extends GrowingPlanCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Dispositifs";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = super.getExtraColumns();
            columns.put(GrowingPlan.PROPERTY_DESCRIPTION, "Description succincte du dispositif");
            columns.put(GrowingPlan.PROPERTY_GOALS, "Objectifs du dispositif");
            columns.put(GrowingPlan.PROPERTY_PROTOCOL_REFERENCE, "Reference du protocole qui gère le dispositif");
            columns.put(GrowingPlan.PROPERTY_INSTITUTIONAL_STRUCTURE, "Partenaires institutionnels");
            return columns;
        }
    }

}
