package fr.inra.agrosyst.services.effective.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectiveCropCycleExportMetadata.java 4030 2014-04-29 10:02:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/effective/export/EffectiveCropCycleExportMetadata.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.common.export.EntityExportTabInfo;

/**
 * @author David Cossé
 */
public class EffectiveCropCycleExportMetadata {

    public abstract static class EffectiveCropCycleCommonBeanInfo extends AbstractAgrosystService implements EntityExportTabInfo {

        @Override
        public BidiMap<String, String> getCommonColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            result.put("zoneName", "Zone");
            result.put("plotName", "Parcelle");
            result.put("growingSystemName", "Système De Culture");
            result.put("growingPlanName", "Dispositif");
            result.put("domainName", "Domaine");
            result.put("campaign", "Campagne");

            return result;
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> result = new DualLinkedHashBidiMap<String, String>();
            return result;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = Maps.newLinkedHashMap();
            return result;
        }

        @Override
        public Map<String, Function<String, Object>> getCustomParsers() {
            Map<String, Function<String, Object>> result = Maps.newHashMap();
            return result;
        }

        @Override
        public Map<String, Iterable<String>> getCustomDropDownList() {
            Map<String, Iterable<String>> result = Maps.newHashMap();
            return result;
        }
    }

    public static class EffectiveCropCycleBeanInfo extends EffectiveCropCycleCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Cycles";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            columns.put("cycleType", "Cycle");
            columns.put("cropName", "Culture");
            columns.put("intermediateCropName", "Culture Intermédiaire");
            columns.put("rank", "Rang");
            columns.put("phase", "Phase");
            columns.put(EffectiveCropCyclePhaseDto.PROPERTY_DURATION, "Durée de la phase");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_YEAR,"Année de plantation");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_INTER_FURROW, "Inter-rang de plantation");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_SPACING, "Espacement de plantation sur le rang");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_DENSITY, "Densité de plantation");
            columns.put(EffectivePerennialCropCycle.PROPERTY_ORCHARD_FRUTAL_FORM, "Forme fruitière vergers");
            columns.put(EffectivePerennialCropCycle.PROPERTY_VINE_FRUTAL_FORM, "Forme fruitière vigne");
            columns.put(EffectivePerennialCropCycle.PROPERTY_ORIENTATION, "Orientation des rangs");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE, "Taux de mortalité dans la plantation");
            columns.put(EffectivePerennialCropCycle.PROPERTY_PLANTING_DEATH_RATE_MEASURE_YEAR, "Année de mesure de ce taux de mortalité");
            columns.put(EffectivePerennialCropCycle.PROPERTY_WEED_TYPE, "Type d'enherbement");
            columns.put(EffectivePerennialCropCycle.PROPERTY_POLLINATOR, "Pollinisateurs");
            columns.put(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_PERCENT, "% de pollinisateur");
            columns.put(EffectivePerennialCropCycle.PROPERTY_POLLINATOR_SPREAD_MODE, "Mode de répartition des pollinisateurs");
            columns.put(EffectivePerennialCropCycle.PROPERTY_OTHER_CHARACTERISTICS, "Autres caractéristiques du couvert végétal");
            return columns;
        }

        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            result.put("cycleType", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String cycle = null;
                    if (input instanceof EffectiveSeasonalCropCycleDto) {
                        cycle = "Assolé";
                    } else {
                        cycle = "Pérenne";
                    }
                    return cycle;
                }
            });

            result.put("cropName", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String cropName = null;
                    if (input instanceof EffectivePerennialCropCycleDto) {
                        EffectivePerennialCropCycleDto cycle = (EffectivePerennialCropCycleDto) input;
                        // only one phase in effective
                        cropName = cycle.getCroppingPlanEntryName();
                    } else if (input instanceof EffectiveSeasonalCropCycleExport) {
                        EffectiveSeasonalCropCycleExport cycle = (EffectiveSeasonalCropCycleExport) input;
                        cropName = cycle.getCropName();
                    }
                    return cropName;
                }
            });

            result.put("intermediateCropName", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String cropName = null;
                    if (input instanceof EffectiveSeasonalCropCycleExport) {
                        EffectiveSeasonalCropCycleExport cycle = (EffectiveSeasonalCropCycleExport) input;
                        cropName = cycle.getIntermediateCropName();
                    }
                    return cropName;
                }
            });

            result.put("rank", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    Integer rank = null;
                    if (input instanceof EffectiveSeasonalCropCycleExport) {
                        EffectiveSeasonalCropCycleExport cycle = (EffectiveSeasonalCropCycleExport) input;
                        rank = cycle.getRank();
                    }
                    return rank;
                }
            });

            result.put("phase", new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    if (input instanceof EffectivePerennialCropCycleDto) {
                        EffectivePerennialCropCycleDto cycle = (EffectivePerennialCropCycleDto) input;
                        // only one phase in effective
                        return cycle.getPhaseDtos().get(0).getType();
                    }
                    return null;
                }
            });

            result.put(EffectiveCropCyclePhaseDto.PROPERTY_DURATION, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    if (input instanceof EffectivePerennialCropCycleDto) {
                        EffectivePerennialCropCycleDto cycle = (EffectivePerennialCropCycleDto) input;
                        // only one phase in effective
                        return cycle.getPhaseDtos().get(0).getDuration();
                    }
                    return null;
                }
            });

            result.put(EffectivePerennialCropCycleDto.PROPERTY_ORIENTATION, new Function<K, Object>() {
                @Override
                public Object apply(K input) {
                    String orientation = null;
                    if (input instanceof EffectivePerennialCropCycleDto) {
                        EffectivePerennialCropCycleDto cycle = (EffectivePerennialCropCycleDto) input;
                        orientation = cycle.getOrientationLabel();
                    }
                    return orientation;
                }

            });

            return result;
        }
    }

    public static class EffectivePerennialCropCycleSpeciesBeanInfo extends EffectiveCropCycleCommonBeanInfo {
        @Override
        public String getBeanTitle() {
            return "Espèces des phases de production des cultures pérennes";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            // remind the crop from perennial cycle
            columns.put("croppingPlanEntryName", "Culture");
            columns.put("phase", "Phase");

            // species characteristics
            columns.put("speciesEspece", "Espèce");
            columns.put("speciesQualifiant", "Qualifiant");
            columns.put("speciesTypeSaisonnier", "Type saisonnier");
            columns.put("speciesDestination","Destination");
            columns.put("varietyLibelle", "Cépage / Variété");
            columns.put("graftSupport", "Porte-greffe");
            columns.put("graftClone", "Clone de la greffe");
            columns.put("plantsCertified", "Certification des plants");
            columns.put("overGraftDate", "Date de sur-greffage");
            return columns;
        }

//        protected CropCycleGraftDto graftClone;
        @Override
        public <K> Map<String, Function<K, Object>> getCustomFormatters() {
            Map<String, Function<K, Object>> result = super.getCustomFormatters();

            return result;
        }
    }

    public static class EffectiveITKBeanInfo extends EffectiveCropCycleCommonBeanInfo {

        @Override
        public String getBeanTitle() {
            return "Interventions";
        }

        @Override
        public BidiMap<String, String> getExtraColumns() {
            BidiMap<String, String> columns = new DualLinkedHashBidiMap<String, String>();
            // cycle summary
            columns.put("itk_cycle", "Cycle");
            columns.put("itk_crop", "Culture");
            // ITK
            columns.put("itk_rank", "Rang");
            columns.put("itk_phase", "Phase");
            columns.put(EffectiveIntervention.PROPERTY_NAME, "Nom");
            columns.put(EffectiveIntervention.PROPERTY_TYPE, "Type d'intervention");
            columns.put(EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE, "Date de début d'intervention");
            columns.put(EffectiveIntervention.PROPERTY_END_INTERVENTION_DATE, "Date de fin d'intervention ");
            columns.put(EffectiveIntervention.PROPERTY_TRANSIT_COUNT, "Nombre de passage");
            columns.put("PSCi", "PSCi");
            columns.put("toolsCouplings", "Combinaison d'outils");
            columns.put("spendingTime", "Temps passé");
            columns.put(EffectiveIntervention.PROPERTY_PROGRESSION_SPEED, "Vitesse d'avancement");
            columns.put(EffectiveIntervention.PROPERTY_INVOLVED_PEOPLE_COUNT, "Nombre de personnes intervenant");
            columns.put(EffectiveIntervention.PROPERTY_WORK_RATE, "Débit de chantier");
            columns.put(EffectiveIntervention.PROPERTY_SPATIAL_FREQUENCY, "Fréquence spatiale");
            columns.put(EffectiveIntervention.PROPERTY_INTERMEDIATE_CROP, "Affectation à la culture intermédiaire");

            // stades
            columns.put("species", "Espèce");
            columns.put("stadeMin", "Stade de culture minimum");
            columns.put("stadeMax", "Stade de culture maximum");

            // actions
            columns.put("actionType", "Type d'action");
            columns.put("action", "Action");
            columns.put("mainAction", "Action principale");

            // inputs
            columns.put("inputType", "Type d'intrant");
            columns.put("product", "Produit");
            columns.put("qtMin", "Quantité minimale");
            columns.put("qtAvg", "Quantité moyenne");
            columns.put("qtMed", "Quantité médiane");
            columns.put("qtMax", "Quantité maximale");
            columns.put("unit", "Unité de produit");

            columns.put(EffectiveInterventionDto.PROPERTY_COMMENT, "Commentaire");

            return columns;
        }
    }
}
