package fr.inra.agrosyst.services.effective.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EffectiveCropCycleExportEntity.java 3918 2014-03-31 10:04:27Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/effective/export/EffectiveCropCycleExportEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author David Cossé
 */
public class EffectiveCropCycleExportEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 4966674462002075326L;

    protected String zoneName;

    protected String plotName;

    protected String growingSystemName;

    protected String growingPlanName;

    protected String domainName;

    protected Integer campaign;

    protected String cycle;

    public String getCycle() {
        return cycle;
    }

    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    public String getZoneName() {
        return zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getPlotName() {
        return plotName;
    }

    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    public String getGrowingSystemName() {
        return growingSystemName;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    public String getGrowingPlanName() {
        return growingPlanName;
    }

    public void setGrowingPlanName(String growingPlanName) {
        this.growingPlanName = growingPlanName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EffectiveCropCycleExportEntity clone = (EffectiveCropCycleExportEntity) super.clone();
        return clone;
    }
}
