package fr.inra.agrosyst.services.effective;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: InterventionDtoToInterventionUnivers.java 5125 2015-11-04 15:46:47Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/effective/InterventionDtoToInterventionUnivers.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

public class InterventionDtoToInterventionUnivers {
    private final List<EffectiveInterventionDto> interventionDtos;
    private final List<EffectiveCropCycleConnectionDto> connectionDtos;
    private final Pair<String, EffectiveCropCycleNode> nodeIdToNode;
    private final EffectivePerennialCropCycle perennialCropCycle;
    private final EffectiveCropCyclePhase phase;
    private final Domain domain;
    private final Map<String, EffectiveIntervention> idsToInterventions;

    public InterventionDtoToInterventionUnivers(List<EffectiveInterventionDto> interventionDtos, List<EffectiveCropCycleConnectionDto> connectionDtos, Pair<String, EffectiveCropCycleNode> nodeIdToNode, EffectivePerennialCropCycle perennialCropCycle, EffectiveCropCyclePhase phase, Domain domain, Map<String, EffectiveIntervention> idsToInterventions) {
        this.interventionDtos = interventionDtos;
        this.connectionDtos = connectionDtos;
        this.nodeIdToNode = nodeIdToNode;
        this.perennialCropCycle = perennialCropCycle;
        this.phase = phase;
        this.domain = domain;
        this.idsToInterventions = idsToInterventions;
    }

    public List<EffectiveInterventionDto> getInterventionDtos() {
        return interventionDtos;
    }

    public List<EffectiveCropCycleConnectionDto> getConnectionDtos() {
        return connectionDtos;
    }

    public Pair<String, EffectiveCropCycleNode> getNodeIdToNode() {
        return nodeIdToNode;
    }

    public EffectivePerennialCropCycle getPerennialCropCycle() {
        return perennialCropCycle;
    }

    public EffectiveCropCyclePhase getPhase() {
        return phase;
    }

    public Domain getDomain() {
        return domain;
    }

    public Map<String, EffectiveIntervention> getIdsToInterventions() {
        return idsToInterventions;
    }
}
