package fr.inra.agrosyst.services.domain.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: DomainExportEntity.java 3870 2014-03-25 17:12:42Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/domain/export/DomainExportEntity.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.Map;

import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.services.common.export.AbstractEntityExportExtra;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class DomainExportEntity extends AbstractEntityExportExtra implements Serializable, Cloneable {

    private static final long serialVersionUID = 8510145353855036360L;

    protected DomainType domainType;

    protected String departement;

    protected String postalCode;

    protected String domainName;

    protected int campaign;

    protected String mainContact;

    protected Map<String, Object> extra;

    public DomainType getDomainType() {
        return domainType;
    }

    public void setDomainType(DomainType domainType) {
        this.domainType = domainType;
    }

    public String getDepartement() {
        return departement;
    }

    public void setDepartement(String departement) {
        this.departement = departement;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public int getCampaign() {
        return campaign;
    }

    public void setCampaign(int campaign) {
        this.campaign = campaign;
    }

    public String getMainContact() {
        return mainContact;
    }

    public void setMainContact(String mainContact) {
        this.mainContact = mainContact;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DomainExportEntity clone = (DomainExportEntity) super.clone();
        return clone;
    }
}
