package fr.inra.agrosyst.services.demo;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: DemoDatas.java 4927 2015-05-08 20:57:16Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/demo/DemoDatas.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.CroppingPlanSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentTopiaDao;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.GeoPointTopiaDao;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GroundTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemTopiaDao;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.NetworkManagerTopiaDao;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotTopiaDao;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingTopiaDao;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.ZoneTopiaDao;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.IrrigationAction;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesAction;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherAction;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageAction;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.history.Message;
import fr.inra.agrosyst.api.entities.history.MessageTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlotTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPCTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCulturesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActiveTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCategTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelleTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenneTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSolTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinageTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referential.RefFertiEngraisorgTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFATopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburantTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesEngraisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesPhytoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefGesSemenceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLienCulturesEdiActaTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesureTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburantTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjEngraisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutilTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhytoTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemenceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObsTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdCTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDITopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGevesTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrapeTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphyTopiaDao;
import fr.inra.agrosyst.api.entities.referential.ReferentialEntity;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoCaseGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoFuzzySetGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesoRulesGroundWaterTopiaDao;
import fr.inra.agrosyst.api.entities.referential.iphy.RefRcesuRunoffPotRulesParcTopiaDao;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.domain.DomainExtendException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceContext;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.network.Networks;
import fr.inra.agrosyst.services.plot.PlotServiceImpl;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.util.StringUtil;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class DemoDatas extends AbstractAgrosystService {

    private static final Log log = LogFactory.getLog(DemoDatas.class);

    protected static final int DEMO_DOMAINS_COUNT = 100;
    protected static final int DEMO_PRACTICED_SYSTEMS_COUNT = 100;

    protected static final List<Integer> CAMPAIGNS = Lists.newArrayList(2012, 2013);

    public static final List<CroppingEntryType> CROPPING_ENTRY_TYPES = Lists.newArrayList(CroppingEntryType.values());
    protected static final String LOREM_IPSUM_SOURCE =
            "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore " +
                    "magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut " +
                    "aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum " +
                    "dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa " +
                    "qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit " +
                    "in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero " +
                    "eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis " +
                    "dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed " +
                    "diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim " +
                    "ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea " +
                    "commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse " +
                    "molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et " +
                    "iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait " +
                    "nulla facilisi. Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming " +
                    "id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing " +
                    "elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut " +
                    "wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut " +
                    "aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate " +
                    "velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et " +
                    "accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus " +
                    "est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed " +
                    "diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. " +
                    "At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea " +
                    "takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur " +
                    "sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy " +
                    "sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus " +
                    "sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, " +
                    "consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna " +
                    "aliquyam erat. Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et " +
                    "dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et " +
                    "ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. " +
                    "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt " +
                    "ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo " +
                    "dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor " +
                    "sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod " +
                    "tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et " +
                    "accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus " +
                    "est Lorem ipsum dolor sit amet.";

    protected static final List<String> LOREM_IPSUM = Lists.newArrayList(Splitter.on(".").trimResults().omitEmptyStrings().split(LOREM_IPSUM_SOURCE));
    protected static final List<String> LOREM_IPSUM_WORDS = Lists.newArrayList(Splitter.onPattern("[,. ]").trimResults().omitEmptyStrings().split(LOREM_IPSUM_SOURCE));

    protected static final List<String> CONTACTS = Lists.newArrayList("Annie Verssaire", "Alain Stanté", "Debby Scott",
            "Jean Peuplu", "Gérard Manvussa", "Léo Placé", "Barbie Chaite", "Yvon Souf-Rire", "Tom Hatemozza",
            "Ella Malocoeur");

    protected static final List<String> DOMAIN_NAMES = Lists.newArrayList("La Bouinelière", "Le clos Gautier",
            "La porte Gellée", "Couëron les bains", "Baulon", "Avalon", "La boulogne", "Les Ridelières", "La Godefroy",
            "Kermoger", "Les brosses", "À l'orée des champs", "Domaine de la bergerie", "Domaine des ormes",
            "Domaine de verchant", "La martellière", "Croix bonneau", "Wattignies", "Pirmil", "Mangin",
            "Les prairies mauves", "Bouffay", "Lauriers", "Motte rouge", "Petit port", "Chêne des anglais", "Talensac",
            "Neustrie");

    protected static final Predicate<Network> SDC_COMPLIANT_NETWORKS = new Predicate<Network>() {
        @Override
        public boolean apply(Network input) {
            String name = input.getName();
            return name.startsWith("EXPE") || name.startsWith("IR");
        }
    };

    protected final List<RefEspece> especes = Lists.newArrayList();
    protected final List<RefVarieteGeves> varieteGeveses = Lists.newArrayList();
    protected final List<RefVarietePlantGrape> varietePlantGrapes = Lists.newArrayList();
    protected final List<RefSolArvalis> solArvalis = Lists.newArrayList();
    protected final List<RefMateriel> refMateriel = Lists.newArrayList();
    protected final List<RefFertiMinUNIFA> fertiMinUnifa = Lists.newArrayList();
    protected final Map<AgrosystInterventionType, List<RefInterventionAgrosystTravailEDI>> interventionsTravailEDI = Maps.newHashMap();
    protected final List<RefFertiEngraisorg> fertiEngraisorg = Lists.newArrayList();

    protected ImportService importService;
    protected DomainService domainService;
    protected EffectiveCropCycleService effectiveCropCycleService;
    protected PracticedSystemService practicedSystemService;
    protected NetworkService networkService;
    protected AuthenticationService authenticationService;

    // WARNING : Do not remove, this method is called using introspection. See : fr.inra.agrosyst.web.AgrosystWebApplicationListener.checkForDemoDatas()
    public static void onInit(AgrosystServiceConfig serviceConfig) {

        if (serviceConfig.isGenerateBuiltinReferentials()) {
            TopiaPersistenceContext transaction = null;
            try {
                Supplier<AgrosystTopiaPersistenceContext> transactionSupplier = getAgrosystTopiaPersistenceContextSupplier(serviceConfig);

                DefaultServiceContext serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();

                DemoDatas demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForDemoReferentials();

            } catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to create demo datas", eee);
                }
            } finally {
                if (transaction != null) {
                    try {
                        transaction.close();
                    } catch (TopiaException te) {
                        log.error("Unable to close transaction", te);
                    }
                }
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Skipping builtin referentials generation");
            }
        }

        if (serviceConfig.isGenerateBuiltinUsers()) {
            TopiaPersistenceContext transaction = null;
            try {
                Supplier<AgrosystTopiaPersistenceContext> transactionSupplier = getAgrosystTopiaPersistenceContextSupplier(serviceConfig);

                DefaultServiceContext serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();
                DemoDatas demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForBuiltinUsers();

            } catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to create builtin users", eee);
                }
            } finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Skipping demo data generation");
            }
        }

        if (serviceConfig.isDemoModeEnabled()) {
            TopiaPersistenceContext transaction = null;
            try {
                Supplier<AgrosystTopiaPersistenceContext> transactionSupplier = getAgrosystTopiaPersistenceContextSupplier(serviceConfig);

                DefaultServiceContext serviceContext = new DefaultServiceContext(serviceConfig, transactionSupplier);
                transaction = serviceContext.getPersistenceContext();
                DemoDatas demoDatas = serviceContext.newService(DemoDatas.class);
                demoDatas.checkForDemoDatas();

            } catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to create demo data", eee);
                }
            } finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info("Skipping demo data generation");
            }
        }
    }

    protected static Supplier<AgrosystTopiaPersistenceContext> getAgrosystTopiaPersistenceContextSupplier(AgrosystServiceConfig serviceConfig) {
        Properties rootProperties = AgrosystConfigurationHelper.getRootContextProperties(serviceConfig);
        final AgrosystTopiaApplicationContext applicationContext;

        try {
            applicationContext = TopiaApplicationContextCache.getContext(rootProperties, AgrosystConfigurationHelper.getCreateTopiaContextFunction(serviceConfig));
            applicationContext.applicationInit();
        } catch (TopiaNotFoundException tnfe) {
            throw new TopiaException("Unable to initialize TopiaContext", tnfe);
        }

        return new Supplier<AgrosystTopiaPersistenceContext>() {
                @Override
                public AgrosystTopiaPersistenceContext get() {
                    return applicationContext.newPersistenceContext();
                }
            };
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setEffectiveCropCycleService(EffectiveCropCycleService effectiveCropCycleService) {
        this.effectiveCropCycleService = effectiveCropCycleService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected Random random = new Random(43508234345L);

    // return 0 <= x < max
    protected int randomInt(int max) {
        return randomInt(0, max);
    }

    // return 0 < min <= x < max
    protected int randomInt(int min, int max) {
        int result = max == 0 ? 0 : random.nextInt(max - min) + min;
        return result;
    }

    // return 0 <= x < max (rounded to 2 digit)
    protected double randomDouble(double max) {
        return randomDouble(0, max, 2);
    }

    // return 0 < min <= x < max (rounded to 2 digit)
    protected double randomDouble(double min, double max) {
        return randomDouble(min, max, 2);
    }

    // return 0 < min <= x < max (rounded to round digit)
    protected double randomDouble(double min, double max, int round) {
        double result = max == 0 ? 0 :  Math.round((random.nextDouble() * (max - min) + min) * Math.pow(10, round)) / Math.pow(10, round);
        return result;
    }

    protected String randomName(List<String> list) {
        int index = randomInt(list.size());
        String result = list.get(index);
        result = result.substring(0, 1).toUpperCase() + result.substring(1);
        return result;
    }

    protected <T> T randomElem(List<T> list) {
        int index = randomInt(list.size());
        T result = list.get(index);
        return result;
    }

    protected <T> T randomEnum(T[] values) {
        int index = randomInt(values.length);
        T result = values[index];
        return result;
    }

    public void checkForDemoReferentials() {
        checkForDemoActaTraitementsProduits();
        checkForDemoActaTraitementsProduitsCateg();
        checkForDemoCommunes();
        checkForDemoDepartments();
        checkForDemoMateriels();
        checkForDemoSolsArvalis();
        checkForDemoStatutJuridique();
        checkForDemoEspeces();
        checkForDemoVarietesGeves();
        checkForDemoVarietesPlantGrape();
        checkForDemoClonesPlantGrape();
        checkForDemoEspecesToVarietes();
        checkForDemoOtex();
        checkForDemoOrientationEdi();
        checkForDemoInterventionAgrosysytTravailEdi();
        checkForDemoTypeTravailEdi();
        checkForDemoStadesEdi();
        checkForDemoParcelleZonageEdi();
        checkForDemoSolTextureGeppa();
        checkForDemoSolProfondeurIndigo();
        checkForDemoSolCaracteristiquesIndigo();
        checkForDemoUnitesEdi();
        checkForDemoFertiMinUNIFA();
        checkForDemoBioAgressors();
        checkForDemoRefFertiOrga();
        checkForDemoFertiEngraisOrg();
        checkForDemoStationMeteo();
        checkForDemoTypeAgriculture();
        checkForDemoIndicatorReferentials();
        checkForDemoMesureReferentials();
        checkForDemoSupportOrganeEdi();
        checkForDemoActaSubstanceActive();
        checkForDemoProtocoleVgObs();
        checkForDemoElementVoisinage();
        checkForDemoIphyReferentials();
        checkForDemoActaDosageSpc();
        checkForDemoActaGroupeCultures();
        checkForDemoLienCulturesEdiActa();
        checkForDemoSaActaIphy();
        checkForDemoTraitSdC();
        checkForDemoCouvSolAnnuelle();
        checkForDemoCultureEdiGroupeCouvSol();
        checkForDemoCouvSolPerenne();
        checkForDemoZoneClimatiqueIphy();
    }

    public void checkForBuiltinUsers() {

        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        if (userTopiaDao.count() == 0L) {
            createDemoUsers();
            promuteAdmins();
            promuteIsDataProcessors();
        }

        getTransaction().commit();

    }

    public void checkForDemoDatas() {
        checkForDemoReferentials();

        MessageTopiaDao messageTopiaDao = context.getPersistenceContext().getMessageDao();
        if (messageTopiaDao.count() == 0L) {
            createBrodcastInfoMessage();
        }

        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        if (userTopiaDao.count() == 0L) {
            createDemoUsers();
            promuteAdmins();
            promuteIsDataProcessors();
        }

        NetworkTopiaDao networkTopiaDao = context.getPersistenceContext().getNetworkDao();
        if (networkTopiaDao.count() == 0L) {
            createDemoNetworks();
            promuteNetworkResponsibles();
        }

        DomainTopiaDao domainTopiaDao = context.getPersistenceContext().getDomainDao();
        if (domainTopiaDao.count() == 0L) {
            createDemoDomains();
            createDemoInterventionCulturales();
            promuteDomainResponsibles();
            promuteGrowingPlanResponsibles();
            promuteGrowingSystemDataProcessors();

            promuteLutinsDomainResponsibles();
        }

        PracticedSystemTopiaDao practicedSystemTopiaDao = context.getPersistenceContext().getPracticedSystemDao();
        if (practicedSystemTopiaDao.count() == 0L) {
            createDemoPracticedSystems();
        }
    }

    /**
     * Create demos data for Plot
     */
    protected void createPlots(Domain domain) {
        GrowingPlanTopiaDao growingPlanTopiaDao = context.getPersistenceContext().getGrowingPlanDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = context.getPersistenceContext().getGrowingSystemDao();

        int count = random.nextInt(4);
        for (int i = 0; i < count; i++) {

            RefLocation location = domain.getLocation();
            List<GrowingPlan> growingPlans = growingPlanTopiaDao.forDomainEquals(domain).findAll();
            if (growingPlans != null && !growingPlans.isEmpty()) {
                GrowingPlan growingPlan = randomElem(growingPlans);
                GrowingSystem growingSystem = growingSystemTopiaDao.forGrowingPlanEquals(growingPlan).findAnyOrNull();
                if (growingSystem != null) {
                    String plotName = String.format("Parcelle %s %d", domain.getName(), i + 1);
                    boolean active = true;
                    if (!growingSystem.isActive()) {
                        active = false;
                    }

                    createPlots(domain, plotName, randomDouble(30, 100, 0), i, 47.21d, -1.49d, "",
                            growingSystem, location, randomEnum(MaxSlope.values()), randomEnum(BufferStrip.values()),
                            randomEnum(WaterFlowDistance.values()), active);
                }
            } else {
                createPlots(domain, String.format("Parcelle %s %d (libre)", domain.getName(), i), randomDouble(30, 100, 0),
                        15, -41.2, 0.6, null, null,
                        domain.getLocation(), randomEnum(MaxSlope.values()), randomEnum(BufferStrip.values()),
                        randomEnum(WaterFlowDistance.values()), true);
            }

        }

        context.getTransaction().commit();
    }

    protected void createBrodcastInfoMessage() {
        log.info("Création d'un message de test.");
        MessageTopiaDao messageTopiaDao = context.getPersistenceContext().getMessageDao();
        Message  message = messageTopiaDao.newInstance();
        message.setMessageDate(new Date());
        message.setTitle("Information concernant cette instance d'Agrosyst");
        message.setContent("<h1>Ce message est un message de test</h1>" +
                "" +
                "      <h2>Il ne faut pas en tenir compte</h2>" +
                "" +
                "      <p>Agrosyst est un système d’information dédié à la description et l’évaluation des systèmes de culture. Il a été développé par l’INRA, dans le cadre du plan ECOPHYTO financé par l’ONEMA, pour le compte du réseau DEPHY, en partenariat avec le ministère en charge de l’agriculture, la Cellule d’Animation Nationale du réseau DEPHY  et de nombreux acteurs (techniciens et ingénieurs des chambres d’agriculture ou des instituts techniques, experts) représentés au sein du Comité des Partenaires.</p>" +
                "" +
                "      <h3>Ceci est un message fictif !</h3>" +
                "      <p>Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore </p>" +
                "      <p>magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut </p>" +
                "      <p>aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum </p>" +
                "      <p>dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa </p>" +
                "      <p>qui officia deserunt mollit anim id est laborum. Duis autem vel eum iriure dolor in hendrerit </p>" +
                "      <p>in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero </p>" +
                "      <p>eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis </p>");
        messageTopiaDao.create(message);
        context.getTransaction().commit();
    }

    protected void createPlots(Domain domain, String name, Double area, Integer pacIlotNumber, Double latitude,
                               Double longitude, String comment, GrowingSystem growingSystem, RefLocation location,
                               MaxSlope maxSlope, BufferStrip bufferStrip, WaterFlowDistance waterFlowDistance, boolean active) {
        PlotTopiaDao plotTopiaDao = context.getPersistenceContext().getPlotDao();
        ZoneTopiaDao zoneTopiaDao = context.getPersistenceContext().getZoneDao();

        // plot
        Plot plot = plotTopiaDao.create(Plot.PROPERTY_DOMAIN, domain,
                Plot.PROPERTY_AREA, area,
                Plot.PROPERTY_COMMENT, comment,
                Plot.PROPERTY_GROWING_SYSTEM, growingSystem,
                Plot.PROPERTY_LATITUDE, latitude,
                Plot.PROPERTY_LOCATION, location,
                Plot.PROPERTY_LONGITUDE, longitude,
                Plot.PROPERTY_MAX_SLOPE, maxSlope,
                Plot.PROPERTY_BUFFER_STRIP, bufferStrip,
                Plot.PROPERTY_NAME, name,
                Plot.PROPERTY_PAC_ILOT_NUMBER, pacIlotNumber,
                Plot.PROPERTY_WATER_FLOW_DISTANCE, waterFlowDistance,
                Plot.PROPERTY_ACTIVE, active,
                Plot.PROPERTY_CODE, UUID.randomUUID().toString());

        // plot default zone
        zoneTopiaDao.create(Zone.PROPERTY_PLOT, plot,
                Zone.PROPERTY_NAME, PlotServiceImpl.PLOT_DEFAULT_ZONE_NAME,
                Zone.PROPERTY_AREA, area,
                Zone.PROPERTY_ACTIVE, active,
                Zone.PROPERTY_TYPE, ZoneType.PRINCIPALE,
                Zone.PROPERTY_CODE, UUID.randomUUID().toString());
    }

    protected void createDemoUser(AgrosystUserTopiaDao userTopiaDao, String firstName, String lastName, String email, String org, String phone) {
        String password = StringUtil.encodeSHA1("password");
        if (ADMIN_EMAILS.contains(email)) {
            password = StringUtil.encodeSHA1(";;password..");
        }
        userTopiaDao.create(
                AgrosystUser.PROPERTY_EMAIL, email,
                AgrosystUser.PROPERTY_PASSWORD, password,
                AgrosystUser.PROPERTY_FIRST_NAME, firstName,
                AgrosystUser.PROPERTY_LAST_NAME, lastName,
                AgrosystUser.PROPERTY_ORGANISATION, org,
                AgrosystUser.PROPERTY_PHONE_NUMBER, phone,
                AgrosystUser.PROPERTY_ACTIVE,
                org != null);
    }

    protected static final Set<String> ADMIN_EMAILS = ImmutableSet.of(
            "antoine.schellenberger@orleans.inra.fr",
            "estelle.ancelet@orleans.inra.fr",
            "stephane.cadoux@grignon.inra.fr",
            "nicolas.munier-jolain@dijon.inra.fr",
            "ophelie.jolys@dijon.inra.fr",

            "thimel@codelutin.com",
            "chatellier@codelutin.com",
            "kaufmann@codelutin.com",
            "cosse@codelutin.com",
            "couteau@codelutin.com",
            "maisonneuve@codelutin.com",
            "morin@codelutin.com",
            "martel@codelutin.com",
            "bavencoff@codelutin.com");

    protected void createDemoUsers() {

        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        if (log.isInfoEnabled()) {
            log.info("Création des utilisateurs...");
        }

        createDemoUser(userTopiaDao, "Admin", "Admin", "admin@inra.fr", null, null);

        createDemoUser(userTopiaDao, "Antoine", "Schellenberger", "antoine.schellenberger@orleans.inra.fr", "INRA Orléans", null);
        createDemoUser(userTopiaDao, "Estelle", "Ancelet", "estelle.ancelet@orleans.inra.fr", "INRA Orléans", null);
//        createDemoUser(userTopiaDao, "Stéphane", "Cadoux", "stephane.cadoux@grignon.inra.fr", "INRA Grignon", null);
        createDemoUser(userTopiaDao, "Ophélie", "Jolys", "ophelie.jolys@dijon.inra.fr", "INRA Dijon", null);
        createDemoUser(userTopiaDao, "Nicolas", "Munier-Jolain", "nicolas.munier-jolain@dijon.inra.fr", "INRA Dijon", null);

        createDemoUser(userTopiaDao, "Sophie", "Buleon", "sophie.buleon@ardeche.chambagri.fr", "CA Ardeche/Drome", null);
        createDemoUser(userTopiaDao, "David", "Lafond", "david.lafond@vignevin.com", "Institut français de la vigne et du vin, Angers", null);
        createDemoUser(userTopiaDao, "David", "Bouillé", "david.bouille@ille-et-vilaine.chambagri.fr", "CA Ille-et-Vilaine", null);

        createDemoUser(userTopiaDao, "Arnaud", "Thimel", "thimel@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Éric", "Chatellier", "chatellier@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Léo", "Kaufmann", "kaufmann@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "David", "Cossé", "cosse@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Jean", "Couteau", "couteau@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Kevin", "Morin", "morin@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Samuel", "Maisonneuve", "maisonneuve@codelutin.com", "Code Lutin", "02.40.50.29.28");

        createDemoUser(userTopiaDao, "Benjamin", "Poussin", "poussin@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Estelle", "Gendron", "gendron@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Sylvain", "Bavencoff", "bavencoff@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Julien", "Ruchaud", "ruchaud@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Yannick", "Martel", "martel@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Tony", "Chemit", "chemit@codelutin.com", "Code Lutin", "02.40.50.29.28");
        createDemoUser(userTopiaDao, "Brendan", "Le Ny", "leny@codelutin.com", "Code Lutin", "02.40.50.29.28");

        createDemoUser(userTopiaDao, "Démo", "User", "demo@inra.fr", "Démo", null);

        createDemoUser(userTopiaDao, "Resp.", "IT1", "rr@inra.fr", "Test", null);
        createDemoUser(userTopiaDao, "Resp.", "À l'orée des champs", "rd@inra.fr", "Test", null);
        createDemoUser(userTopiaDao, "Resp.", "BioPlan 0", "rgp@inra.fr", "Test", null);
        createDemoUser(userTopiaDao, "Expl. SdC", "Campagne", "egsc@inra.fr", "Test", null);
        createDemoUser(userTopiaDao, "Expl. SdC", "Tout", "egsi@inra.fr", "Test", null);
        createDemoUser(userTopiaDao, "Expl.", "SI", "esi@inra.fr", "Test", null);

        if (log.isInfoEnabled()) {
            log.info(String.format("%d utilisateurs créés.", userTopiaDao.count()));
        }

        getTransaction().commit();
    }

    protected void promuteAdmins() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        List<AgrosystUser> users = userTopiaDao.findAll();
        Iterable<AgrosystUser> admins = Iterables.filter(users, new Predicate<AgrosystUser>() {
            @Override
            public boolean apply(AgrosystUser user) {
                String email = user.getEmail();
                boolean result = user.isActive() && ADMIN_EMAILS.contains(email);
                return result;
            }
        });

        long countBefore = userRoleTopiaDao.count();

        for (AgrosystUser admin : admins) {
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, admin,
                    UserRole.PROPERTY_TYPE, RoleType.ADMIN);
        }

        if (log.isInfoEnabled()) {
            log.info(String.format("%d utilisateurs promus Admins.", (userRoleTopiaDao.count() - countBefore)));
        }

        getTransaction().commit();
    }

    protected void promuteIsDataProcessors() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        Optional<AgrosystUser> any = userTopiaDao.forEmailEquals("esi@inra.fr").tryFindAny();

        if (any.isPresent()) {
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, any.get(),
                    UserRole.PROPERTY_TYPE, RoleType.IS_DATA_PROCESSOR);
            if (log.isInfoEnabled()) {
                log.info(String.format("Utilisateur '%s' promu Exploitant SI.", any.get().getEmail()));
            }
        }

        getTransaction().commit();
    }

    protected void promuteDomainResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        DomainTopiaDao domainTopiaDao = context.getPersistenceContext().getDomainDao();
        AgrosystUser user = userTopiaDao.forEmailEquals("rd@inra.fr").findAny();
        if (user.getEmail().equals("rd@inra.fr")) {
            Domain domain = domainTopiaDao.forNameEquals("À l'orée des champs").findAny();
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, user,
                    UserRole.PROPERTY_TYPE, RoleType.DOMAIN_RESPONSIBLE,
                    UserRole.PROPERTY_DOMAIN_CODE, domain.getCode());

            if (log.isInfoEnabled()) {
                log.info(String.format("Utilisateur '%s' promu responsable du domaine '%s' ", user.getEmail(), domain.getName()));
            }
        }
    }

    protected void promuteLutinsDomainResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        DomainTopiaDao domainTopiaDao = context.getPersistenceContext().getDomainDao();
        String[] emails = {"poussin@codelutin.com", "gendron@codelutin.com", "bavencoff@codelutin.com",
                "ruchaud@codelutin.com", "martel@codelutin.com", "chemit@codelutin.com", "leny@codelutin.com"};

        for (String email : emails) {
            AgrosystUser user = userTopiaDao.forEmailEquals(email).findAny();
            Domain domain = null;
            while (domain == null) {
                String domainName = randomElem(DOMAIN_NAMES);
                domain = domainTopiaDao.forNameEquals(domainName).findAnyOrNull();
            }
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, user,
                    UserRole.PROPERTY_TYPE, RoleType.DOMAIN_RESPONSIBLE,
                    UserRole.PROPERTY_DOMAIN_CODE, domain.getCode());

            if (log.isInfoEnabled()) {
                log.info(String.format("Utilisateur '%s' promu responsable du domaine '%s' ", user.getEmail(), domain.getName()));
            }
        }
    }

    protected void promuteGrowingPlanResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        GrowingPlanTopiaDao growingPlanTopiaDao = context.getPersistenceContext().getGrowingPlanDao();

        AgrosystUser user = userTopiaDao.forEmailEquals("rgp@inra.fr").findAny();
        GrowingPlan gp = growingPlanTopiaDao.findAllLazy().iterator().next();

        userRoleTopiaDao.create(
                UserRole.PROPERTY_AGROSYST_USER, user,
                UserRole.PROPERTY_TYPE, RoleType.GROWING_PLAN_RESPONSIBLE,
                UserRole.PROPERTY_GROWING_PLAN_CODE, gp.getCode());

        if (log.isInfoEnabled()) {
            log.info(String.format("Utilisateur '%s' promu responsable du dispositif '%s' ", user.getEmail(), gp.getName()));
        }
    }

    protected void promuteNetworkResponsibles() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        NetworkTopiaDao networkTopiaDao = context.getPersistenceContext().getNetworkDao();
        AgrosystUser user = userTopiaDao.forEmailEquals("rr@inra.fr").findAny();
        Network network = networkTopiaDao.forNameEquals("IT1").findAny();
        userRoleTopiaDao.create(
                UserRole.PROPERTY_AGROSYST_USER, user,
                UserRole.PROPERTY_TYPE, RoleType.NETWORK_RESPONSIBLE,
                UserRole.PROPERTY_NETWORK_ID, network.getTopiaId());

        if (log.isInfoEnabled()) {
            log.info(String.format("Utilisateur '%s' promu responsable du réseau  '%s'", user.getEmail(), network.getName()));
        }
    }

    protected void promuteGrowingSystemDataProcessors() {
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();
        UserRoleTopiaDao userRoleTopiaDao = context.getPersistenceContext().getUserRoleDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = context.getPersistenceContext().getGrowingSystemDao();

        // Pick up a random SDC
        GrowingSystem gs = growingSystemTopiaDao.findAllLazy().iterator().next();

        // Associate it with user over all campaigns
        {
            AgrosystUser user = userTopiaDao.forEmailEquals("egsi@inra.fr").findAny();
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, user,
                    UserRole.PROPERTY_TYPE, RoleType.GS_DATA_PROCESSOR,
                    UserRole.PROPERTY_GROWING_SYSTEM_CODE, gs.getCode());
            if (log.isInfoEnabled()) {
                log.info(String.format("Utilisateur '%s' promu exploitant SdC du SdC '%s'", user.getEmail(), gs.getName()));
            }
        }

        // Associate it with user on a specific campaign
        {
            AgrosystUser user = userTopiaDao.forEmailEquals("egsc@inra.fr").findAny();
            userRoleTopiaDao.create(
                    UserRole.PROPERTY_AGROSYST_USER, user,
                    UserRole.PROPERTY_TYPE, RoleType.GS_DATA_PROCESSOR,
                    UserRole.PROPERTY_GROWING_SYSTEM_ID, gs.getTopiaId());
            if (log.isInfoEnabled()) {
                log.info(String.format("Utilisateur '%s' promu exploitant SdC du SdC '%s' pour la campagne %d", user.getEmail(), gs.getName(), gs.getGrowingPlan().getDomain().getCampaign()));
            }
        }
    }

    public void createDemoDomains() {
        if (log.isInfoEnabled()) {
            log.info("Génération des domaines...");
        }

        DomainTopiaDao domainTopiaDao = context.getPersistenceContext().getDomainDao();

        RefLocationTopiaDao refLocationTopiaDao = context.getPersistenceContext().getRefLocationDao();
        List<RefLocation> locations = refLocationTopiaDao.findAll();

        RefLegalStatusTopiaDao refLegalStatusTopiaDao = context.getPersistenceContext().getRefLegalStatusDao();
        RefLegalStatus refLegalStatus = refLegalStatusTopiaDao.forCode_INSEEEquals(16).findUnique();

        // string, int > domain
        MultiKeyMap<Object, Domain> nameAndCampaignMap = new MultiKeyMap<Object, Domain>();

        for (int i = 0; i < DEMO_DOMAINS_COUNT; i++) {

            String name = randomElem(DOMAIN_NAMES);

            if (log.isInfoEnabled()) {
                log.info(String.format("Création du domaine '%s' (%d/%d)", name, i + 1, DEMO_DOMAINS_COUNT));
            }

            int initialCampaign = randomElem(CAMPAIGNS);

            Domain existingDomain = nameAndCampaignMap.get(name, initialCampaign);

            int campaign = initialCampaign;
            if (existingDomain == null) {
                Domain domain = domainTopiaDao.create(
                        Domain.PROPERTY_NAME, name,
                        Domain.PROPERTY_CAMPAIGN, initialCampaign,
                        Domain.PROPERTY_MAIN_CONTACT, randomElem(CONTACTS),
                        Domain.PROPERTY_ACTIVE, true,
                        Domain.PROPERTY_TYPE, randomEnum(DomainType.values()),
                        Domain.PROPERTY_DESCRIPTION, randomElem(LOREM_IPSUM),
                        Domain.PROPERTY_LOCATION, randomElem(locations),
                        Domain.PROPERTY_LEGAL_STATUS, refLegalStatus,
                        Domain.PROPERTY_CROPPING_PLAN_COMMENT, randomElem(LOREM_IPSUM),
                        Domain.PROPERTY_OTHER_ACTIVITIES_COMMENT, randomElem(LOREM_IPSUM),
                        Domain.PROPERTY_CODE, UUID.randomUUID().toString(),
                        //
                        Domain.PROPERTY_USED_AGRICULTURAL_AREA, randomDouble(10, 50, 0),
                        Domain.PROPERTY_OTHER_WORK_FORCE, randomDouble(0, 3, 0),
                        Domain.PROPERTY_TEMPORARY_EMPLOYEES_WORK_FORCE, randomDouble(0, 3, 0),
                        Domain.PROPERTY_PERMANENT_EMPLOYEES_WORK_FORCE, randomDouble(0, 3, 0),
                        Domain.PROPERTY_UPDATE_DATE, context.getCurrentDate(),
                        Domain.PROPERTY_VALIDATION_DATE, context.getCurrentDate(),
                        Domain.PROPERTY_VALIDATED, true);

                createGpsDatas(domain);

                createGrowingPlans(domain);
                createCroppingPlan(domain);
                createSolsArvalis(domain);
                createMaterielAndTooling(domain);
                createPlots(domain);

                // add name/campaign in cache
                nameAndCampaignMap.put(name, initialCampaign, domain);

                if (log.isInfoEnabled()) {
                    log.info(String.format("Nouveau domaine '%s' pour la campagne %d", name, campaign));
                }

            } else {
                do {
                    existingDomain = (Domain) nameAndCampaignMap.get(name, campaign);
                    campaign++;
                } while (nameAndCampaignMap.get(name, campaign) != null);

                if (log.isInfoEnabled()) {
                    log.info(String.format("Prolongation du domaine '%s' sur la campagne %d", name, campaign));
                }
                try {
                    Domain domain = domainService.extendDomain(existingDomain.getTopiaId(), campaign);
                    nameAndCampaignMap.put(name, campaign, domain);

                } catch (DomainExtendException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Un exception occured", e);
                    }
                }
            }

        }

        context.getTransaction().commit();

        if (log.isInfoEnabled()) {
            log.info(domainTopiaDao.count() + " domaines créés");
        }
    }

    protected List<GeoPoint> createGpsDatas(Domain domain) {
        GeoPointTopiaDao gpsDatasTopiaDao = context.getPersistenceContext().getGeoPointDao();
        GeoPoint gpsData2 = gpsDatasTopiaDao.create(
                GeoPoint.PROPERTY_DESCRIPTION, randomElem(LOREM_IPSUM),
                GeoPoint.PROPERTY_LONGITUDE, -0.04972,
                GeoPoint.PROPERTY_LATITUDE, 48.49163,
                GeoPoint.PROPERTY_NAME, randomName(LOREM_IPSUM_WORDS),
                GeoPoint.PROPERTY_DOMAIN, domain);
        List<GeoPoint> gpsDatas = Lists.newArrayList(gpsData2);
        return gpsDatas;
    }

    protected void createCroppingPlan(Domain domain) {
        CroppingPlanEntryTopiaDao croppingPlanEntryTopiaDao = context.getPersistenceContext().getCroppingPlanEntryDao();
        CroppingPlanSpeciesTopiaDao croppingPlanSpeciesTopiaDao = context.getPersistenceContext().getCroppingPlanSpeciesDao();

        for (int j = 0; j < 6; j++) {

            RefEspece refEspece = randomEspece();
            CroppingPlanEntry entry = croppingPlanEntryTopiaDao.create(CroppingPlanEntry.PROPERTY_DOMAIN, domain,
                    CroppingPlanEntry.PROPERTY_NAME, refEspece.getLibelle_espece_botanique(),
                    CroppingPlanEntry.PROPERTY_SELLING_PRICE, randomDouble(10, 90, 2),
                    CroppingPlanEntry.PROPERTY_TYPE, randomElem(CROPPING_ENTRY_TYPES),
                    CroppingPlanEntry.PROPERTY_CODE, UUID.randomUUID().toString());

            for (int i = 0; i < 3; i++) {
                RefVariete refVariete = null;

                // cohérence des données de demo, les varietes plantGrape ne concerne que le vigne "ZMO"
                if ("ZMO".equals(refEspece.getCode_espece_botanique())) {
                    if (i > 0) {
                        refVariete = randomVarietePlantGrape();
                    }
                } else if (i > 0) {
                    // TODO echatellier 20131007 ne permettre la sélection de variété geves
                    // qui concerne seulement l'espece en courante
                    refVariete = randomVarieteGeves();
                }

                CroppingPlanSpecies species = croppingPlanSpeciesTopiaDao.create(
                        CroppingPlanSpecies.PROPERTY_CROPPING_PLAN_ENTRY, entry,
                        CroppingPlanSpecies.PROPERTY_SPECIES, refEspece,
                        CroppingPlanSpecies.PROPERTY_VARIETY, refVariete,
                        CroppingPlanSpecies.PROPERTY_CODE, UUID.randomUUID().toString());
                entry.addCroppingPlanSpecies(species);
            }
        }

    }

    protected RefSolArvalis randomRefSolArvalis() {
        if (solArvalis.isEmpty()) {
            RefSolArvalisTopiaDao solArvalisTopiaDao = context.getPersistenceContext().getRefSolArvalisDao();
            List<String> ids = solArvalisTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                solArvalis.add(solArvalisTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(solArvalis);
    }

    protected void createSolsArvalis(Domain domain) {
        GroundTopiaDao solTopiaDao = context.getPersistenceContext().getGroundDao();
        for (int i = 0; i < 3; i++) {
            RefSolArvalis refSolArvalis = randomRefSolArvalis();
            solTopiaDao.create(Ground.PROPERTY_NAME, refSolArvalis.getSol_nom(),
                    Ground.PROPERTY_REF_SOL_ARVALIS, refSolArvalis,
                    Ground.PROPERTY_IMPORTANCE, randomDouble(100),
                    Ground.PROPERTY_COMMENT, randomElem(LOREM_IPSUM),
                    Ground.PROPERTY_DOMAIN, domain);
        }
    }

    protected RefMateriel randomRefMateriel() {
        if (refMateriel.isEmpty()) {
            RefMaterielTopiaDao refMaterielTopiaDao = context.getPersistenceContext().getRefMaterielDao();
            List<String> ids = refMaterielTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                refMateriel.add(refMaterielTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(refMateriel);
    }

    protected void createMaterielAndTooling(Domain domain) {
        // create some materiel
        EquipmentTopiaDao equipmentTopiaDao = context.getPersistenceContext().getEquipmentDao();
        Equipment materielTracteur = null;
        Equipment materielOutils = null;
        Equipment materielAutomoteur = null;
        Equipment materielIrrigation = null;
        for (int i = 0; i < 10; i++) {

            RefMateriel refMateriel = null;
            String name;
            if (i == 5) {
                name = "Autre " + i;
            } else {
                refMateriel = randomRefMateriel();
                name = refMateriel.getTypeMateriel1() + " " + i;
            }

            Equipment materiel = equipmentTopiaDao.create(Equipment.PROPERTY_REF_MATERIEL, refMateriel,
                    Equipment.PROPERTY_NAME, name,
                    Equipment.PROPERTY_MATERIEL_ETA, (i % 2 == 0),
                    Equipment.PROPERTY_DESCRIPTION, randomElem(LOREM_IPSUM),
                    Equipment.PROPERTY_CODE, UUID.randomUUID().toString(),
                    Equipment.PROPERTY_DOMAIN, domain);

            if (refMateriel != null) {
                Class klass = refMateriel.getClass();
                if (RefMaterielAutomoteur.class.isAssignableFrom(klass)) {
                    materielAutomoteur = materiel;
                } else if (RefMaterielTraction.class.isAssignableFrom(klass)) {
                    materielTracteur = materiel;
                } else if (RefMaterielOutil.class.isAssignableFrom(klass)) {
                    materielOutils = materiel;
                } else if (RefMaterielIrrigation.class.isAssignableFrom(klass)) {
                    materielIrrigation = materiel;
                }
            }
        }

        // create attelage if possible
        ToolsCouplingTopiaDao toolsCouplingTopiaDao = context.getPersistenceContext().getToolsCouplingDao();

        if (materielAutomoteur != null) {
            List<RefInterventionAgrosystTravailEDI> mainsActions = Lists.newArrayList(
                    randomActionTravailEDI(AgrosystInterventionType.TRAVAIL_DU_SOL),
                    randomActionTravailEDI(AgrosystInterventionType.IRRIGATION),
                    randomActionTravailEDI(AgrosystInterventionType.RECOLTE));
            toolsCouplingTopiaDao.create(
                    ToolsCoupling.PROPERTY_TRACTOR, materielAutomoteur,
                    ToolsCoupling.PROPERTY_MAINS_ACTIONS, mainsActions,
                    ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME, "Intervention Automoteur",
                    ToolsCoupling.PROPERTY_CODE, UUID.randomUUID().toString(),
                    ToolsCoupling.PROPERTY_DOMAIN, domain);
        }

        if (materielTracteur != null && (materielOutils != null || materielIrrigation != null)) {
            List<RefInterventionAgrosystTravailEDI> mainsActions = Lists.newArrayList(
                    randomActionTravailEDI(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER),
                    randomActionTravailEDI(AgrosystInterventionType.LUTTE_BIOLOGIQUE),
                    randomActionTravailEDI(AgrosystInterventionType.RECOLTE));
            ToolsCoupling coupling = toolsCouplingTopiaDao.create(
                    ToolsCoupling.PROPERTY_TRACTOR, materielTracteur,
                    ToolsCoupling.PROPERTY_MAINS_ACTIONS, mainsActions,
                    ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME, "Intervention Tracteur",
                    ToolsCoupling.PROPERTY_CODE, UUID.randomUUID().toString(),
                    ToolsCoupling.PROPERTY_DOMAIN, domain);
            if (materielOutils != null) {
                coupling.addEquipments(materielOutils);
            }
            if (materielIrrigation != null) {
                coupling.addEquipments(materielIrrigation);
            }
        }
    }

    protected RefVarietePlantGrape randomVarietePlantGrape() {
        if (varietePlantGrapes.isEmpty()) {
            RefVarietePlantGrapeTopiaDao refVarietePlantGrapeTopiaDao = context.getPersistenceContext().getRefVarietePlantGrapeDao();
            List<String> ids = refVarietePlantGrapeTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                varietePlantGrapes.add(refVarietePlantGrapeTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(varietePlantGrapes);
    }

    protected RefVarieteGeves randomVarieteGeves() {
        if (varieteGeveses.isEmpty()) {
            RefVarieteGevesTopiaDao refVarieteGevesTopiaDao = context.getPersistenceContext().getRefVarieteGevesDao();
            List<String> ids = refVarieteGevesTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                varieteGeveses.add(refVarieteGevesTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(varieteGeveses);
    }

    protected RefEspece randomEspece() {
        if (especes.isEmpty()) {
            RefEspeceTopiaDao refEspeceTopiaDao = context.getPersistenceContext().getRefEspeceDao();
            List<String> ids = refEspeceTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                especes.add(refEspeceTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(especes);
    }

    protected List<GrowingPlan> createGrowingPlans(Domain domain) {

        // 1 ou 2
        int count = random.nextInt(2) + 1;
        GrowingPlanTopiaDao dispositifTopiaDao = context.getPersistenceContext().getGrowingPlanDao();

        List<GrowingPlan> result = Lists.newArrayList();
        for (int i = 0; i <= count; i++) {
            String name = randomName(LOREM_IPSUM_WORDS) + " " + dispositifTopiaDao.count();

            if (log.isInfoEnabled()) {
                log.info(String.format("[%s/%d] Génération du dispositif : %s", domain.getName(), domain.getCampaign(), name));
            }

            GrowingPlan growingPlan = dispositifTopiaDao.create(
                    GrowingPlan.PROPERTY_NAME, name,
                    GrowingPlan.PROPERTY_TYPE, randomEnum(TypeDEPHY.values()),
                    GrowingPlan.PROPERTY_DOMAIN, domain,
                    GrowingPlan.PROPERTY_ACTIVE, true,
                    GrowingPlan.PROPERTY_CODE, UUID.randomUUID().toString(),
                    GrowingPlan.PROPERTY_UPDATE_DATE, context.getCurrentDate(),
                    GrowingPlan.PROPERTY_VALIDATION_DATE, context.getCurrentDate(),
                    GrowingPlan.PROPERTY_VALIDATED, true);

            createGrowingSystems(domain, growingPlan);
        }

        context.getTransaction().commit();
        return result;
    }

    protected void createDemoNetworks() {

        NetworkTopiaDao networkTopiaDao = context.getPersistenceContext().getNetworkDao();
        NetworkManagerTopiaDao networkManagerTopiaDao = context.getPersistenceContext().getNetworkManagerDao();
        AgrosystUserTopiaDao userTopiaDao = context.getPersistenceContext().getAgrosystUserDao();

        UserDto userDto = authenticationService.login("thimel@codelutin.com", ";;password..");
        if (userDto != null) {
            String authenticationToken = userDto.getAuthenticationToken();
            if (!Strings.isNullOrEmpty(authenticationToken)) {
                ((DefaultServiceContext)context).setAuthenticationToken(authenticationToken);
                if (log.isInfoEnabled()) {
                    log.info("Login success, will generate DemoData as " + userDto.getEmail());
                }
            }
        }

        if (log.isInfoEnabled()) {
            log.info("Génération des réseaux...");
        }

        List<AgrosystUser> users = userTopiaDao.findAll();

        Map<String, Network> networks = Maps.newHashMap();

        NetworkManager nCanManager = networkManagerTopiaDao.newInstance();
        nCanManager.setAgrosystUser(randomElem(users));
        nCanManager.setActive(true);
        if (log.isInfoEnabled()) {
            log.info("Génération du réseau : CAN");
        }
        Network nCan = networkTopiaDao.newInstance();
        nCan.setName("CAN");
        nCan.setActive(true);
        nCan = networkService.createOrUpdateNetwork(nCan, Lists.newArrayList(Networks.TO_MANAGER_DTO.apply(nCanManager)), null);
        networks.put(nCan.getName(), nCan);

        for (int i = 0; i < 3; i++) {

            NetworkManager nMExpe = networkManagerTopiaDao.newInstance();
            nMExpe.setAgrosystUser(randomElem(users));
            nMExpe.setActive(true);
            String name = "EXPE" + i;
            if (log.isInfoEnabled()) {
                log.info("Génération du réseau : " + name);
            }
            Network nExpe = networkTopiaDao.newInstance();
            nExpe.setName(name);
            nExpe.setActive(true);
            nExpe = networkService.createOrUpdateNetwork(nExpe, Lists.newArrayList(Networks.TO_MANAGER_DTO.apply(nMExpe)), Lists.newArrayList(nCan.getTopiaId()));
            networks.put(nExpe.getName(), nExpe);

            NetworkManager nMIt = networkManagerTopiaDao.newInstance();
            nMIt.setAgrosystUser(randomElem(users));
            nMIt.setActive(true);
            name = "IT" + i;
            if (log.isInfoEnabled()) {
                log.info("Génération du réseau : " + name);
            }
            Network nIt = networkTopiaDao.newInstance();
            nIt.setName("IT" + i);
            nIt.setActive(true);
            nIt = networkService.createOrUpdateNetwork(nIt, Lists.newArrayList(Networks.TO_MANAGER_DTO.apply(nMIt)), Lists.newArrayList(nCan.getTopiaId()));
            networks.put(nIt.getName(), nIt);

        }

        for (int i = 0; i < 3; i++) {
            NetworkManager nMIr = networkManagerTopiaDao.newInstance();
            nMIr.setAgrosystUser(randomElem(users));
            nMIr.setActive(true);
            String name = "IR" + i;
            if (log.isInfoEnabled()) {
                log.info("Génération du réseau : " + name);
            }
            Network nIr = networkTopiaDao.newInstance();
            nIr.setName(name);
            nIr.setActive(true);
            nIr = networkService.createOrUpdateNetwork(nIr, Lists.newArrayList(Networks.TO_MANAGER_DTO.apply(nMIr)), Lists.newArrayList(networks.get("IT1").getTopiaId()));
            networks.put(nIr.getName(), nIr);

        }

        if (log.isInfoEnabled()) {
            log.info(String.format("%d réseaux créés.", networkTopiaDao.count()));
        }

        context.getTransaction().commit();
    }

    protected void createGrowingSystems(Domain domain, GrowingPlan growingPlan) {

        // 1 ou 2
        int count = random.nextInt(2) + 1;
        NetworkTopiaDao networkTopiaDao = context.getPersistenceContext().getNetworkDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = context.getPersistenceContext().getGrowingSystemDao();

        List<Network> allNetworks = networkTopiaDao.findAll();
        List<Network> networks = Lists.newArrayList(Iterables.filter(allNetworks, SDC_COMPLIANT_NETWORKS));

        for (int i = 0; i < count; i++) {
            String dephyNumber = String.format( // Du genre "Y784K015"
                    "Y%sK%s", Strings.padStart("" + random.nextInt(1000), 3, '0'), Strings.padStart("" + i, 3, '0'));

            String name = randomName(LOREM_IPSUM_WORDS) + " " + growingSystemTopiaDao.count();

            if (log.isInfoEnabled()) {
                log.info(String.format("[%s/%d - %s] Génération du système de culture : %s", domain.getName(), domain.getCampaign(), growingPlan.getName(), name));
            }

            growingSystemTopiaDao.create(GrowingSystem.PROPERTY_NAME, name,
                    GrowingSystem.PROPERTY_DEPHY_NUMBER, dephyNumber,
                    GrowingSystem.PROPERTY_NETWORKS, Arrays.asList(randomElem(networks)),
                    GrowingSystem.PROPERTY_GROWING_PLAN, growingPlan,
                    GrowingSystem.PROPERTY_SECTOR, randomEnum(Sector.values()),
                    GrowingSystem.PROPERTY_ACTIVE, true,
                    GrowingSystem.PROPERTY_STARTING_DATE, new Date(),
                    GrowingSystem.PROPERTY_CODE, UUID.randomUUID().toString(),
                    GrowingSystem.PROPERTY_AFFECTED_AREA_RATE, randomDouble(70, 100, 0),
                    GrowingSystem.PROPERTY_UPDATE_DATE, context.getCurrentDate());

        }
        context.getTransaction().commit();
    }

    protected void createDemoPracticedSystems() {
        if (log.isInfoEnabled()) {
            log.info("Génération de " + DEMO_PRACTICED_SYSTEMS_COUNT + " systèmes synthétisés...");
        }

        PracticedSystemTopiaDao practicedSystemTopiaDao = context.getPersistenceContext().getPracticedSystemDao();
        GrowingSystemTopiaDao growingSystemTopiaDao = context.getPersistenceContext().getGrowingSystemDao();
        PracticedPlotTopiaDao practicedPlotTopiaDao = context.getPersistenceContext().getPracticedPlotDao();
        List<GrowingSystem> growingSystems = growingSystemTopiaDao.findAll();
        for (int i = 0; i < DEMO_PRACTICED_SYSTEMS_COUNT; i++) {

            String campaigns;
            if (i % 3 == 0) {
                campaigns = "2012,2013";
            } else if (i % 3 == 1) {
                campaigns = "2012,2013,2014";
            } else {
                campaigns = "2013,2014,2015";
            }

            PracticedSystem practicedSystem = practicedSystemTopiaDao.create(
                    PracticedSystem.PROPERTY_NAME, "Système synthétisé " + i,
                    PracticedSystem.PROPERTY_GROWING_SYSTEM, randomElem(growingSystems),
                    PracticedSystem.PROPERTY_SOURCE, randomEnum(PracticedSystemSource.values()),
                    PracticedSystem.PROPERTY_CAMPAIGNS, CommonService.ARRANGE_CAMPAIGNS.apply(campaigns),
                    PracticedSystem.PROPERTY_UPDATE_DATE, context.getCurrentDate(),
                    PracticedSystem.PROPERTY_ACTIVE, true);
            createDemoPracticedCropCycles(practicedSystem);

            // Create practiced plot
            if (random.nextBoolean()) {
                practicedPlotTopiaDao.create(
                        PracticedPlot.PROPERTY_PRACTICED_SYSTEM, practicedSystem,
                        PracticedPlot.PROPERTY_NAME, "Parcelle type " + i,
                        PracticedPlot.PROPERTY_AREA, 42.0,
                        PracticedPlot.PROPERTY_MAX_SLOPE, randomEnum(MaxSlope.values()),
                        PracticedPlot.PROPERTY_BUFFER_STRIP, randomEnum(BufferStrip.values()),
                        PracticedPlot.PROPERTY_WATER_FLOW_DISTANCE, randomEnum(WaterFlowDistance.values()));
            }
        }
        context.getTransaction().commit();

        if (log.isInfoEnabled()) {
            log.info(String.format("%d systèmes synthétisés créés.", practicedSystemTopiaDao.count()));
        }

    }

    protected void createDemoPracticedCropCycles(PracticedSystem practicedSystem) {

        if (log.isInfoEnabled()) {
            log.info("Création de données de démo pour le système synthétisé '" + practicedSystem.getName() + "'");
        }

        PracticedSeasonalCropCycleTopiaDao practicedSeasonalCropCycleTopiaDao = context.getPersistenceContext().getPracticedSeasonalCropCycleDao();
        PracticedPerennialCropCycleTopiaDao practicedPerennialCropCycleTopiaDao = context.getPersistenceContext().getPracticedPerennialCropCycleDao();
        PracticedCropCyclePhaseTopiaDao cropCyclePhaseTopiaDao = context.getPersistenceContext().getPracticedCropCyclePhaseDao();
        PracticedCropCycleNodeTopiaDao cropCycleNodeTopiaDao = context.getPersistenceContext().getPracticedCropCycleNodeDao();
        PracticedCropCycleConnectionTopiaDao cropCycleConnectionTopiaDao = context.getPersistenceContext().getPracticedCropCycleConnectionDao();

        List<Integer> phaseDurations = Lists.newArrayList(5, 7, 3, 10, 15, 30);

        // get cropping plan for practiced system's domain
        GrowingSystem growingSystem = practicedSystem.getGrowingSystem();
        List<CroppingPlanEntryDto> croppingPlans = domainService.getCroppingPlanDtos(growingSystem.getGrowingPlan().getDomain().getTopiaId());
        List<CroppingPlanEntryDto> mainCroppingPlans = Lists.newArrayList(Iterables.filter(croppingPlans, Predicates.not(CroppingPlans.IS_ENTRY_INTERMEDIATE)));
        List<CroppingPlanEntryDto> inteCroppingPlans = Lists.newArrayList(Iterables.filter(croppingPlans, CroppingPlans.IS_ENTRY_INTERMEDIATE));

        if (!mainCroppingPlans.isEmpty()) {

            // create perennial cycle
            PracticedCropCyclePhase cropCyclePhaseTmp = cropCyclePhaseTopiaDao.newInstance();
            cropCyclePhaseTmp.setDuration(randomElem(phaseDurations));
            cropCyclePhaseTmp.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
            PracticedCropCyclePhase cropCyclePhase = cropCyclePhaseTopiaDao.create(cropCyclePhaseTmp);
            List<PracticedCropCyclePhase> cropCyclePhases = Lists.newArrayList(cropCyclePhase);
            practicedPerennialCropCycleTopiaDao.create(
                    PracticedPerennialCropCycle.PROPERTY_PRACTICED_SYSTEM, practicedSystem,
                    PracticedPerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY_CODE, randomElem(mainCroppingPlans).getCode(),
                    PracticedPerennialCropCycle.PROPERTY_CROP_CYCLE_PHASES, cropCyclePhases,
                    PracticedPerennialCropCycle.PROPERTY_WEED_TYPE, randomEnum(WeedType.values()));

            createDemoPracticedITK(practicedSystem, cropCyclePhase, null);

            // create seasonnal cycle
            PracticedSeasonalCropCycle practicedSeasonalCropCycle = practicedSeasonalCropCycleTopiaDao.create(
                    PracticedSeasonalCropCycle.PROPERTY_PRACTICED_SYSTEM, practicedSystem);

            PracticedCropCycleNode node1 = cropCycleNodeTopiaDao.create(
                    PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, practicedSeasonalCropCycle,
                    PracticedCropCycleNode.PROPERTY_RANK, 0,
                    PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, randomElem(mainCroppingPlans).getCode());
            PracticedCropCycleNode node2 = cropCycleNodeTopiaDao.create(
                    PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, practicedSeasonalCropCycle,
                    PracticedCropCycleNode.PROPERTY_RANK, 1,
                    PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, randomElem(mainCroppingPlans).getCode());
            PracticedCropCycleNode node3 = cropCycleNodeTopiaDao.create(
                    PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, practicedSeasonalCropCycle,
                    PracticedCropCycleNode.PROPERTY_RANK, 1,
                    PracticedCropCycleNode.PROPERTY_Y, 1,
                    PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, randomElem(mainCroppingPlans).getCode());
            PracticedCropCycleNode node4 = cropCycleNodeTopiaDao.create(
                    PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE, practicedSeasonalCropCycle,
                    PracticedCropCycleNode.PROPERTY_RANK, 2,
                    PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE, randomElem(mainCroppingPlans).getCode(),
                    PracticedCropCycleNode.PROPERTY_END_CYCLE, random.nextBoolean());
            PracticedCropCycleConnection conn1 = cropCycleConnectionTopiaDao.create(
                    PracticedCropCycleConnection.PROPERTY_SOURCE, node1,
                    PracticedCropCycleConnection.PROPERTY_TARGET, node2,
                    PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, 61);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn1.setIntermediateCroppingPlanEntryCode(randomElem(inteCroppingPlans).getCode());
            }
            PracticedCropCycleConnection conn2 = cropCycleConnectionTopiaDao.create(
                    PracticedCropCycleConnection.PROPERTY_SOURCE, node1,
                    PracticedCropCycleConnection.PROPERTY_TARGET, node3,
                    PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, 39);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn2.setIntermediateCroppingPlanEntryCode(randomElem(inteCroppingPlans).getCode());
            }
            PracticedCropCycleConnection conn3 = cropCycleConnectionTopiaDao.create(
                    PracticedCropCycleConnection.PROPERTY_SOURCE, node2,
                    PracticedCropCycleConnection.PROPERTY_TARGET, node4,
                    PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, 100);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn3.setIntermediateCroppingPlanEntryCode(randomElem(inteCroppingPlans).getCode());
            }
            PracticedCropCycleConnection conn4 = cropCycleConnectionTopiaDao.create(
                    PracticedCropCycleConnection.PROPERTY_SOURCE, node3,
                    PracticedCropCycleConnection.PROPERTY_TARGET, node4,
                    PracticedCropCycleConnection.PROPERTY_CROPPING_PLAN_ENTRY_FREQUENCY, 100);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn4.setIntermediateCroppingPlanEntryCode(randomElem(inteCroppingPlans).getCode());
            }

            createDemoPracticedITK(practicedSystem, null, conn1);
            createDemoPracticedITK(practicedSystem, null, conn2);
            createDemoPracticedITK(practicedSystem, null, conn3);
            createDemoPracticedITK(practicedSystem, null, conn4);
        }
    }

    protected void createDemoPracticedITK(PracticedSystem practicedSystem, PracticedCropCyclePhase phase, PracticedCropCycleConnection conn) {
        Preconditions.checkArgument(conn == null ^ phase == null);

        PracticedInterventionTopiaDao practicedInterventionTopiaDao = context.getPersistenceContext().getPracticedInterventionDao();
        PracticedSpeciesStadeTopiaDao practicedSpeciesStadeDao = context.getPersistenceContext().getPracticedSpeciesStadeDao();
        CroppingPlanEntryTopiaDao croppingPlanEntryDao = context.getPersistenceContext().getCroppingPlanEntryDao();
        CroppingPlanSpeciesTopiaDao croppingPlanSpeciesDao = context.getPersistenceContext().getCroppingPlanSpeciesDao();


        Set<String > speciesCodes;
        if (conn != null) {
            String croppingPlanEntryCode;croppingPlanEntryCode = conn.getTarget().getCroppingPlanEntryCode();
            CroppingPlanEntry croppingPlanEntry = croppingPlanEntryDao.forCodeEquals(croppingPlanEntryCode).findAny();
            List<CroppingPlanSpecies> croppingPlanSpecies = croppingPlanSpeciesDao.forCroppingPlanEntryEquals(croppingPlanEntry).findAll();
            speciesCodes= Sets.newHashSet(Iterables.transform(croppingPlanSpecies, new Function<CroppingPlanSpecies, String>() {
                @Override
                public String apply(CroppingPlanSpecies croppingPlanSpecies) {
                    return croppingPlanSpecies.getCode();
                }
            }));
        } else {
            speciesCodes = Sets.newHashSet(); // TODO AThimel 29/01/14 Compute for phases seems too much complicated
        }

        // 1 à 3
        int count = random.nextInt(2) + 1;
        for (int i = 0; i < count; i++) {

            AgrosystInterventionType type = randomEnum(AgrosystInterventionType.values());
            Set<String> toolsCouplingCodes = Sets.newHashSet();
            ToolsCouplingTopiaDao toolsCouplingTopiaDao = context.getPersistenceContext().getToolsCouplingDao();
            List<ToolsCoupling> toolsCouplings = toolsCouplingTopiaDao.forDomainEquals(practicedSystem.getGrowingSystem().getGrowingPlan().getDomain()).findAll();
            if (toolsCouplings != null) {
                for (ToolsCoupling toolsCoupling : toolsCouplings) {
                    for (RefInterventionAgrosystTravailEDI action : toolsCoupling.getMainsActions()) {
                        if (action.getIntervention_agrosyst() == type) {
                            toolsCouplingCodes.add(toolsCoupling.getCode());
                        }
                    }
                }
            }

            List<PracticedSpeciesStade> speciesStades = Lists.newArrayList();
            for (String speciesCode : speciesCodes) {
                PracticedSpeciesStade speciesStade = practicedSpeciesStadeDao.create(
                        PracticedSpeciesStade.PROPERTY_SPECIES_CODE, speciesCode
                );
                speciesStades.add(speciesStade);
            }

            String name = String.format("%s %s %s", randomElem(LOREM_IPSUM_WORDS), randomElem(LOREM_IPSUM_WORDS), randomElem(LOREM_IPSUM_WORDS));
            PracticedIntervention inter = practicedInterventionTopiaDao.create(
                    PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_CONNECTION, conn,
                    PracticedIntervention.PROPERTY_PRACTICED_CROP_CYCLE_PHASE, phase,
                    PracticedIntervention.PROPERTY_NAME, name,
                    PracticedIntervention.PROPERTY_WORK_RATE, randomDouble(0.5, 1.5),
                    PracticedIntervention.PROPERTY_TYPE, randomEnum(AgrosystInterventionType.values()),
                    PracticedIntervention.PROPERTY_TOOLS_COUPLING_CODES, toolsCouplingCodes,
                    PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE, randomInt(1, 28) + "/" + randomInt(1, 12),
                    PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE, randomInt(1, 28) + "/" + randomInt(1, 12),
                    PracticedIntervention.PROPERTY_TEMPORAL_FREQUENCY, randomDouble(1, 2, 0),
                    PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY, randomDouble(0, 1),// varie de +0 à 1
                    PracticedIntervention.PROPERTY_SPECIES_STADES, speciesStades
            );
            createDemoActions(inter, null);
        }
    }

    /**
     * Les interventions culturales réalisées ne sont pas prolongée.
     * Pour plus de données de test, elles sont créés APRES la création/prologation des domaines.
     */
    protected void createDemoInterventionCulturales() {

        if (log.isInfoEnabled()) {
            log.info("Création des interventions culturales réalisées pour les zones...");
        }

        ZoneTopiaDao zoneTopiaDao = context.getPersistenceContext().getZoneDao();
        EffectiveSeasonalCropCycleTopiaDao effectiveSeasonalCropCycleTopiaDao = context.getPersistenceContext().getEffectiveSeasonalCropCycleDao();
        EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleTopiaDao = context.getPersistenceContext().getEffectivePerennialCropCycleDao();
        EffectiveCropCyclePhaseTopiaDao cropCyclePhaseTopiaDao = context.getPersistenceContext().getEffectiveCropCyclePhaseDao();
        EffectiveCropCycleNodeTopiaDao cropCycleNodeTopiaDao = context.getPersistenceContext().getEffectiveCropCycleNodeDao();
        EffectiveCropCycleConnectionTopiaDao cropCycleConnectionTopiaDao = context.getPersistenceContext().getEffectiveCropCycleConnectionDao();

        List<Integer> phaseDurations = Lists.newArrayList(5, 7, 3, 10, 15, 30);

        List<Zone> zones = zoneTopiaDao.findAll();
        int count = zones.size();
        int index = 0;
        for (Zone zone : zones) {

            index++;
            if (log.isInfoEnabled()) {
                log.info(String.format("Création des interventions culturales réalisées (%d/%d)", index, count));
            }

            // get cropping plan for zone's domain
            List<CroppingPlanEntry> croppingPlans = effectiveCropCycleService.getZoneCroppingPlanEntries(zone);
            List<CroppingPlanEntry> mainCroppingPlans = Lists.newArrayList();
            List<CroppingPlanEntry> inteCroppingPlans = Lists.newArrayList();
            for (CroppingPlanEntry croppingPlanEntry : croppingPlans) {
                if (croppingPlanEntry.getType() == CroppingEntryType.INTERMEDIATE) {
                    inteCroppingPlans.add(croppingPlanEntry);
                } else {
                    mainCroppingPlans.add(croppingPlanEntry);
                }
            }

            if (mainCroppingPlans.isEmpty()) {
                return;
            }

            // perennial
            EffectiveCropCyclePhase cropCyclePhase = cropCyclePhaseTopiaDao.newInstance();
            cropCyclePhase.setDuration(randomElem(phaseDurations));
            cropCyclePhase.setType(CropCyclePhaseType.PLEINE_PRODUCTION);
            cropCyclePhase = cropCyclePhaseTopiaDao.create(cropCyclePhase);

            effectivePerennialCropCycleTopiaDao.create(
                    EffectivePerennialCropCycle.PROPERTY_ZONE, zone,
                    EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY, randomElem(mainCroppingPlans),
                    EffectivePerennialCropCycle.PROPERTY_PHASE, cropCyclePhase,
                    EffectivePerennialCropCycle.PROPERTY_WEED_TYPE, randomEnum(WeedType.values()));

            createDemoEffectiveInterventions(zone, cropCyclePhase, null);

            // seasonnal
            EffectiveCropCycleNode node1 = cropCycleNodeTopiaDao.create(
                    EffectiveCropCycleNode.PROPERTY_RANK, 0,
                    EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, randomElem(mainCroppingPlans));
            EffectiveCropCycleNode node2 = cropCycleNodeTopiaDao.create(
                    EffectiveCropCycleNode.PROPERTY_RANK, 1,
                    EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, randomElem(mainCroppingPlans));
            EffectiveCropCycleNode node3 = cropCycleNodeTopiaDao.create(
                    EffectiveCropCycleNode.PROPERTY_RANK, 2,
                    EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, randomElem(mainCroppingPlans));
            EffectiveCropCycleConnection conn = cropCycleConnectionTopiaDao.create(EffectiveCropCycleConnection.PROPERTY_SOURCE, node1,
                    EffectiveCropCycleConnection.PROPERTY_TARGET, node2);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn.setIntermediateCroppingPlanEntry(randomElem(inteCroppingPlans));
            }
            EffectiveCropCycleConnection conn2 = cropCycleConnectionTopiaDao.create(EffectiveCropCycleConnection.PROPERTY_SOURCE, node2,
                    EffectiveCropCycleConnection.PROPERTY_TARGET, node3);
            if (random.nextBoolean() && !inteCroppingPlans.isEmpty()) {
                conn2.setIntermediateCroppingPlanEntry(randomElem(inteCroppingPlans));
            }

            effectiveSeasonalCropCycleTopiaDao.create(
                    EffectiveSeasonalCropCycle.PROPERTY_ZONE, zone,
                    EffectiveSeasonalCropCycle.PROPERTY_NODES, Lists.newArrayList(node1, node2, node3));

            createDemoEffectiveInterventions(zone, null, node1);
            createDemoEffectiveInterventions(zone, null, node2);
            createDemoEffectiveInterventions(zone, null, node3);
        }
    }

    protected void createDemoEffectiveInterventions(Zone zone, EffectiveCropCyclePhase phase, EffectiveCropCycleNode node) {
        Preconditions.checkArgument(node == null ^ phase == null);

        EffectiveInterventionTopiaDao effectiveInterventionTopiaDao = context.getPersistenceContext().getEffectiveInterventionDao();
        EffectiveSpeciesStadeTopiaDao effectiveSpeciesStadeDao = context.getPersistenceContext().getEffectiveSpeciesStadeDao();

        // 1 à 3
        int count = random.nextInt(2) + 1;
        for (int i = 0; i < count; i++) {
            AgrosystInterventionType type = randomEnum(AgrosystInterventionType.values());

            // autoselect tools coupling
            ToolsCouplingTopiaDao toolsCouplingTopiaDao = context.getPersistenceContext().getToolsCouplingDao();
            List<ToolsCoupling> toolsCouplings = toolsCouplingTopiaDao.forDomainEquals(zone.getPlot().getDomain()).findAll();
            Set<ToolsCoupling> selectedToolsCoupling = Sets.newHashSet();
            if (toolsCouplings != null) {
                for (ToolsCoupling toolsCoupling : toolsCouplings) {
                    if (toolsCoupling.getMainsActions() != null) {
                        for (RefInterventionAgrosystTravailEDI mainAction : toolsCoupling.getMainsActions()) {
                            if (mainAction.getIntervention_agrosyst() == type) {
                                selectedToolsCoupling.add(toolsCoupling);
                            }
                        }
                    }
                }
            }

            // compute intervention start and end date
            Calendar calendar = Calendar.getInstance();
            calendar.set(Calendar.YEAR, zone.getPlot().getDomain().getCampaign());
            calendar.add(Calendar.DAY_OF_YEAR, -randomInt(120));
            Date startDate = calendar.getTime();
            calendar.add(Calendar.DAY_OF_YEAR, randomInt(365));
            Date endDate = calendar.getTime();

            List<EffectiveSpeciesStade> speciesStades = Lists.newArrayList();
            if (node != null) {
                for (CroppingPlanSpecies species : node.getCroppingPlanEntry().getCroppingPlanSpecies()) {
                    EffectiveSpeciesStade speciesStade = effectiveSpeciesStadeDao.create(
                            EffectiveSpeciesStade.PROPERTY_CROPPING_PLAN_SPECIES, species
                    );
                    speciesStades.add(speciesStade);
                }
            } // TODO AThimel 29/01/14 Compute for phases seems too much complicated

            String name = String.format("%s %s %s", randomElem(LOREM_IPSUM_WORDS), randomElem(LOREM_IPSUM_WORDS), randomElem(LOREM_IPSUM_WORDS));
            EffectiveIntervention inter = effectiveInterventionTopiaDao.create(
                    EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_NODE, node,
                    EffectiveIntervention.PROPERTY_EFFECTIVE_CROP_CYCLE_PHASE, phase,
                    EffectiveIntervention.PROPERTY_NAME, name,
                    EffectiveIntervention.PROPERTY_SPATIAL_FREQUENCY, randomInt(1, 2),
                    EffectiveIntervention.PROPERTY_TRANSIT_COUNT, randomInt(1, 3),
                    EffectiveIntervention.PROPERTY_WORK_RATE, randomDouble(0.5, 1.5),
                    EffectiveIntervention.PROPERTY_TYPE, type,
                    EffectiveIntervention.PROPERTY_TOOL_COUPLINGS, selectedToolsCoupling,
                    EffectiveIntervention.PROPERTY_START_INTERVENTION_DATE, startDate,
                    EffectiveIntervention.PROPERTY_END_INTERVENTION_DATE, endDate,
                    EffectiveIntervention.PROPERTY_SPECIES_STADES, speciesStades
            );

            createDemoActions(null, inter);
        }
    }

    protected void createDemoActions(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        Preconditions.checkArgument(practicedIntervention == null ^ effectiveIntervention == null);

        // 2 à 4
        Set<Integer> alreadyDone = Sets.newHashSet();
        int count = random.nextInt(3) + 2;
        for (int i = 0; i < count; i++) {

            // de 0 à 5
            int agrosystInterventionType = random.nextInt(6);
            if (!alreadyDone.contains(agrosystInterventionType)) {
                switch (agrosystInterventionType) {
                    case 1:
                        createMineralFertilizersSpreadingAction(practicedIntervention, effectiveIntervention);
                        break;
                    case 2:
                        createOrganicFertilizersSpreadingAction(practicedIntervention, effectiveIntervention);
                        break;
                    case 3:
                        createMaintenancePruningVinesAction(practicedIntervention, effectiveIntervention);
                        break;
                    case 4:
                        createIrrigationAction(practicedIntervention, effectiveIntervention);
                        break;
                    case 5:
                        createTillageAction(practicedIntervention, effectiveIntervention);
                        break;
                    default:
                        createOtherAction(practicedIntervention, effectiveIntervention);
                        break;
                }

                alreadyDone.add(agrosystInterventionType);
            }
        }
    }

    protected RefFertiMinUNIFA randomFertiMinUNIFA() {
        if (fertiMinUnifa.isEmpty()) {
            RefFertiMinUNIFATopiaDao refFertiMinUNIFATopiaDao = context.getPersistenceContext().getRefFertiMinUNIFADao();
            List<String> ids = refFertiMinUNIFATopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                fertiMinUnifa.add(refFertiMinUNIFATopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(fertiMinUnifa);
    }

    protected RefFertiEngraisorg randomFertiEngraisorg() {
        if (fertiEngraisorg.isEmpty()) {
            RefFertiEngraisorgTopiaDao refFertiEngraisorgTopiaDao = context.getPersistenceContext().getRefFertiEngraisorgDao();
            List<String> ids = refFertiEngraisorgTopiaDao.findAllIds();
            for (int i = 0; i < 100; i++) {
                fertiEngraisorg.add(refFertiEngraisorgTopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(fertiEngraisorg);
    }

    protected RefInterventionAgrosystTravailEDI randomActionTravailEDI(AgrosystInterventionType interventionAgrosyst) {
        if (!interventionsTravailEDI.containsKey(interventionAgrosyst)) {
            RefInterventionAgrosystTravailEDITopiaDao refActionAgrosystTravailEDITopiaDao = context.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
            List<String> ids = refActionAgrosystTravailEDITopiaDao.forIntervention_agrosystEquals(interventionAgrosyst).findAllIds();
            interventionsTravailEDI.put(interventionAgrosyst, new ArrayList<RefInterventionAgrosystTravailEDI>());
            for (int i = 0; i < 10; i++) {
                interventionsTravailEDI.get(interventionAgrosyst).add(refActionAgrosystTravailEDITopiaDao.forTopiaIdEquals(randomElem(ids)).findUnique());
            }
        }
        return randomElem(interventionsTravailEDI.get(interventionAgrosyst));
    }

    protected void createMineralFertilizersSpreadingAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionTopiaDao = context.getPersistenceContext().getMineralFertilizersSpreadingActionDao();
        mineralFertilizersSpreadingActionTopiaDao.create(
                MineralFertilizersSpreadingAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                MineralFertilizersSpreadingAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.APPLICATION_DE_PRODUITS_FERTILISANTS_MINERAUX));
    }

    protected void createOrganicFertilizersSpreadingAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionTopiaDao = context.getPersistenceContext().getOrganicFertilizersSpreadingActionDao();
        organicFertilizersSpreadingActionTopiaDao.create(
                OrganicFertilizersSpreadingAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                OrganicFertilizersSpreadingAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.EPANDAGES_ORGANIQUES));
    }

    protected void createMaintenancePruningVinesAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionTopiaDao = context.getPersistenceContext().getMaintenancePruningVinesActionDao();
        maintenancePruningVinesActionTopiaDao.create(
                MaintenancePruningVinesAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                MaintenancePruningVinesAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER));
    }

    protected void createIrrigationAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        IrrigationActionTopiaDao irrigationActionTopiaDao = context.getPersistenceContext().getIrrigationActionDao();
        irrigationActionTopiaDao.create(
                IrrigationAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                IrrigationAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.IRRIGATION),
                IrrigationAction.PROPERTY_WATER_QUANTITY_AVERAGE, randomDouble(5, 42));
    }

    protected void createTillageAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        TillageActionTopiaDao tillageActionTopiaDao = context.getPersistenceContext().getTillageActionDao();
        tillageActionTopiaDao.create(
                TillageAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                TillageAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.TRAVAIL_DU_SOL),
                TillageAction.PROPERTY_TILLAGE_DEPTH, randomDouble(10, 150));
    }

    protected void createOtherAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        OtherActionTopiaDao otherActionTopiaDao = context.getPersistenceContext().getOtherActionDao();
        otherActionTopiaDao.create(
                OtherAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention,
                OtherAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention,
                AbstractAction.PROPERTY_MAIN_ACTION, randomActionTravailEDI(AgrosystInterventionType.AUTRE));
    }

    public void checkForDemoMateriels() {

        RefMaterielTopiaDao refMaterielTopiaDao = context.getPersistenceContext().getRefMaterielDao();
        if (refMaterielTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des matériels...");
            }

            InputStream isAutomoteurs1 = null, isAutomoteurs2 = null, isIrrigation1 = null, isOutils1 = null, isOutils2 = null, isTracteurs1 = null, isTracteurs2 = null;

            try {
                isAutomoteurs1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_automoteur_recolte.csv");
                importService.importMaterielAutomoteursCSV(isAutomoteurs1);
                isAutomoteurs2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_automoteur_vitiarbo.csv");
                importService.importMaterielAutomoteursCSV(isAutomoteurs2);
                isIrrigation1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_materiel_irrigation.csv");
                importService.importMaterielIrrigationCSV(isIrrigation1);
                isOutils1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_outils_vitiarbo.csv");
                importService.importMaterielOutilsCSV(isOutils1);
                isOutils2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_outils.csv");
                importService.importMaterielOutilsCSV(isOutils2);
                isTracteurs1 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_tracteurs_vitiarbo.csv");
                importService.importMaterielTracteursCSV(isTracteurs1);
                isTracteurs2 = DemoDatas.class.getResourceAsStream("/referentiels/materiel/BCMA_tracteurs.csv");
                importService.importMaterielTracteursCSV(isTracteurs2);
            } finally {
                IOUtils.closeQuietly(isAutomoteurs1);
                IOUtils.closeQuietly(isAutomoteurs2);
                IOUtils.closeQuietly(isOutils1);
                IOUtils.closeQuietly(isIrrigation1);
                IOUtils.closeQuietly(isOutils2);
                IOUtils.closeQuietly(isTracteurs1);
                IOUtils.closeQuietly(isTracteurs2);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoCommunes() {

        RefLocationTopiaDao refLocationTopiaDao = context.getPersistenceContext().getRefLocationDao();
        if (refLocationTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des communes...");
            }

            InputStream isCodesPostauxEtCommunes = null, isCommunes = null, isCodesPostaux = null, isRegionsAgricoles = null;
            try {
                isCodesPostauxEtCommunes = DemoDatas.class.getResourceAsStream("/referentiels/communes_osm.csv");
                isCommunes = DemoDatas.class.getResourceAsStream("/referentiels/communes_insee.csv");
                isCodesPostaux = DemoDatas.class.getResourceAsStream("/referentiels/communes_codePosteaux.csv");
                isRegionsAgricoles = DemoDatas.class.getResourceAsStream("/referentiels/communes_regionsAgricoles.txt");
                importService.importCommuneOsmCSV(isCodesPostauxEtCommunes, isRegionsAgricoles);
//                importService.importCommuneInseeCSV(isCommunes, isCodesPostaux, isRegionsAgricoles);
            } finally {
                IOUtils.closeQuietly(isCommunes);
                IOUtils.closeQuietly(isCodesPostaux);
                IOUtils.closeQuietly(isRegionsAgricoles);
                IOUtils.closeQuietly(isCodesPostauxEtCommunes);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoDepartments() {

        RefDepartmentShapeTopiaDao refDepartmentShapeDao = context.getPersistenceContext().getRefDepartmentShapeDao();
        if (refDepartmentShapeDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des shapes de départements ...");
            }

            InputStream isShapes = null;
            try {
                isShapes = DemoDatas.class.getResourceAsStream("/referentiels/geoflar-departements.csv");
                importService.importDepartmentShapes(isShapes);
            } finally {
                IOUtils.closeQuietly(isShapes);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoActaTraitementsProduits() {
        RefActaTraitementsProduitTopiaDao refActaTraitementsProduitTopiaDao = context.getPersistenceContext().getRefActaTraitementsProduitDao();
        if (refActaTraitementsProduitTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ActaTraitementsProduits");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_traitements_produits.csv");
                importService.importActaTraitementsProduits(stream);
            } finally {
                {
                    IOUtils.closeQuietly(stream);
                }
            }
        }

    }

    public void checkForDemoActaTraitementsProduitsCateg() {
        RefActaTraitementsProduitsCategTopiaDao refActaTraitementsProduitsCategTopiaDao = context.getPersistenceContext().getRefActaTraitementsProduitsCategDao();
        if (refActaTraitementsProduitsCategTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ActaTraitementsProduitsCateg");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_traitements_produits_categ.csv");
                importService.importActaTraitementsProduitsCateg(stream);
            } finally {
                {
                    IOUtils.closeQuietly(stream);
                }
            }
        }

    }

    public void checkForDemoSolsArvalis() {
        RefSolArvalisTopiaDao refSolArvalisTopiaDao = context.getPersistenceContext().getRefSolArvalisDao();
        if (refSolArvalisTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des sols arvalis...");
            }

            InputStream solsStream = null;
            try {
                solsStream = DemoDatas.class.getResourceAsStream("/referentiels/sols_arvalis.csv");
                importService.importSolArvalisCSV(solsStream, null);
            } finally {
                IOUtils.closeQuietly(solsStream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoStatutJuridique() {
        RefLegalStatusTopiaDao legalStatusTopiaDao = context.getPersistenceContext().getRefLegalStatusDao();
        if (legalStatusTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des statuts juridiques...");
            }

            InputStream statusStream = null;
            try {
                statusStream = DemoDatas.class.getResourceAsStream("/referentiels/statut_juridique.csv");
                importService.importLegalStatusCSV(statusStream);
            } finally {
                IOUtils.closeQuietly(statusStream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoEspeces() {
        RefEspeceTopiaDao dao = context.getPersistenceContext().getRefEspeceDao();
        if (dao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des espèces...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/cultures_AEE_complet.csv");
                importService.importEspeces(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoVarietesGeves() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefVarieteGevesDao();
        if (dao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des variétés GEVES...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/varietes_GEVES.csv");
                importService.importVarietesGeves(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoVarietesPlantGrape() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefVarietePlantGrapeDao();
        if (dao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des variétés PlantGrape...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/varietes_PlantGrape.csv");
                importService.importVarietesPlantGrape(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoClonesPlantGrape() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefClonePlantGrapeDao();
        if (dao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des clones PlantGrape...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/clones_PlantGrape.csv");
                importService.importClonesPlantGrape(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoEspecesToVarietes() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefEspeceToVarieteDao();
        if (dao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import des espèces <> variétés...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/cultures_varietes.csv");
                importService.importEspecesToVarietes(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    public void checkForDemoOtex() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefOTEXDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel OTEX...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/OTEX.csv");
                importService.importOtexCSV(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoOrientationEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefOrientationEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel Orientation EDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/orientation_edi.csv");
                importService.importOrientationEdiCSV(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoInterventionAgrosysytTravailEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ActionAgrosyst_travailEDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/interventionAgrosyst_travailEDI.csv");
                importService.importInterventionAgrosystTravailEdiCSV(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }


    public void checkForDemoTypeTravailEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefTypeTravailEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel Type_travailEDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/typeTravailEDI.csv");
                importService.importTypeTravailEdiCSV(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    public void checkForDemoStadesEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefStadeEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel stadesEDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/stades_EDI.csv");
                importService.importStadesEdiCSV(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoSolProfondeurIndigo() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefSolProfondeurIndigoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel sol profondeur indigo...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_profondeur_indigo.csv");
                importService.importSolProfondeurIndigo(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoSolCaracteristiquesIndigo() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefSolCaracteristiqueIndigoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel sol caracteristiques indigo...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_caracteristiques_indigo.csv");
                importService.importSolCarateristiquesIndigo(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoParcelleZonageEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefParcelleZonageEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel parcelle zonage edi...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/zonage_parcelle_edi.csv");
                importService.importZonageParcelleEdi(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoSolTextureGeppa() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefSolTextureGeppaDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel sol texture geppa...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/sol_texture_geppa.csv");
                importService.importSolTextureGeppa(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoUnitesEdi() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefUniteEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel unités EDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/unites_EDI.csv");
                importService.importUniteEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoFertiMinUNIFA() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefFertiMinUNIFADao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel FertiMinUNIFA...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_min_UNIFA.csv");
                importService.importFertiMinUNIFA(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoBioAgressors() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefAdventiceDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel Adventices...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/adventices.csv");
                importService.importAdventices(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

        dao = context.getPersistenceContext().getRefNuisibleEDIDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel NuisiblesEDI...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/nuisibles_edi.csv");
                importService.importNuisiblesEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    protected void checkForDemoRefFertiOrga() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefFertiOrgaDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ferti_orga...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_orga.csv");
                importService.importFertiOrga(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoFertiEngraisOrg() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefFertiEngraisorgDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel FertiEngraisorg...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ferti_engraisorg.csv");
                importService.importFertiEngraisOrg(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoStationMeteo() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefStationMeteoDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel Station meteo...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/station_meteo_inra.csv");
                importService.importStationMeteo(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    protected void checkForDemoTypeAgriculture() {
        TopiaDao<? extends ReferentialEntity> dao = context.getPersistenceContext().getRefTypeAgricultureDao();
        if (dao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel TypeAgriculture...");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/type_agriculture.csv");
                importService.importTypeAgriculture(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoIndicatorReferentials() {
        // ges carburants
        RefGesCarburantTopiaDao refGesCarburantTopiaDao = context.getPersistenceContext().getRefGesCarburantDao();
        if (refGesCarburantTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_carburants.csv");
                importService.importGesCarburants(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges engrais
        RefGesEngraisTopiaDao refGesEngraisTopiaDao = context.getPersistenceContext().getRefGesEngraisDao();
        if (refGesEngraisTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_engrais.csv");
                importService.importGesEngrais(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges phyto
        RefGesPhytoTopiaDao refGesPhytoTopiaDao = context.getPersistenceContext().getRefGesPhytoDao();
        if (refGesPhytoTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_phyto.csv");
                importService.importGesPhyto(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges semences
        RefGesSemenceTopiaDao refGesSemenceTopiaDao = context.getPersistenceContext().getRefGesSemenceDao();
        if (refGesSemenceTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/ges_semences.csv");
                importService.importGesSemences(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges carburants
        RefNrjCarburantTopiaDao refNrjCarburantTopiaDao = context.getPersistenceContext().getRefNrjCarburantDao();
        if (refNrjCarburantTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_carburants.csv");
                importService.importNrjCarburants(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges engrais
        RefNrjEngraisTopiaDao refNrjEngraisTopiaDao = context.getPersistenceContext().getRefNrjEngraisDao();
        if (refNrjEngraisTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_engrais.csv");
                importService.importNrjEngrais(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges phyto
        RefNrjPhytoTopiaDao refNrjPhytoTopiaDao = context.getPersistenceContext().getRefNrjPhytoDao();
        if (refNrjPhytoTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_phyto.csv");
                importService.importNrjPhyto(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // ges semences
        RefNrjSemenceTopiaDao refNrjSemenceTopiaDao = context.getPersistenceContext().getRefNrjSemenceDao();
        if (refNrjSemenceTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_semences.csv");
                importService.importNrjSemences(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }

        // nrj ges outils
        RefNrjGesOutilTopiaDao refNrjGesOutilsTopiaDao = context.getPersistenceContext().getRefNrjGesOutilDao();
        if (refNrjGesOutilsTopiaDao.count() == 0L) {
            InputStream is = null;
            try {
                is = DemoDatas.class.getResourceAsStream("/referentiels/indicateur/nrj_ges_outils.csv");
                importService.importNrjGesOutils(is);
            } finally {
                IOUtils.closeQuietly(is);
            }
        }
        context.getTransaction().commit();
    }

    protected void checkForDemoMesureReferentials() {
        RefMesureTopiaDao refMesureTopiaDao = context.getPersistenceContext().getRefMesureDao();
        if (refMesureTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel Mesures...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/mesures.csv");
                importService.importMesure(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }
            context.getTransaction().commit();
        }

        RefStadeNuisibleEDITopiaDao refStadeNuisibleEDITopiaDao = context.getPersistenceContext().getRefStadeNuisibleEDIDao();
        if (refStadeNuisibleEDITopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel StadeNuisibleEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/stades_nuisibles_edi.csv");
                importService.importStadeNuisibleEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }
            context.getTransaction().commit();
        }

        RefTypeNotationEDITopiaDao refTypeNotationEDITopiaDao = context.getPersistenceContext().getRefTypeNotationEDIDao();
        if (refTypeNotationEDITopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel TypeNotationEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/type_notation_edi.csv");
                importService.importTypeNotationEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }
            context.getTransaction().commit();
        }

        RefValeurQualitativeEDITopiaDao refValeurQualitativeEDITopiaDao = context.getPersistenceContext().getRefValeurQualitativeEDIDao();
        if (refValeurQualitativeEDITopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ValeurQualitativeEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/valeurs_qualitatives_edi.csv");
                importService.importValeurQualitativeEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }
            context.getTransaction().commit();
        }

        RefUnitesQualifiantEDITopiaDao refUnitesQualifiantEDITopiaDao = context.getPersistenceContext().getRefUnitesQualifiantEDIDao();
        if (refUnitesQualifiantEDITopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel UnitesQualifiantEDI...");
            }
            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/unites_qualifiants_edi.csv");
                importService.importUnitesQualifiantEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }
            context.getTransaction().commit();
        }
    }

    protected void checkForDemoSupportOrganeEdi() {
        RefSupportOrganeEDITopiaDao refSupportOrganeEdiTopiaDao = context.getPersistenceContext().getRefSupportOrganeEDIDao();

        if (refSupportOrganeEdiTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import du référentiel SupportOrganeEdi...");
            }

            InputStream stream = null;

            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/support_organe_edi.csv");
                importService.importSupportOrganeEDI(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoActaSubstanceActive() {
        RefActaSubstanceActiveTopiaDao refActaSubstanceActiveTopiaDao = context.getPersistenceContext().getRefActaSubstanceActiveDao();

        if (refActaSubstanceActiveTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ActaSubstanceActive...");
            }

            InputStream stream = null;

            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_SA.csv");
                importService.importActaSubstanceActive(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoProtocoleVgObs() {
        RefProtocoleVgObsTopiaDao refProtocoleVgObsTopiaDao = context.getPersistenceContext().getRefProtocoleVgObsDao();

        if (refProtocoleVgObsTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ProtocoleVgObs...");
            }

            InputStream stream = null;

            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/mesures/protocoles_vgobs.csv");
                importService.importProtocoleVgObs(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }


    protected void checkForDemoElementVoisinage() {
        RefElementVoisinageTopiaDao refElementVoisinageTopiaDao = context.getPersistenceContext().getRefElementVoisinageDao();

        if (refElementVoisinageTopiaDao.count() == 0L) {

            if (log.isInfoEnabled()) {
                log.info("Import du référentiel ElementVoisinage...");
            }

            InputStream stream = null;

            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/elements_voisinage.csv");
                importService.importElementVoisinage(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    protected void checkForDemoIphyReferentials() {
        checkForDemoPhytoSubstanceActiveIphy();
        checkForDemoRcesoCaseGroundWater();
        checkForDemoRcesoFuzzySetGroundWater();
        checkForDemoRcesoRulesGroundWater();
        checkForDemoRcesuRunoffPotRulesParc();
    }

    protected void checkForDemoPhytoSubstanceActiveIphy() {
        RefPhytoSubstanceActiveIphyTopiaDao refPhytoSubstanceActiveIphyTopiaDao = context.getPersistenceContext().getRefPhytoSubstanceActiveIphyDao();
        if (refPhytoSubstanceActiveIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RefPhytoSubstanceActiveIphy");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/phyto_substanceactives-iphy.csv");
                importService.importPhytoSubstanceActiveIphy(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoRcesoCaseGroundWater() {
        RefRcesoCaseGroundWaterTopiaDao refRcesoCaseGroundWaterTopiaDao = context.getPersistenceContext().getRefRcesoCaseGroundWaterDao();
        if (refRcesoCaseGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RcesoCaseGroundWater");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/case-groundwater.csv");
                importService.importRcesoCaseGroundWater(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoRcesoFuzzySetGroundWater() {
        RefRcesoFuzzySetGroundWaterTopiaDao refRcesoFuzzySetGroundWaterTopiaDao = context.getPersistenceContext().getRefRcesoFuzzySetGroundWaterDao();
        if (refRcesoFuzzySetGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RcesoFuzzySetGroundWater");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/fuzzyset-groundwater.csv");
                importService.importRcesoFuzzySetGroundWater(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoRcesoRulesGroundWater() {
        RefRcesoRulesGroundWaterTopiaDao refRcesoRulesGroundWaterTopiaDao = context.getPersistenceContext().getRefRcesoRulesGroundWaterDao();
        if (refRcesoRulesGroundWaterTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RcesoRulesGroundWater");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rceso/rules-groundwater.csv");
                importService.importRcesoRulesGroundWater(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoRcesuRunoffPotRulesParc() {
        RefRcesuRunoffPotRulesParcTopiaDao refRcesuRunoffPotRulesParcTopiaDao = context.getPersistenceContext().getRefRcesuRunoffPotRulesParcDao();
        if (refRcesuRunoffPotRulesParcTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RcesuRunoffPotRulesParc");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/rcesu/runoff-pot-rules-parc.csv");
                importService.importRcesuRunoffPotRulesParc(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoSaActaIphy() {
        RefSaActaIphyTopiaDao refSaActaIphyTopiaDao = context.getPersistenceContext().getRefSaActaIphyDao();
        if (refSaActaIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refSaActaIphy");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/SA_ACTA_IPHY.csv");
                importService.importSaActaIphy(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoLienCulturesEdiActa() {
        RefLienCulturesEdiActaTopiaDao refLienCulturesEdiActaTopiaDao = context.getPersistenceContext().getRefLienCulturesEdiActaDao();
        if (refLienCulturesEdiActaTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refLienCulturesEdiActa");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/LienCultures-EDI-ACTA.csv");
                importService.importLienCulturesEdiActa(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoActaGroupeCultures() {
        RefActaGroupeCulturesTopiaDao refActaGroupeCulturesTopiaDao = context.getPersistenceContext().getRefActaGroupeCulturesDao();
        if (refActaGroupeCulturesTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refActaGroupeCultures");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_GroupeCultures.csv");
                importService.importActaGroupeCultures(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    protected void checkForDemoActaDosageSpc() {
        RefActaDosageSPCTopiaDao refActaDosageSPCTopiaDao = context.getPersistenceContext().getRefActaDosageSPCDao();
        if (refActaDosageSPCTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refActaDosageSPC");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/ACTA_dosage_SPC_complet.csv");
                importService.importActaDosageSpc(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }

    }

    protected void checkForDemoTraitSdC() {
        RefTraitSdCTopiaDao refTraitSdCTopiaDao = context.getPersistenceContext().getRefTraitSdCDao();
        if (refTraitSdCTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refTraitSdC");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/traitSdC.csv");
                importService.importTraitSdC(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoCouvSolPerenne() {
        RefCouvSolPerenneTopiaDao refCouvSolPerenneTopiaDao = context.getPersistenceContext().getRefCouvSolPerenneDao();
        if (refCouvSolPerenneTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refCouvSolPerenneTopiaDao");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/Couv-sol_Perennes.csv");
                importService.importCouvSolPerenne(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoCultureEdiGroupeCouvSol() {
        RefCultureEdiGroupeCouvSolTopiaDao refCultureEdiGroupeCouvSolTopiaDao = context.getPersistenceContext().getRefCultureEdiGroupeCouvSolDao();
        if (refCultureEdiGroupeCouvSolTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refCultureEdiGroupeCouvSol");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/CulturesEDI_Groupe-couv-sol.csv");
                importService.importCultureEdiGroupeCouvSol(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }

    protected void checkForDemoCouvSolAnnuelle() {
        RefCouvSolAnnuelleTopiaDao refCouvSolAnnuelleTopiaDao = context.getPersistenceContext().getRefCouvSolAnnuelleDao();
        if (refCouvSolAnnuelleTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel refCouvSolAnnuelle");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/Couv-sol_Annuelles.csv");
                importService.importCouvSolAnnuelle(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
    }
    
    protected void checkForDemoZoneClimatiqueIphy() {
        RefZoneClimatiqueIphyTopiaDao refZoneClimatiqueIphyTopiaDao = context.getPersistenceContext().getRefZoneClimatiqueIphyDao();
        if (refZoneClimatiqueIphyTopiaDao.count() == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Import du référentiel RefZoneClimatiqueIphy");
            }

            InputStream stream = null;
            try {
                stream = DemoDatas.class.getResourceAsStream("/referentiels/iphy/zones_climatiques_IPHY.csv");
                importService.importZoneClimatiqueIphy(stream);
            } finally {
                IOUtils.closeQuietly(stream);
            }

            context.getTransaction().commit();
        }
        
    }
}
