package fr.inra.agrosyst.services.common.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: UniqueDualLinkedHashMap.java 3870 2014-03-25 17:12:42Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/common/export/UniqueDualLinkedHashMap.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

/**
 * Classe qui étend {@link DualLinkedHashBidiMap} et qui assure la non double définition de
 * clé ou valeur.
 * 
 * @author Eric Chatellier
 *
 * @param <K> key type
 * @param <V> value type
 */
public class UniqueDualLinkedHashMap<K, V> extends DualLinkedHashBidiMap<K, V> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2260417995257102878L;

    @Override
    public V put(K key, V value) {
        if (containsKey(key)) {
            throw new IllegalStateException("Can't erase already defined key : " + key);
        }
        if (containsValue(value)) {
            throw new IllegalStateException("Can't erase already defined value : " + value);
        }
        return super.put(key, value);
    }

}
