package fr.inra.agrosyst.services.common.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EntityExportTabInfo.java 3896 2014-03-28 09:49:08Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/common/export/EntityExportTabInfo.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.commons.collections4.BidiMap;

import com.google.common.base.Function;

public interface EntityExportTabInfo {

    /**
     * Return bean category (in order to be used as tab title in xls files).
     *
     * @return bean title
     */
    String getBeanTitle();

    /**
     * Return map 'column properties' &gt; display name.
     * 
     * Return modifiable map for sub instance.
     *
     * @return bean properties and display name
     */
    BidiMap<String, String> getCommonColumns();

    /**
     * Return map 'column properties' &gt; display name.
     * 
     * Return modifiable map for sub instance.
     *
     * @return bean properties and display name
     */
    BidiMap<String, String> getExtraColumns();

    /**
     * Permet de transformer un object complexe on champs simple representable pour un export (String).
     * 
     * @return une map avec une fonction de transformation pour des propriétes du tab infos courant
     */
    <K> Map<String, Function<K, Object>> getCustomFormatters();

    /**
     * Permet de transformer une chaine en lecture en une entité ou un objet d'un autre type.
     * 
     * @return un map avec un fonction certaines proprietes
     */
    Map<String, Function<String, Object>> getCustomParsers();

    /**
     * Retourne une drop down list pour une priopriété du tab info.
     * 
     * @return une map avec une list de valeur pour une propriétés
     */
    Map<String, Iterable<String>> getCustomDropDownList();
}
