package fr.inra.agrosyst.services.common.export;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AbstractEntityExportExtra.java 3906 2014-03-29 17:08:06Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/common/export/AbstractEntityExportExtra.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.google.common.collect.Maps;

public class AbstractEntityExportExtra implements EntityExportExtra, Cloneable {

    protected Map<String, Object> extras;

    @Override
    public Map<String, Object> getExtras() {
        return extras;
    }

    @Override
    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    @Override
    public Object getExtra(String key) {
        return extras.get(key);
    }

    @Override
    public String getExtraAsString(String key) {
        return (String)getExtra(key);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractEntityExportExtra clone = (AbstractEntityExportExtra) super.clone();
        if (extras != null) {
            clone.extras = Maps.newHashMap(extras);
        }
        return clone;
    }
}
