package fr.inra.agrosyst.services.common;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: Prices.java 4339 2014-09-17 10:04:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/common/Prices.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.Price;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class Prices {

    public static final Function<Price, String> GET_PRICE_KEY = new Function<Price, String>() {
        @Override
        public String apply(Price input) {
            String inputId = StringUtils.isBlank(input.getObjectId()) ? "null" : StringUtils.stripAccents(input.getObjectId());
            String result = String.format("%s_%s_%s", input.getCategory(), inputId, input.getSourceUnit());
            return result;
        }
    };

}
