package fr.inra.agrosyst.services.common;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CommonService.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/common/CommonService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Created by davidcosse on 22/10/14.
 */
public class CommonService {
    protected static final int LOWER_CAMPAIGN_BOUND = 2000;
    protected static final int UPPER_CAMPAIGN_BOUND = 2999; // XXX AThimel 02/09/13 Move to configuration ?
    protected static final Pair<Integer, Integer> CAMPAIGNS_BOUNDS = Pair.of(LOWER_CAMPAIGN_BOUND, UPPER_CAMPAIGN_BOUND);

    public static Pair<Integer, Integer> GET_CAMPAIGNS_BOUNDS() {
        return CAMPAIGNS_BOUNDS;
    }

    public static boolean ARE_CAMPAIGNS_VALIDS(String campaigns) {
        Log log = LogFactory.getLog(CommonService.class);
        boolean result = false;
        try {
            Set<Integer> set = GET_CAMPAIGNS_SET.apply(campaigns);
            result = set != null && !set.isEmpty();
            if (result) {
                for (Integer integer : set) {
                    if (integer < LOWER_CAMPAIGN_BOUND || integer > UPPER_CAMPAIGN_BOUND) {
                        if (log.isWarnEnabled()) {
                            String format = "Invalid campaign: %d. Must be contained between %d and %d. ";
                            String message = String.format(format, integer, LOWER_CAMPAIGN_BOUND, UPPER_CAMPAIGN_BOUND);
                            log.warn(message);
                        }
                        result = false;
                    }
                }
            }
        } catch (Exception eee) {
            // Parsing exception
            if (log.isWarnEnabled()) {
                log.warn("Invalid campaigns: " + campaigns, eee);
            }
        }
        return result;
    }

    protected static final Function<String, Integer> STRING_TO_INTEGER = new Function<String, Integer>() {
        @Override
        public Integer apply(String input) {
            Integer result = Integer.valueOf(input);
            return result;
        }
    };

    public static final Function<String, Set<Integer>> GET_CAMPAIGNS_SET = new Function<String, Set<Integer>>() {
        @Override
        public Set<Integer> apply(String input) {
            Preconditions.checkNotNull(input);
            Set<Integer> result = Sets.newLinkedHashSet();
            input = input.replaceAll("\\D+", " ");
            Iterable<String> split = Splitter.on(" ").trimResults().omitEmptyStrings().split(input);
            Iterable<Integer> splitIntegers = Iterables.transform(split, STRING_TO_INTEGER);
            Iterables.addAll(result, splitIntegers);
            return result;
        }
    };

    public static final Function<Set<Integer>, String> ARRANGE_CAMPAIGNS_SET = new Function<Set<Integer>, String>() {
        @Override
        public String apply(Set<Integer> input) {
            Preconditions.checkNotNull(input);
            List<Integer> campaignsList = Lists.newArrayList(input);
            Collections.sort(campaignsList);
            String result = Joiner.on(", ").join(campaignsList);
            return result;
        }
    };

    public static final Function<String, String> ARRANGE_CAMPAIGNS = Functions.compose(ARRANGE_CAMPAIGNS_SET, GET_CAMPAIGNS_SET);
}
