package fr.inra.agrosyst.services.action;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ActionServiceImpl.java 5200 2015-12-13 21:48:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/action/ActionServiceImpl.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.CroppingPlanEntryTopiaDao;
import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.BiologicalControlAction;
import fr.inra.agrosyst.api.entities.action.BiologicalControlActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.CarriageAction;
import fr.inra.agrosyst.api.entities.action.CarriageActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.action.HarvestingYealdTopiaDao;
import fr.inra.agrosyst.api.entities.action.IrrigationAction;
import fr.inra.agrosyst.api.entities.action.IrrigationActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesAction;
import fr.inra.agrosyst.api.entities.action.MaintenancePruningVinesActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.MineralFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingAction;
import fr.inra.agrosyst.api.entities.action.OrganicFertilizersSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.OtherAction;
import fr.inra.agrosyst.api.entities.action.OtherActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingAction;
import fr.inra.agrosyst.api.entities.action.PesticidesSpreadingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.action.SeedingActionTopiaDao;
import fr.inra.agrosyst.api.entities.action.TillageAction;
import fr.inra.agrosyst.api.entities.action.TillageActionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.services.action.ActionService;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleService;
import fr.inra.agrosyst.api.services.input.InputService;
import fr.inra.agrosyst.api.services.practiced.DuplicateCropCyclesContext;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.AbstractAgrosystService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/**
 * @author David Cossé
 */
public class ActionServiceImpl extends AbstractAgrosystService implements ActionService {

    protected InputService inputService;
    protected ReferentialService referentialService;

    protected AbstractActionTopiaDao abstractActionDao;
    protected HarvestingActionTopiaDao harvestingActionDao;
    protected SeedingActionTopiaDao seedingActionDao;
    protected OtherActionTopiaDao otherActionDao;
    protected IrrigationActionTopiaDao irrigationActionDao;
    protected TillageActionTopiaDao tillageActionDao;
    protected OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao;
    protected MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao;
    protected PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao;
    protected MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao;
    protected BiologicalControlActionTopiaDao biologicalControlActionDao;
    protected HarvestingYealdTopiaDao harvestingYealdDao;
    protected SeedingActionSpeciesTopiaDao seedingActionSpeciesDao;
    protected CarriageActionTopiaDao carriageActionDao;
    protected EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao;
    protected EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao;
    protected CroppingPlanEntryTopiaDao croppingPlanEntryDao;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setCroppingPlanEntryDao(CroppingPlanEntryTopiaDao croppingPlanEntryDao) {
        this.croppingPlanEntryDao = croppingPlanEntryDao;
    }

    public void setInputService(InputService inputService) {
        this.inputService = inputService;
    }

    public void setAbstractActionDao(AbstractActionTopiaDao abstractActionDao) {
        this.abstractActionDao = abstractActionDao;
    }

    public void setHarvestingActionDao(HarvestingActionTopiaDao harvestingActionDao) {
        this.harvestingActionDao = harvestingActionDao;
    }

    public void setSeedingActionDao(SeedingActionTopiaDao seedingActionDao) {
        this.seedingActionDao = seedingActionDao;
    }

    public void setOtherActionDao(OtherActionTopiaDao otherActionDao) {
        this.otherActionDao = otherActionDao;
    }

    public void setIrrigationActionDao(IrrigationActionTopiaDao irrigationActionDao) {
        this.irrigationActionDao = irrigationActionDao;
    }

    public void setTillageActionDao(TillageActionTopiaDao tillageActionDao) {
        this.tillageActionDao = tillageActionDao;
    }

    public void setOrganicFertilizersSpreadingActionDao(OrganicFertilizersSpreadingActionTopiaDao organicFertilizersSpreadingActionDao) {
        this.organicFertilizersSpreadingActionDao = organicFertilizersSpreadingActionDao;
    }

    public void setMaintenancePruningVinesActionDao(MaintenancePruningVinesActionTopiaDao maintenancePruningVinesActionDao) {
        this.maintenancePruningVinesActionDao = maintenancePruningVinesActionDao;
    }

    public void setPesticidesSpreadingActionDao(PesticidesSpreadingActionTopiaDao pesticidesSpreadingActionDao) {
        this.pesticidesSpreadingActionDao = pesticidesSpreadingActionDao;
    }

    public void setMineralFertilizersSpreadingActionDao(MineralFertilizersSpreadingActionTopiaDao mineralFertilizersSpreadingActionDao) {
        this.mineralFertilizersSpreadingActionDao = mineralFertilizersSpreadingActionDao;
    }

    public void setBiologicalControlActionDao(BiologicalControlActionTopiaDao biologicalControlActionDao) {
        this.biologicalControlActionDao = biologicalControlActionDao;
    }

    public void setHarvestingYealdDao(HarvestingYealdTopiaDao harvestingYealdDao) {
        this.harvestingYealdDao = harvestingYealdDao;
    }

    public void setSeedingActionSpeciesDao(SeedingActionSpeciesTopiaDao seedingActionSpeciesDao) {
        this.seedingActionSpeciesDao = seedingActionSpeciesDao;
    }

    public void setCarriageActionDao(CarriageActionTopiaDao carriageActionDao) {
        this.carriageActionDao = carriageActionDao;
    }

    public void setEffectiveCropCycleConnectionDao(EffectiveCropCycleConnectionTopiaDao effectiveCropCycleConnectionDao) {
        this.effectiveCropCycleConnectionDao = effectiveCropCycleConnectionDao;
    }

    public void setEffectivePerennialCropCycleDao(EffectivePerennialCropCycleTopiaDao effectivePerennialCropCycleDao) {
        this.effectivePerennialCropCycleDao = effectivePerennialCropCycleDao;
    }

    @Override
    public Map<String, AbstractAction> createPracticedInterventionActions(
            PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes) {
        Map<String, AbstractAction> result = createOrUpdateActions(actions, null, intervention, null, speciesCodes);
        return result;
    }

    @Override
    public Map<String, AbstractAction> updatePracticedInterventionActions(
            PracticedIntervention intervention, List<AbstractAction> actions, Set<String> speciesCodes) {
        List<AbstractAction> originalActions = abstractActionDao.forPracticedInterventionEquals(intervention).findAll();
        Map<String, AbstractAction> result = createOrUpdateActions(actions, originalActions, intervention, null, speciesCodes);
        return result;
    }

    @Override
    public Map<String, AbstractAction> createEffectiveInterventionActions(EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes) {
        Map<String, AbstractAction> result = createOrUpdateActions(actions, null, null, intervention, speciesCodes);
        return result;
    }

    @Override
    public Map<String, AbstractAction> updateEffectiveInterventionActions(
            EffectiveIntervention intervention, Collection<AbstractAction> actions, Set<String> speciesCodes) {
        List<AbstractAction> originalActions = abstractActionDao.forEffectiveInterventionEquals(intervention).findAll();
        Map<String, AbstractAction> result = createOrUpdateActions(actions, originalActions, null, intervention, speciesCodes);
        return result;
    }

    protected Map<String, AbstractAction> createOrUpdateActions(
            Collection<AbstractAction> actions,
            Collection<AbstractAction> originalActions,
            PracticedIntervention practicedIntervention,
            EffectiveIntervention effectiveIntervention,
            Set<String> speciesCodes) {

        // action or mapped by ids that can be a topiaId or an other generated id. This is done
        // for inputs to be able to find there action.
        Map<String, AbstractAction> resultByIds = Maps.newHashMap();

        Map<String, AbstractAction> originalActionsByIds = getOriginalActionsByIds(originalActions);

        if (actions != null) {

            Preconditions.checkArgument(effectiveIntervention == null ^ practicedIntervention == null);

            Collection<String> toolsCouplingCodes = getCropCycleToolsCouplingCodes(practicedIntervention, effectiveIntervention);

            for (AbstractAction action : actions) {
                AbstractAction savedAction;
                String actionId = action.getTopiaId();

                action.setToolsCouplingCode(getActionToolsCouplingCode(toolsCouplingCodes, action));
                setCropCycleToAction(practicedIntervention, effectiveIntervention, action);

                savedAction = saveAction(speciesCodes, originalActionsByIds, action);

                resultByIds.put(actionId, savedAction);
            }
        }

        inputService.deleteInputForActions(originalActionsByIds.values());
        abstractActionDao.deleteAll(originalActionsByIds.values());
        return resultByIds;
    }

    protected AbstractAction saveAction(Set<String> speciesCodes, Map<String, AbstractAction> originalActionsByIds, AbstractAction action) {
        AbstractAction savedAction;
        AbstractAction originalAction = getOriginalActionIfExists(originalActionsByIds, action);
        if (originalAction == null) {
            savedAction = saveNewAction(speciesCodes, action);
        } else {
            savedAction = saveUpdatedAction(speciesCodes, action, originalAction);
        }
        return savedAction;
    }

    protected Map<String, AbstractAction> getOriginalActionsByIds(Collection<AbstractAction> originalActions) {
        Map<String, AbstractAction> originalActionsByIds;
        if (originalActions == null) {
            originalActionsByIds = Maps.newHashMap();
        } else {
            Map<String, AbstractAction> immutOriginalActionsMap;
            immutOriginalActionsMap = Maps.uniqueIndex(originalActions, Entities.GET_TOPIA_ID);
            originalActionsByIds = Maps.newHashMap(immutOriginalActionsMap);
        }
        return originalActionsByIds;
    }

    protected AbstractAction saveUpdatedAction(Set<String> speciesCodes, AbstractAction action, AbstractAction originalAction) {
        AbstractAction currentAction;
        if (!originalAction.getClass().equals(action.getClass())) {
            throw new UnsupportedOperationException("Uncompatible action classes : " + originalAction.getClass().getName() + " VS " + action.getClass().getName());
        }

        // In case of HarvestingAction we manage it's collection elements.
        if (originalAction instanceof HarvestingAction) {
            // we apply the change into the original harvestingYealds collection element that have been loaded into the session.
            Collection<HarvestingYeald> originalHarvestingYealds = ((HarvestingAction) originalAction).getHarvestingYealds();
            List<HarvestingYeald> nonDeletedHarvestingYealds = Lists.newArrayList();
            if (originalHarvestingYealds == null) {
                originalHarvestingYealds = Lists.newArrayList();
                ((HarvestingAction) originalAction).setHarvestingYealds(originalHarvestingYealds);
            }

            Collection<HarvestingYeald> harvestingYealds = ((HarvestingAction) action).getHarvestingYealds();
            Map<String, HarvestingYeald> indexedHarvestingYealds = Maps.uniqueIndex(originalHarvestingYealds, Entities.GET_TOPIA_ID);

            for (HarvestingYeald harvestingYeald : harvestingYealds) {
                String topiaId = harvestingYeald.getTopiaId();
                HarvestingYeald originalHarvestingYeald = indexedHarvestingYealds.get(topiaId);

                if (originalHarvestingYeald != null) {
                    Binder<HarvestingYeald, HarvestingYeald> binder = BinderFactory.newBinder(HarvestingYeald.class);
                    binder.copyExcluding(harvestingYeald, originalHarvestingYeald,
                            HarvestingAction.PROPERTY_TOPIA_ID,
                            HarvestingAction.PROPERTY_TOPIA_CREATE_DATE,
                            HarvestingAction.PROPERTY_TOPIA_VERSION);
                    nonDeletedHarvestingYealds.add(originalHarvestingYeald);
                } else {
                    originalHarvestingYealds.add(harvestingYeald);
                    nonDeletedHarvestingYealds.add(harvestingYeald);
                }
            }
            originalHarvestingYealds.retainAll(nonDeletedHarvestingYealds);

            // apply the modifications on to the action
            Binder<HarvestingAction, HarvestingAction> binder = BinderFactory.newBinder(HarvestingAction.class);
            binder.copyExcluding((HarvestingAction) action, (HarvestingAction) originalAction,
                    HarvestingAction.PROPERTY_TOPIA_ID,
                    HarvestingAction.PROPERTY_TOPIA_CREATE_DATE,
                    HarvestingAction.PROPERTY_TOPIA_VERSION,
                    HarvestingAction.PROPERTY_HARVESTING_YEALDS);
            currentAction = abstractActionDao.update(originalAction);
        }

        // In case of SeedingAction we manage it's collection elements.
        else if (originalAction instanceof SeedingAction) {
            // we apply the change into the original seedingSpeciesActions collection element that have been loaded into the session.
            Collection<SeedingActionSpecies> originalSeedingActionSpeciess = ((SeedingAction) originalAction).getSeedingSpecies();
            List<SeedingActionSpecies> nonDeletedSeedingActionSpeciess = Lists.newArrayList();
            if (originalSeedingActionSpeciess == null) {
                originalSeedingActionSpeciess = Lists.newArrayList();
                ((SeedingAction) originalAction).setSeedingSpecies(originalSeedingActionSpeciess);
            }

            Collection<SeedingActionSpecies> seedingSpeciesActions = ((SeedingAction) action).getSeedingSpecies();
            Map<String, SeedingActionSpecies> indexedSeedingActionSpeciess = Maps.uniqueIndex(originalSeedingActionSpeciess, Entities.GET_TOPIA_ID);

            if (seedingSpeciesActions != null) {
                for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {
                    String topiaId = seedingSpeciesAction.getTopiaId();
                    SeedingActionSpecies originalSeedingActionSpecies = indexedSeedingActionSpeciess.get(topiaId);

                    // make sure the seeding species action reference an intervention species.
                    if (speciesCodes.contains(seedingSpeciesAction.getSpeciesCode())){
                        if (originalSeedingActionSpecies != null) {
                            Binder<SeedingActionSpecies, SeedingActionSpecies> binder = BinderFactory.newBinder(SeedingActionSpecies.class);
                            binder.copyExcluding(seedingSpeciesAction, originalSeedingActionSpecies,
                                    SeedingActionSpecies.PROPERTY_TOPIA_ID,
                                    SeedingActionSpecies.PROPERTY_TOPIA_CREATE_DATE,
                                    SeedingActionSpecies.PROPERTY_TOPIA_VERSION);
                            nonDeletedSeedingActionSpeciess.add(originalSeedingActionSpecies);
                        } else {
                            originalSeedingActionSpeciess.add(seedingSpeciesAction);
                            nonDeletedSeedingActionSpeciess.add(seedingSpeciesAction);
                        }
                    }
                }
            }

            originalSeedingActionSpeciess.retainAll(nonDeletedSeedingActionSpeciess);

            // apply the modifications on to the action
            Binder<SeedingAction, SeedingAction> binder = BinderFactory.newBinder(SeedingAction.class);
            binder.copyExcluding((SeedingAction) action, (SeedingAction) originalAction,
                    SeedingAction.PROPERTY_TOPIA_ID,
                    SeedingAction.PROPERTY_TOPIA_CREATE_DATE,
                    SeedingAction.PROPERTY_TOPIA_VERSION,
                    SeedingAction.PROPERTY_SEEDING_SPECIES);
            currentAction = abstractActionDao.update(originalAction);

        } else if (originalAction instanceof OtherAction) {
            OtherAction otherAction = (OtherAction) action;
            // apply the modifications on to the action
            Binder<OtherAction, OtherAction> binder = BinderFactory.newBinder(OtherAction.class);

            // apply the modifications on to the action
            binder.copyExcluding(otherAction, (OtherAction) originalAction,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof IrrigationAction) {
            // apply the modifications on to the action
            Binder<IrrigationAction, IrrigationAction> binder = BinderFactory.newBinder(IrrigationAction.class);
            binder.copyExcluding((IrrigationAction) action, (IrrigationAction) originalAction,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof TillageAction) {
            // apply the modifications on to the action
            Binder<TillageAction, TillageAction> binder = BinderFactory.newBinder(TillageAction.class);
            binder.copyExcluding((TillageAction) action, (TillageAction) originalAction,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof MineralFertilizersSpreadingAction) {
            MineralFertilizersSpreadingAction mineralFertilizersSpreadingAction = (MineralFertilizersSpreadingAction) action;
            // apply the modifications on to the action
            Binder<MineralFertilizersSpreadingAction, MineralFertilizersSpreadingAction> binder = BinderFactory.newBinder(MineralFertilizersSpreadingAction.class);

            // apply the modifications on to the action
            binder.copyExcluding(mineralFertilizersSpreadingAction, (MineralFertilizersSpreadingAction) originalAction,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_ID,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof OrganicFertilizersSpreadingAction) {
            OrganicFertilizersSpreadingAction organicFertilizersSpreadingAction = (OrganicFertilizersSpreadingAction) action;
            // apply the modifications on to the action
            Binder<OrganicFertilizersSpreadingAction, OrganicFertilizersSpreadingAction> binder = BinderFactory.newBinder(OrganicFertilizersSpreadingAction.class);

            // apply the modifications on to the action
            binder.copyExcluding(organicFertilizersSpreadingAction, (OrganicFertilizersSpreadingAction) originalAction,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_ID,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof MaintenancePruningVinesAction) {
            // apply the modifications on to the action
            Binder<MaintenancePruningVinesAction, MaintenancePruningVinesAction> binder = BinderFactory.newBinder(MaintenancePruningVinesAction.class);
            binder.copyExcluding((MaintenancePruningVinesAction) action, (MaintenancePruningVinesAction) originalAction,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_ID,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_CREATE_DATE,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof BiologicalControlAction) {
            BiologicalControlAction biologicalControlAction = (BiologicalControlAction) action;
            // apply the modifications on to the action
            Binder<BiologicalControlAction, BiologicalControlAction> binder = BinderFactory.newBinder(BiologicalControlAction.class);

            binder.copyExcluding(biologicalControlAction, (BiologicalControlAction) originalAction,
                    BiologicalControlAction.PROPERTY_TOPIA_ID,
                    BiologicalControlAction.PROPERTY_TOPIA_CREATE_DATE,
                    BiologicalControlAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof PesticidesSpreadingAction) {
            PesticidesSpreadingAction pesticidesSpreadingAction = (PesticidesSpreadingAction) action;
            // apply the modifications on to the action
            Binder<PesticidesSpreadingAction, PesticidesSpreadingAction> binder = BinderFactory.newBinder(PesticidesSpreadingAction.class);

            // apply the modifications on to the action
            binder.copyExcluding(pesticidesSpreadingAction, (PesticidesSpreadingAction) originalAction,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_ID,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else if (originalAction instanceof CarriageAction) {
            CarriageAction carriageAction = (CarriageAction) action;
            // apply the modifications on to the action
            Binder<CarriageAction, CarriageAction> binder = BinderFactory.newBinder(CarriageAction.class);

            // apply the modifications on to the action
            binder.copyExcluding(carriageAction, (CarriageAction) originalAction,
                    CarriageAction.PROPERTY_TOPIA_ID,
                    CarriageAction.PROPERTY_TOPIA_CREATE_DATE,
                    CarriageAction.PROPERTY_TOPIA_VERSION);
            currentAction = abstractActionDao.update(originalAction);
        } else {
            throw new UnsupportedOperationException("Unsupported action type");
        }
        return currentAction;
    }

    protected AbstractAction saveNewAction(Set<String> speciesCodes, AbstractAction action) {
        AbstractAction currentAction;

        currentAction = getClonedAbstractAction(action);
        currentAction.setTopiaId(null);
        if (currentAction instanceof SeedingAction) {
            // valid that action reference species available from intervention
            Collection<SeedingActionSpecies> seedingActionSpecieses = ((SeedingAction) currentAction).getSeedingSpecies();
            List<SeedingActionSpecies> validSeedingActionSpecieses = Lists.newArrayList();
            if (seedingActionSpecieses != null) {
                for (SeedingActionSpecies seedingActionSpeciese : seedingActionSpecieses) {
                    if (speciesCodes.contains(seedingActionSpeciese.getSpeciesCode())){
                        validSeedingActionSpecieses.add(seedingActionSpeciese);
                    }
                }
            }
            ((SeedingAction) currentAction).setSeedingSpecies(validSeedingActionSpecieses);
        }

        currentAction = abstractActionDao.create(currentAction);

        return currentAction;
    }

    protected AbstractAction getOriginalActionIfExists(Map<String, AbstractAction> currentOriginalActionsMap, AbstractAction action) {
        AbstractAction originalAction = null;
        if (StringUtils.isNotBlank(action.getTopiaId()) && !action.getTopiaId().contains(ActionService.NEW_ACTION_PREFIX)) {
            originalAction = currentOriginalActionsMap.remove(action.getTopiaId());
        }
        return originalAction;
    }

    protected void setCropCycleToAction(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention, AbstractAction action) {
        if (practicedIntervention != null) {
            action.setPracticedIntervention(practicedIntervention);
        } else {
            action.setEffectiveIntervention(effectiveIntervention);
        }
    }

    protected String getActionToolsCouplingCode(Collection<String> toolsCouplingCodes, AbstractAction action) {
        String toolsCouplingCode = null;
        if (action.getToolsCouplingCode() != null && toolsCouplingCodes.contains(action.getToolsCouplingCode())) {
            toolsCouplingCode = action.getToolsCouplingCode();
        }
        return toolsCouplingCode;
    }

    protected Collection<String> getCropCycleToolsCouplingCodes(PracticedIntervention practicedIntervention, EffectiveIntervention effectiveIntervention) {
        Collection<String> toolsCouplingCodes;
        if (practicedIntervention != null) {
            toolsCouplingCodes = practicedIntervention.getToolsCouplingCodes();
        } else {
            if (effectiveIntervention.getToolCouplings() != null) {
                List<ToolsCoupling> toolsCouplings = Lists.newArrayList(effectiveIntervention.getToolCouplings());
                toolsCouplingCodes = Lists.transform(toolsCouplings, EffectiveCropCycleService.GET_TOOLS_COUPLING_BY_CODE);
            } else {
                toolsCouplingCodes = Lists.newArrayList();
            }
        }
        return toolsCouplingCodes;
    }

    @Override
    public void duplicatePracticedActions(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedIntervention, PracticedIntervention practicedInterventionClone) {
        Preconditions.checkArgument(practicedIntervention != null);
        Preconditions.checkArgument(practicedInterventionClone != null);

        Collection<AbstractAction> actions = abstractActionDao.forPracticedInterventionEquals(practicedIntervention).findAll();

        for (AbstractAction originalAction : actions) {

            if (isValidateAction(duplicateContext, originalAction)) {
                AbstractAction actionClone = getClonedAbstractAction(originalAction);

                migrateAction(duplicateContext, practicedInterventionClone, originalAction, actionClone);

                // save action
                actionClone = abstractActionDao.create(actionClone);

                // save action in action cache (for input)
                duplicateContext.getActionCache().put(originalAction, actionClone);
            }

        }

        inputService.duplicateInputs(duplicateContext, practicedIntervention, null);
    }

    protected void migrateAction(DuplicateCropCyclesContext duplicateContext, PracticedIntervention practicedInterventionClone, AbstractAction originalAction, AbstractAction actionClone) {
        if (!duplicateContext.getToolsCouplingsCode().contains(originalAction.getToolsCouplingCode())) {
            actionClone.setToolsCouplingCode(null);
        }
        actionClone.setPracticedIntervention(practicedInterventionClone);
        actionClone.setTopiaId(null);
    }

    protected Boolean isValidateAction(DuplicateCropCyclesContext duplicateContext, AbstractAction originalAction) {
        Boolean isValidAction = true;
        if (originalAction instanceof SeedingAction) {
            SeedingAction seedingAction = (SeedingAction) originalAction;
            Collection<SeedingActionSpecies> seedingSpeciesActions = seedingAction.getSeedingSpecies();

            if (seedingSpeciesActions != null) {
                Pair<CroppingPlanEntry, Map<String, CroppingPlanSpecies>> pair = duplicateContext.getSpeciesByCropCode().get(duplicateContext.getTargetedCropCode());
                if (pair != null) {
                    Map<String, CroppingPlanSpecies> speciesByCode = pair.getValue();
                    for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {

                        if (speciesByCode == null || !speciesByCode.containsKey(seedingSpeciesAction.getSpeciesCode())) {
                            isValidAction = false;
                        }
                    }
                }
            }
        }
        return isValidAction;
    }

    @Override
    public AbstractAction getClonedAbstractAction(AbstractAction originalAction) {
        AbstractAction actionClone;

        if (originalAction instanceof HarvestingAction) {
            HarvestingAction harvestingAction = (HarvestingAction) originalAction;
            actionClone = harvestingActionDao.newInstance();
            Collection<HarvestingYeald> originalHarvestingYealds = harvestingAction.getHarvestingYealds();
            if (originalHarvestingYealds != null) {
                for (HarvestingYeald harvestingYeald : originalHarvestingYealds) {
                    HarvestingYeald harvestingYealdClone = harvestingYealdDao.newInstance();
                    Binder<HarvestingYeald, HarvestingYeald> binder = BinderFactory.newBinder(HarvestingYeald.class);
                    binder.copyExcluding(harvestingYeald, harvestingYealdClone,
                            HarvestingAction.PROPERTY_TOPIA_ID,
                            HarvestingAction.PROPERTY_TOPIA_CREATE_DATE,
                            HarvestingAction.PROPERTY_TOPIA_VERSION);
                    ((HarvestingAction)actionClone).addHarvestingYealds(harvestingYealdClone);
                }
            }

            // apply the modifications on to the action
            Binder<HarvestingAction, HarvestingAction> binder = BinderFactory.newBinder(HarvestingAction.class);
            binder.copyExcluding(harvestingAction, (HarvestingAction)actionClone,
                    HarvestingAction.PROPERTY_TOPIA_ID,
                    HarvestingAction.PROPERTY_TOPIA_CREATE_DATE,
                    HarvestingAction.PROPERTY_TOPIA_VERSION,
                    HarvestingAction.PROPERTY_HARVESTING_YEALDS);
        }

        // In case of SeedingAction we manage it's collection elements.
        else if (originalAction instanceof SeedingAction) {
            SeedingAction seedingAction = (SeedingAction) originalAction;
            actionClone = seedingActionDao.newInstance();
            Collection<SeedingActionSpecies> seedingSpeciesActions = seedingAction.getSeedingSpecies();

            if (seedingSpeciesActions != null) {
                for (SeedingActionSpecies seedingSpeciesAction : seedingSpeciesActions) {
                    SeedingActionSpecies seedingActionSpeciesClone = seedingActionSpeciesDao.newInstance();
                    Binder<SeedingActionSpecies, SeedingActionSpecies> binder = BinderFactory.newBinder(SeedingActionSpecies.class);
                    binder.copyExcluding(seedingSpeciesAction, seedingActionSpeciesClone,
                            SeedingActionSpecies.PROPERTY_TOPIA_ID,
                            SeedingActionSpecies.PROPERTY_TOPIA_CREATE_DATE,
                            SeedingActionSpecies.PROPERTY_TOPIA_VERSION);
                    ((SeedingAction)actionClone).addSeedingSpecies(seedingActionSpeciesClone);
                }
            }

            Binder<SeedingAction, SeedingAction> binder = BinderFactory.newBinder(SeedingAction.class);
            binder.copyExcluding(seedingAction, (SeedingAction) actionClone,
                    SeedingAction.PROPERTY_TOPIA_ID,
                    SeedingAction.PROPERTY_TOPIA_CREATE_DATE,
                    SeedingAction.PROPERTY_TOPIA_VERSION,
                    SeedingAction.PROPERTY_SEEDING_SPECIES);

        } else if (originalAction instanceof OtherAction) {
            actionClone = otherActionDao.newInstance();

            Binder<OtherAction, OtherAction> binder = BinderFactory.newBinder(OtherAction.class);
            binder.copyExcluding((OtherAction)originalAction, (OtherAction) actionClone,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof IrrigationAction) {
            actionClone = irrigationActionDao.newInstance();

            Binder<IrrigationAction, IrrigationAction> binder = BinderFactory.newBinder(IrrigationAction.class);
            binder.copyExcluding((IrrigationAction) originalAction, (IrrigationAction) actionClone,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof TillageAction) {
            actionClone = tillageActionDao.newInstance();

            Binder<TillageAction, TillageAction> binder = BinderFactory.newBinder(TillageAction.class);
            binder.copyExcluding((TillageAction) originalAction, (TillageAction) actionClone,
                    AbstractAction.PROPERTY_TOPIA_ID,
                    AbstractAction.PROPERTY_TOPIA_CREATE_DATE,
                    AbstractAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof MineralFertilizersSpreadingAction) {
            actionClone = mineralFertilizersSpreadingActionDao.newInstance();

            Binder<MineralFertilizersSpreadingAction, MineralFertilizersSpreadingAction> binder = BinderFactory.newBinder(MineralFertilizersSpreadingAction.class);
            binder.copyExcluding((MineralFertilizersSpreadingAction)originalAction, (MineralFertilizersSpreadingAction) actionClone,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_ID,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    MineralFertilizersSpreadingAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof OrganicFertilizersSpreadingAction) {
            actionClone = organicFertilizersSpreadingActionDao.newInstance();

            Binder<OrganicFertilizersSpreadingAction, OrganicFertilizersSpreadingAction> binder = BinderFactory.newBinder(OrganicFertilizersSpreadingAction.class);
            binder.copyExcluding((OrganicFertilizersSpreadingAction)originalAction, (OrganicFertilizersSpreadingAction) actionClone,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_ID,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    OrganicFertilizersSpreadingAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof MaintenancePruningVinesAction) {
            actionClone = maintenancePruningVinesActionDao.newInstance();

            Binder<MaintenancePruningVinesAction, MaintenancePruningVinesAction> binder = BinderFactory.newBinder(MaintenancePruningVinesAction.class);
            binder.copyExcluding((MaintenancePruningVinesAction)originalAction, (MaintenancePruningVinesAction) actionClone,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_ID,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_CREATE_DATE,
                    MaintenancePruningVinesAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof BiologicalControlAction) {
            actionClone = biologicalControlActionDao.newInstance();

            Binder<BiologicalControlAction, BiologicalControlAction> binder = BinderFactory.newBinder(BiologicalControlAction.class);
            binder.copyExcluding((BiologicalControlAction)originalAction, (BiologicalControlAction) actionClone,
                    BiologicalControlAction.PROPERTY_TOPIA_ID,
                    BiologicalControlAction.PROPERTY_TOPIA_CREATE_DATE,
                    BiologicalControlAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof PesticidesSpreadingAction) {
            actionClone = pesticidesSpreadingActionDao.newInstance();

            Binder<PesticidesSpreadingAction, PesticidesSpreadingAction> binder = BinderFactory.newBinder(PesticidesSpreadingAction.class);
            binder.copyExcluding((PesticidesSpreadingAction) originalAction, (PesticidesSpreadingAction) actionClone,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_ID,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_CREATE_DATE,
                    PesticidesSpreadingAction.PROPERTY_TOPIA_VERSION);

        } else if (originalAction instanceof CarriageAction) {
            actionClone = carriageActionDao.newInstance();

            Binder<CarriageAction, CarriageAction> binder = BinderFactory.newBinder(CarriageAction.class);
            binder.copyExcluding((CarriageAction) originalAction, (CarriageAction) actionClone,
                    CarriageAction.PROPERTY_TOPIA_ID,
                    CarriageAction.PROPERTY_TOPIA_CREATE_DATE,
                    CarriageAction.PROPERTY_TOPIA_VERSION);
        } else {
            throw new UnsupportedOperationException("Unsupported action type");
        }

        actionClone.setTopiaId(NEW_ACTION_PREFIX + UUID.randomUUID());
        return actionClone;
    }

    @Override
    public void migrateActionsSpeciesToTargetedSpecies(Collection<AbstractAction> actions,
                                                       Map<String, CroppingPlanSpecies> speciesByCode,
                                                       Map<String, String> fromSpeciesCodeToSpeciesCode) {
        for (AbstractAction action : actions) {
            if (action instanceof SeedingAction) {
                Collection<SeedingActionSpecies> seedingActionSpecieses = ((SeedingAction) action).getSeedingSpecies();
                if (seedingActionSpecieses != null) {
                    // only add the seeding action species that match the targeted species
                    List<SeedingActionSpecies> newSeedingActionSpecies = Lists.newArrayList();
                    for (SeedingActionSpecies seedingActionSpecies : seedingActionSpecieses) {

                        // first try to find according species code but if code does not match
                        // try find using refEspece matching species
                        CroppingPlanSpecies species = speciesByCode.get(seedingActionSpecies.getSpeciesCode());
                        if (species != null) {
                            newSeedingActionSpecies.add(seedingActionSpecies);
                        } else {
                            String toSpeciesCode = fromSpeciesCodeToSpeciesCode.get(seedingActionSpecies.getSpeciesCode());
                            if (StringUtils.isNotBlank(toSpeciesCode)) {
                                seedingActionSpecies.setSpeciesCode(toSpeciesCode);
                                newSeedingActionSpecies.add(seedingActionSpecies);
                            }
                        }
                    }
                    ((SeedingAction) action).setSeedingSpecies(newSeedingActionSpecies);
                }
            }
        }
    }
}
