package fr.inra.agrosyst.services;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ServiceContext.java 4069 2014-05-21 13:39:21Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/ServiceContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Date;

import org.nuiton.topia.persistence.TopiaTransaction;

import com.google.gson.Gson;

import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.services.security.SecurityContext;

public interface ServiceContext {

    /**
     * Méthode à utiliser plutôt que new Date() pour une meilleure testabilité
     *
     * @return la date courante
     */
    Date getCurrentDate();

    /**
     * Permet à chaque service d'obtenir la transaction en cours.
     * Cette méthode revient à faire {@link #getTransaction(boolean)})} avec la valeur 'true'
     *
     * @return the currentTransaction
     * @see #getTransaction(boolean)
     */
    TopiaTransaction getTransaction();

    /**
     * Permet à chaque service d'obtenir la transaction en cours
     *
     * @param create indique si il faut créer la transaction si elle n'existe pas
     * @return the currentTransaction
     */
    TopiaTransaction getTransaction(boolean create);

    /**
     * Permet à chaque service d'obtenir un fournisseur de Dao
     *
     * @return l'instance de TopiaDaoSupplier
     */
    AgrosystTopiaDaoSupplier getDaoSupplier();

    /**
     * @return l'instance courante du TopiaPersistenceContext
     */
    AgrosystTopiaPersistenceContext getPersistenceContext();

    /**
     * @param create indique si il faut créer la transaction si elle n'existe pas
     * @return l'instance courante du TopiaPersistenceContext
     */
    AgrosystTopiaPersistenceContext getPersistenceContext(boolean create);

    /**
     * Create new service context from current service context with custom lifecycle.
     * 
     * @return new service context
     */
    ServiceContext newServiceContext();

    /**
     * Close context and release resources.
     */
    void close();

    /**
     * Build new service instance depending on factory implementation.
     *
     * @param clazz service interface
     * @return service implementation
     * @see fr.inra.agrosyst.api.services.ServiceFactory#newService(Class)
     */
    <E extends AgrosystService> E newService(Class<E> clazz);

    /**
     * Build new {@code clazz} instance with inject objects (Service, Config, DAO...)
     *
     * @param clazz implementation class
     * @return clazz instance
     */
    <I> I newInstance(Class<I> clazz);

    /**
     * Let each service get the current configuration
     *
     * @return the AgrosystServiceConfig instance
     */
    AgrosystServiceConfig getConfig();

    /**
     * Returns the current security context. Note : the life cycle of this object is linked to the security context
     * life cycle (request).
     *
     * @return the current security context
     */
    SecurityContext getSecurityContext();

    /**
     * Returns the current security context to operate as specified {@code userId}. Note : the life cycle of this object is linked to the security context
     * life cycle (request).
     *
     * @param userId userId to operate with
     * @return the current security context
     */
    SecurityContext getSecurityContextAsUser(String userId);

    Gson getGson();

}
