package fr.inra.agrosyst.services;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AgrosystConfigurationHelper.java 4288 2014-09-04 07:54:26Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/services/AgrosystConfigurationHelper.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;
import java.util.Properties;

import com.google.common.base.Function;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;

import org.nuiton.topia.flyway.TopiaFlywayService;
import org.nuiton.topia.flyway.TopiaFlywayServiceImpl;
import org.nuiton.topia.persistence.TopiaConfigurationConstants;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class AgrosystConfigurationHelper {

    public static Function<Properties, AgrosystTopiaApplicationContext> getCreateTopiaContextFunction(final AgrosystServiceConfig config) {
        return new Function<Properties, AgrosystTopiaApplicationContext>() {
            @Override
            public AgrosystTopiaApplicationContext apply(Properties input) {
                AgrosystTopiaApplicationContext result = new AgrosystTopiaApplicationContext(config, input);
                return result;
            }
        };
    }

    public static Properties getRootContextProperties(AgrosystServiceConfig serviceConfig) {
        Properties result = serviceConfig.getFlatOptions();
        // add persistence classes from generated code
        result.setProperty(TopiaConfigurationConstants.CONFIG_PERSISTENCE_CLASSES, AgrosystEntityEnum.getImplementationClassesAsString());
        // Flyway migration service has been setup during 1.1 development (latest stable was 1.0.6)
        Map<String, String> toAddIfNotPresent = Maps.newLinkedHashMap();
        toAddIfNotPresent.put("topia.service.migration", TopiaFlywayServiceImpl.class.getName());
        toAddIfNotPresent.put("topia.service.migration." + TopiaFlywayService.USE_MODEL_VERSION, "false");
        toAddIfNotPresent.put(TopiaConfigurationConstants.CONFIG_PERSISTENCE_INIT_SCHEMA, "true");

        for (Map.Entry<String, String> entry : toAddIfNotPresent.entrySet()) {
            if (!result.containsKey(entry.getKey())) {
                result.setProperty(entry.getKey(), entry.getValue());
            }
        }

        return result;
    }

}
