package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: UserRoleTopiaDao.java 3409 2014-02-21 23:42:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/security/UserRoleTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class UserRoleTopiaDao extends AbstractUserRoleTopiaDao<UserRole> {

    protected static final String ROLE_USER_ID = UserRole.PROPERTY_AGROSYST_USER + "." + AgrosystUser.PROPERTY_TOPIA_ID;

    public UserRole findRole(String userId, RoleType roleType) {
        UserRole role = forProperties(
                ROLE_USER_ID, userId,
                UserRole.PROPERTY_TYPE, roleType).findAnyOrNull();
        return role;
    }

    public UserRole findNetworkResponsibleRole(String userId) {
        UserRole role = forProperties(
                ROLE_USER_ID, userId,
                UserRole.PROPERTY_TYPE, RoleType.NETWORK_RESPONSIBLE).findAnyOrNull();
        return role;
    }

    public List<UserRole> findAllForUserId(String userId) {
        List<UserRole> role = forProperties(
                ROLE_USER_ID, userId).findAll();
        return role;
    }

    public List<AgrosystUser> findAllRoleUsers(RoleType roleType, String propCode, String code) {

        String hql = " SELECT ur." + UserRole.PROPERTY_AGROSYST_USER +
                " FROM " + UserRole.class.getName() + " ur " +
                " WHERE 1=1 ";
        Map<String, Object> args = DaoUtils.asArgsMap();
        hql += DaoUtils.andAttributeEquals("ur", UserRole.PROPERTY_TYPE, args, roleType);
        hql += DaoUtils.andAttributeEquals("ur", propCode, args, code);
        String query = hql + " ORDER BY " +
                "ur." + UserRole.PROPERTY_AGROSYST_USER + "." + AgrosystUser.PROPERTY_FIRST_NAME + " ASC, " +
                "ur." + UserRole.PROPERTY_AGROSYST_USER + "." + AgrosystUser.PROPERTY_LAST_NAME + " ASC ";
        List<AgrosystUser> result = findAll(query, args);
        return result;
    }

} //UserRoleTopiaDao<E extends UserRole>
