package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: StoredTokenTopiaDao.java 3245 2014-02-14 14:24:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/security/StoredTokenTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class StoredTokenTopiaDao extends AbstractStoredTokenTopiaDao<StoredToken> {

    public long getConnectedUserCount(Date currentDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(currentDate);
        instance.add(Calendar.HOUR, -24);
        Date oneDayAgo = instance.getTime();

        String hql =
                " SELECT st."+ StoredToken.PROPERTY_USER_ID + ", MAX(st." + StoredToken.PROPERTY_TOPIA_CREATE_DATE + ") " +
                " FROM " + getEntityClass().getName() + " st " +
                " GROUP BY st." + StoredToken.PROPERTY_USER_ID;
        List<Object[]> maxDates = findAll(hql, DaoUtils.asArgsMap());
        Long result = 0L;
        for (Object[] maxDate : maxDates) {
            String userId = (String)maxDate[0];
            Date date = (Date)maxDate[1];

            // Déconnexion auto des utilisateurs connectés depuis plus de 24h
            if (date.before(oneDayAgo)) {
                List<StoredToken> all = forUserIdEquals(userId).findAll();
                deleteAll(all);
            } else {
                result++;
            }
        }
        return result;
    }

} //StoredTokenTopiaDao
