package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: HashedValueTopiaDao.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/security/HashedValueTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class HashedValueTopiaDao extends AbstractHashedValueTopiaDao<HashedValue> {

    public boolean checkValue(String clear, String hashed) {
        String query = " FROM " + getEntityClass().getName() + " hv " +
                " WHERE hv." + HashedValue.PROPERTY_HASHED + " = :hashed ";

        boolean created = false;
        List<HashedValue> values = findAll(query, DaoUtils.asArgsMap("hashed", hashed));
        if (values == null || values.isEmpty()) {
            create(
                    HashedValue.PROPERTY_RAW, clear,
                    HashedValue.PROPERTY_HASHED, hashed);
            created = true;
        }
        return created;
    }

} //HashedValueTopiaDao
