package fr.inra.agrosyst.api.entities.security;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.entities.AttachmentMetadataTopiaDao;
import fr.inra.agrosyst.api.entities.NetworkManager;
import fr.inra.agrosyst.api.entities.NetworkManagerTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedAgrosystUserTopiaDao<E extends AgrosystUser> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AgrosystUser.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.AgrosystUser;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            NetworkManagerTopiaDao dao = topiaDaoSupplier
                    .getDao(NetworkManager.class, NetworkManagerTopiaDao.class);
            List<NetworkManager> list = dao
                    .forProperties(NetworkManager.PROPERTY_AGROSYST_USER, entity)
                    .findAll();
            for (NetworkManager item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAgrosystUser())) {
                    item.setAgrosystUser(null);
                }
            
            }
        }

        {
            UserRoleTopiaDao dao = topiaDaoSupplier
                    .getDao(UserRole.class, UserRoleTopiaDao.class);
            List<UserRole> list = dao
                    .forProperties(UserRole.PROPERTY_AGROSYST_USER, entity)
                    .findAll();
            for (UserRole item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAgrosystUser())) {
                    item.setAgrosystUser(null);
                }
            
            }
        }

        {
            TrackedEventTopiaDao dao = topiaDaoSupplier
                    .getDao(TrackedEvent.class, TrackedEventTopiaDao.class);
            List<TrackedEvent> list = dao
                    .forProperties(TrackedEvent.PROPERTY_AUTHOR, entity)
                    .findAll();
            for (TrackedEvent item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAuthor())) {
                    item.setAuthor(null);
                }
            
            }
        }

        {
            AttachmentMetadataTopiaDao dao = topiaDaoSupplier
                    .getDao(AttachmentMetadata.class, AttachmentMetadataTopiaDao.class);
            List<AttachmentMetadata> list = dao
                    .forProperties(AttachmentMetadata.PROPERTY_AUTHOR, entity)
                    .findAll();
            for (AttachmentMetadata item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAuthor())) {
                    item.setAuthor(null);
                }
            
            }
        }

        {
            PerformanceTopiaDao dao = topiaDaoSupplier
                    .getDao(Performance.class, PerformanceTopiaDao.class);
            List<Performance> list = dao
                    .forProperties(Performance.PROPERTY_AUTHOR, entity)
                    .findAll();
            for (Performance item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAuthor())) {
                    item.setAuthor(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String email) {
        return forNaturalId(email).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String email) {
        return forNaturalId(email).exists();
    }

    public E createByNaturalId(String email) {
        return create(AgrosystUser.PROPERTY_EMAIL, email);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String email) {
        return forProperties(AgrosystUser.PROPERTY_EMAIL, email);
    }

    public E createByNotNull(String email, String lastName, String firstName, String password) {
        return create(AgrosystUser.PROPERTY_EMAIL, email, AgrosystUser.PROPERTY_LAST_NAME, lastName, AgrosystUser.PROPERTY_FIRST_NAME, firstName, AgrosystUser.PROPERTY_PASSWORD, password);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_EMAIL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_EMAIL, v);
        return result;
    }

    @Deprecated
    public E findByEmail(String v) {
        return forEmailEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmail(String v) {
        return forEmailEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_LAST_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_LAST_NAME, v);
        return result;
    }

    @Deprecated
    public E findByLastName(String v) {
        return forLastNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastName(String v) {
        return forLastNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_FIRST_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_FIRST_NAME, v);
        return result;
    }

    @Deprecated
    public E findByFirstName(String v) {
        return forFirstNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFirstName(String v) {
        return forFirstNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_PASSWORD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_PASSWORD, v);
        return result;
    }

    @Deprecated
    public E findByPassword(String v) {
        return forPasswordEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPassword(String v) {
        return forPasswordEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhoneNumberIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_PHONE_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhoneNumberEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_PHONE_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByPhoneNumber(String v) {
        return forPhoneNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPhoneNumber(String v) {
        return forPhoneNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganisationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_ORGANISATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganisationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_ORGANISATION, v);
        return result;
    }

    @Deprecated
    public E findByOrganisation(String v) {
        return forOrganisationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganisation(String v) {
        return forOrganisationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBannerIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_BANNER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forBannerEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_BANNER, v);
        return result;
    }

    @Deprecated
    public E findByBanner(String v) {
        return forBannerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByBanner(String v) {
        return forBannerEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReminderTokenIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_REMINDER_TOKEN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReminderTokenEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_REMINDER_TOKEN, v);
        return result;
    }

    @Deprecated
    public E findByReminderToken(String v) {
        return forReminderTokenEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReminderToken(String v) {
        return forReminderTokenEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCharterVersionIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_CHARTER_VERSION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCharterVersionEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_CHARTER_VERSION, v);
        return result;
    }

    @Deprecated
    public E findByCharterVersion(Integer v) {
        return forCharterVersionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCharterVersion(Integer v) {
        return forCharterVersionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastMessageReadDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AgrosystUser.PROPERTY_LAST_MESSAGE_READ_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLastMessageReadDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AgrosystUser.PROPERTY_LAST_MESSAGE_READ_DATE, v);
        return result;
    }

    @Deprecated
    public E findByLastMessageReadDate(Date v) {
        return forLastMessageReadDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLastMessageReadDate(Date v) {
        return forLastMessageReadDateEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == UserRole.class) {
            UserRoleTopiaDao dao =
                topiaDaoSupplier.getDao(UserRole.class, UserRoleTopiaDao.class);
            tmp = dao.forAgrosystUserEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == NetworkManager.class) {
            NetworkManagerTopiaDao dao =
                topiaDaoSupplier.getDao(NetworkManager.class, NetworkManagerTopiaDao.class);
            tmp = dao.forAgrosystUserEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == AttachmentMetadata.class) {
            AttachmentMetadataTopiaDao dao =
                topiaDaoSupplier.getDao(AttachmentMetadata.class, AttachmentMetadataTopiaDao.class);
            tmp = dao.forAuthorEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == TrackedEvent.class) {
            TrackedEventTopiaDao dao =
                topiaDaoSupplier.getDao(TrackedEvent.class, TrackedEventTopiaDao.class);
            tmp = dao.forAuthorEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Performance.class) {
            PerformanceTopiaDao dao =
                topiaDaoSupplier.getDao(Performance.class, PerformanceTopiaDao.class);
            tmp = dao.forAuthorEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(5);

        List<? extends TopiaEntity> list;

        list = findUsages(UserRole.class, entity);
        if (!list.isEmpty()) {
            result.put(UserRole.class, list);
        }

        list = findUsages(NetworkManager.class, entity);
        if (!list.isEmpty()) {
            result.put(NetworkManager.class, list);
        }

        list = findUsages(AttachmentMetadata.class, entity);
        if (!list.isEmpty()) {
            result.put(AttachmentMetadata.class, list);
        }

        list = findUsages(TrackedEvent.class, entity);
        if (!list.isEmpty()) {
            result.put(TrackedEvent.class, list);
        }

        list = findUsages(Performance.class, entity);
        if (!list.isEmpty()) {
            result.put(Performance.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAgrosystUserTopiaDao<E extends AgrosystUser>
