package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: ComputedUserPermissionTopiaDao.java 4318 2014-09-10 15:57:14Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/security/ComputedUserPermissionTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.google.common.base.MoreObjects;

import fr.inra.agrosyst.api.utils.DaoUtils;
import fr.inra.agrosyst.services.security.SecurityHelper;

public class ComputedUserPermissionTopiaDao extends AbstractComputedUserPermissionTopiaDao<ComputedUserPermission> {

    public long getUsersPermissionCount(String userId) {
        String hql = "SELECT COUNT(cup." + ComputedUserPermission.PROPERTY_TOPIA_ID + ")" +
                " FROM " + getEntityClass().getName() + " cup" +
                " WHERE cup." + ComputedUserPermission.PROPERTY_USER_ID + " = :userId";
        long result = count(hql, DaoUtils.asArgsMap("userId", userId));
        return result;
    }

    public long getUsersDirtyCount(String userId) {
        String hql = "SELECT COUNT(cup." + ComputedUserPermission.PROPERTY_TOPIA_ID + ")" +
                " FROM " + getEntityClass().getName() + " cup" +
                " WHERE cup." + ComputedUserPermission.PROPERTY_USER_ID + " = :userId" +
                " AND cup." + ComputedUserPermission.PROPERTY_DIRTY + " = :dirty";
        long result = count(hql, DaoUtils.asArgsMap("userId", userId, "dirty", true));
        return result;
    }

    public int getMaxAction(String userId, String object, PermissionObjectType type) {

        String hql = "SELECT MAX(cup." + ComputedUserPermission.PROPERTY_ACTION+ ")" +
                " FROM " + getEntityClass().getName() + " cup" +
                " WHERE cup." + ComputedUserPermission.PROPERTY_USER_ID + " = :userId" +
                " AND cup." + ComputedUserPermission.PROPERTY_OBJECT + " = :obj";
        Map<String,Object> argsMap = DaoUtils.asArgsMap("userId", userId, "obj", object);

        hql += DaoUtils.andAttributeEquals("cup", ComputedUserPermission.PROPERTY_TYPE, argsMap, type);

        Integer result = findAnyOrNull(hql, argsMap);
        return MoreObjects.firstNonNull(result, 0);
    }

    protected ComputedUserPermission newPermission(String userId, PermissionObjectType type, String object, int action) {
        ComputedUserPermission result = newInstance();
        result.setUserId(userId);
        result.setType(type);
        result.setObject(object);
        result.setAction(action);
        result.setDirty(false);
        return result;
    }

    protected ComputedUserPermission newReadValidatedPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = newPermission(userId, type, object, SecurityHelper.PERMISSION_READ_VALIDATED);
        return result;
    }

    protected ComputedUserPermission newReadPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = newPermission(userId, type, object, SecurityHelper.PERMISSION_READ_RAW);
        return result;
    }

    protected ComputedUserPermission newWritePermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = newPermission(userId, type, object, SecurityHelper.PERMISSION_WRITE);
        return result;
    }

    protected ComputedUserPermission newAdminPermission(String userId, PermissionObjectType type, String object) {
        ComputedUserPermission result = newPermission(userId, type, object, SecurityHelper.PERMISSION_ADMIN);
        return result;
    }

    public ComputedUserPermission newDomainAdminPermission(String userId, String domainCode) {
        ComputedUserPermission result = newAdminPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newDomainReadPermission(String userId, String domainCode) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newDomainReadValidatedPermission(String userId, String domainCode) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.DOMAIN_CODE, domainCode);
        return result;
    }

    public ComputedUserPermission newSpecificDomainReadPermission(String userId, String domainId) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.DOMAIN_ID, domainId);
        return result;
    }

    public ComputedUserPermission newSpecificDomainReadValidatedPermission(String userId, String domainId) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.DOMAIN_ID, domainId);
        return result;
    }

    public ComputedUserPermission newGrowingPlanAdminPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = newAdminPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newGrowingPlanReadPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newGrowingPlanReadValidatedPermission(String userId, String growingPlanCode) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.GROWING_PLAN_CODE, growingPlanCode);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingPlanReadPermission(String userId, String growingPlanId) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingPlanReadValidatedPermission(String userId, String growingPlanId) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.GROWING_PLAN_ID, growingPlanId);
        return result;
    }

    public ComputedUserPermission newNetworkAdminPermission(String userId, String networkId) {
        ComputedUserPermission result = newAdminPermission(userId, PermissionObjectType.NETWORK_ID, networkId);
        return result;
    }

    public ComputedUserPermission newGrowingSystemReadValidatedPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newGrowingSystemReadPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newGrowingSystemAdminPermission(String userId, String growingSystemCode) {
        ComputedUserPermission result = newAdminPermission(userId, PermissionObjectType.GROWING_SYSTEM_CODE, growingSystemCode);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingSystemReadPermission(String userId, String growingSystemId) {
        ComputedUserPermission result = newReadPermission(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        return result;
    }

    public ComputedUserPermission newSpecificGrowingSystemReadValidatedPermission(String userId, String growingSystemId) {
        ComputedUserPermission result = newReadValidatedPermission(userId, PermissionObjectType.GROWING_SYSTEM_ID, growingSystemId);
        return result;
    }

} //ComputedUserPermissionTopiaDao<E extends ComputedUserPermission>
