package fr.inra.agrosyst.api.entities.security;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AgrosystUserTopiaDao.java 3346 2014-02-19 17:28:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/security/AgrosystUserTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.PagerBean;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class AgrosystUserTopiaDao extends AbstractAgrosystUserTopiaDao<AgrosystUser> {

    public ResultList<AgrosystUser> getFilteredUsers(UserFilter filter) {
        String query = "FROM " + getEntityClass().getName() + " u ";
        query += " WHERE 1 = 1";
        Map<String, Object> args = Maps.newLinkedHashMap();

        // apply non null filter
        if (filter != null) {

            // first name
            query += DaoUtils.andAttributeLike("u", AgrosystUser.PROPERTY_FIRST_NAME, args, filter.getFirstName());

            // last name
            query += DaoUtils.andAttributeLike("u", AgrosystUser.PROPERTY_LAST_NAME, args, filter.getLastName());

            // email
            query += DaoUtils.andAttributeLike("u", AgrosystUser.PROPERTY_EMAIL, args, filter.getEmail());

            // organisation
            query += DaoUtils.andAttributeLike("u", AgrosystUser.PROPERTY_ORGANISATION, args, filter.getOrganisation());

            if (filter.getRoleType() != null) {
                String subQuery = " SELECT DISTINCT ur." + UserRole.PROPERTY_AGROSYST_USER + " FROM " + UserRole.class.getName() + " ur ";
                subQuery += " WHERE 1=1 ";
                subQuery += DaoUtils.andAttributeEquals("ur", UserRole.PROPERTY_TYPE, args, filter.getRoleType());

                query += " AND u IN ( " + subQuery + " ) ";
            }

            // active
            query += DaoUtils.andAttributeEquals("u", AgrosystUser.PROPERTY_ACTIVE, args, filter.getActive());

        }

        int page = filter != null ? filter.getPage() : 0;
        int count = filter != null ? filter.getPageSize() : 10;
        int startIndex = page * count;
        int endIndex = page * count + count - 1;
        List<AgrosystUser> users = find(query + " ORDER BY lower (u." + AgrosystUser.PROPERTY_LAST_NAME + "), u." + AgrosystUser.PROPERTY_FIRST_NAME, args, startIndex, endIndex);
        long totalCount = findUnique("SELECT count(*) " + query, args);

        // build result bean
        PagerBean pager = DaoUtils.getPager(page, count, totalCount);
        ResultList<AgrosystUser> result = ResultList.of(users, pager);
        return result;
    }
    
    public List<AgrosystUser> getNameFilteredActiveUsers(String name, Integer size) {
        String query = "FROM " + getEntityClass().getName() + " U";
        query += " WHERE 1 = 0";
        Map<String, Object> args = Maps.newLinkedHashMap();
        if (!StringUtils.isBlank(name)){

            // Prénom
            query += DaoUtils.orAttributeLike("U", AgrosystUser.PROPERTY_FIRST_NAME, args, name);

            // Nom
            query += DaoUtils.orAttributeLike("U", AgrosystUser.PROPERTY_LAST_NAME, args, name);
            
            // active
            query += DaoUtils.andAttributeEquals("U", AgrosystUser.PROPERTY_ACTIVE, args, true);
        }
        int nbResult = size != null ? size : 10;
        List<AgrosystUser> users = find(query + " ORDER BY lower (U." + AgrosystUser.PROPERTY_LAST_NAME + "), U." + AgrosystUser.PROPERTY_FIRST_NAME, args, 0, nbResult);
        return users;
    }

} //AgrosystUserTopiaDao<E extends User>
