package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefVarietePlantGrapeTopiaDao.java 4671 2014-12-17 15:44:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefVarietePlantGrapeTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;
import org.apache.commons.lang3.StringUtils;

public class RefVarietePlantGrapeTopiaDao extends AbstractRefVarietePlantGrapeTopiaDao<RefVarietePlantGrape> {

    public List<RefVarietePlantGrape> findAllVarietes(Set<String> varietesPlantGrapeIds, String filter, int maxResults) {
        List<RefVarietePlantGrape> result = Lists.newArrayList();
        
        // La requete doit retourner tout le référentiel seulement si la liste d'id n'est pas vide
        // dans ce cas, il contient même seulement "ZMO"
        if (varietesPlantGrapeIds != null && !varietesPlantGrapeIds.isEmpty()) {

            String query = "FROM " + RefVarietePlantGrape.class.getName() + " vpg ";
            query += " WHERE 1 = 1 ";
            Map<String, Object> args = Maps.newLinkedHashMap();

            // denomination
            query += DaoUtils.andAttributeLike("vpg", RefVarietePlantGrape.PROPERTY_VARIETE, args, filter);

            // active
            query += DaoUtils.andAttributeEquals("vpg", RefVarietePlantGrape.PROPERTY_ACTIVE, args, true);

            query += " ORDER BY vpg." + RefVarietePlantGrape.PROPERTY_VARIETE;

            List<RefVarietePlantGrape> entities = find(query, args, 0, maxResults - 1);
            if (entities != null) {
                result.addAll(entities);
            }
        }
        return result;
    }

    public List<RefVarietePlantGrape> findGraftSupport(String filter, String utilisation, int maxResults) {
        String query = "FROM " + RefVarietePlantGrape.class.getName() + " vpg ";
        query += " WHERE 1 = 1 ";
        
        Map<String, Object> args = Maps.newLinkedHashMap();
        
        query += DaoUtils.andAttributeEquals("vpg", RefVarietePlantGrape.PROPERTY_UTILISATION, args, utilisation);
        if (StringUtils.isNotBlank(filter)) {
            query += DaoUtils.andAttributeLike("vpg", RefVarietePlantGrape.PROPERTY_VARIETE, args, filter);
        }

        // active
        query += DaoUtils.andAttributeEquals("vpg", RefVarietePlantGrape.PROPERTY_ACTIVE, args, true);

        query += " ORDER BY vpg." + RefVarietePlantGrape.PROPERTY_VARIETE;

        List<RefVarietePlantGrape> result = find(query, args, 0, maxResults - 1);
        return result;
    }

} //RefVarietePlantGrapeTopiaDao<E extends RefVarietePlantGrape>
