package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefVarieteGevesTopiaDao.java 4329 2014-09-12 15:14:03Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefVarieteGevesTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefVarieteGevesTopiaDao extends AbstractRefVarieteGevesTopiaDao<RefVarieteGeves> {

    public List<RefVarieteGeves> findAllActiveVarietes(Set<Integer> varietesGevesIds, String filter, int maxResults) {
        List<RefVarieteGeves> result = Lists.newArrayList();
        if (varietesGevesIds != null && !varietesGevesIds.isEmpty()) {

            String query = "FROM " + RefVarieteGeves.class.getName() + " vg";
            query += " WHERE vg." + RefVarieteGeves.PROPERTY_ACTIVE + " = true";
            Map<String, Object> args = Maps.newLinkedHashMap();

            // num espece
            query += DaoUtils.andAttributeIn("vg", RefVarieteGeves.PROPERTY_NUM__ESPECE__BOTANIQUE, args, varietesGevesIds);

            // denomination
            query += DaoUtils.andAttributeLike("vg", RefVarieteGeves.PROPERTY_DENOMINATION, args, filter);

            query += " ORDER BY vg." + RefVarieteGeves.PROPERTY_DENOMINATION;

            List<RefVarieteGeves> entities = find(query, args, 0, maxResults - 1);
            if (entities != null) {
                result.addAll(entities);
            }
        }
        return result;
    }

    public List<RefVarieteGeves> findActiveGraftSupport(String filter, int codeSection, int maxResults) {
        String query = "FROM " + RefVarieteGeves.class.getName() + " vg";
        query += " WHERE vg." + RefVarieteGeves.PROPERTY_ACTIVE + " = true";

        Map<String, Object> args = Maps.newLinkedHashMap();

        query += DaoUtils.andAttributeEquals("vg", RefVarieteGeves.PROPERTY_CODE__SECTION, args, codeSection);
        query += DaoUtils.andAttributeLike("vg", RefVarieteGeves.PROPERTY_DENOMINATION, args, filter);

        query += " ORDER BY vg." + RefVarieteGeves.PROPERTY_DENOMINATION;

        List<RefVarieteGeves> result = find(query, args, 0, maxResults - 1);
        return result;
    }

} //RefVarieteGevesTopiaDao<E extends RefVarieteGeves>
