package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefSolArvalisTopiaDao.java 4006 2014-04-15 12:41:37Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefSolArvalisTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.utils.DaoUtils;

import java.util.List;
import java.util.Map;

/**
 * Custom doa methods related to {@link RefSolArvalis}.
 * 
 * @author Eric Chatellier
 */
public class RefSolArvalisTopiaDao extends AbstractRefSolArvalisTopiaDao<RefSolArvalis> {

    /**
     * Return all sol_region attributes value ordered alphabetically.
     * 
     * @return all sol_region
     */
    public Map<Integer, String> getAllSolArvalisRegions() {
        String query = "SELECT distinct " + RefSolArvalis.PROPERTY_SOL_REGION_CODE + "," + RefSolArvalis.PROPERTY_SOL_REGION + 
                " FROM " + getEntityClass().getName() +
                " WHERE " + RefSolArvalis.PROPERTY_ACTIVE + " = :active " +
                " ORDER BY " + RefSolArvalis.PROPERTY_SOL_REGION;

        Map<String, Object> args = DaoUtils.asArgsMap("active", true);
        List<Object[]> list = findAll(query, args);

        Map<Integer, String> result = Maps.newLinkedHashMap();
        for (Object[] entry : list) {
            result.put((Integer)entry[0], (String)entry[1]);
        }
        return result;
    }

    /**
     * Look for RefSolArvalis in a specific region.
     * 
     * @param regionCode region codes
     * @return RefSolArvalis for requested region
     */
    public List<RefSolArvalis> findAllForRegion(int regionCode) {
        String query = " FROM " + getEntityClass().getName() + " sa " +
                " WHERE sa." + RefSolArvalis.PROPERTY_SOL_REGION_CODE + " = :argCode" +
                " AND sa." + RefSolArvalis.PROPERTY_ACTIVE + " = :argActive";

        Map<String, Object> args = DaoUtils.asArgsMap("argCode", regionCode, "argActive", true);
        String hql = query + " ORDER BY sa." + RefSolArvalis.PROPERTY_SOL_NOM + " ASC ";
        List<RefSolArvalis> result = findAll(hql, args);
        return result;
    }

} //RefSolArvalisTopiaDao<E extends RefSolArvalis>
