package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefProtocoleVgObsTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefProtocoleVgObsTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.nuiton.topia.persistence.TopiaException;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.services.measurement.ProtocoleVgObsFilter;

public class RefProtocoleVgObsTopiaDao extends AbstractRefProtocoleVgObsTopiaDao<RefProtocoleVgObs> {

    protected String filterToQuery(ProtocoleVgObsFilter filter, Map<String, Object> args) {
        String query = "";
        if (filter.getLabel() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_PROTOCOLE_LIBELLE + " = :" + RefProtocoleVgObs.PROPERTY_PROTOCOLE_LIBELLE;
            args.put(RefProtocoleVgObs.PROPERTY_PROTOCOLE_LIBELLE, filter.getLabel());
        }
        if (filter.getPest() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT + " = :" + RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT;
            args.put(RefProtocoleVgObs.PROPERTY_LIGNE_ORGANISME_VIVANT, filter.getPest());
        }
        if (filter.getStade() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_LIGNE_STADES_DEVELOPPEMENT + " = :" + RefProtocoleVgObs.PROPERTY_LIGNE_STADES_DEVELOPPEMENT;
            args.put(RefProtocoleVgObs.PROPERTY_LIGNE_STADES_DEVELOPPEMENT, filter.getStade());
        }
        if (filter.getSupport() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_LIGNE_SUPPORTS_ORGANES + " = :" + RefProtocoleVgObs.PROPERTY_LIGNE_SUPPORTS_ORGANES;
            args.put(RefProtocoleVgObs.PROPERTY_LIGNE_SUPPORTS_ORGANES, filter.getSupport());
        }
        if (filter.getObservation() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION + " = :" + RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION;
            args.put(RefProtocoleVgObs.PROPERTY_LIGNE_TYPE_OBSERVATION, filter.getObservation());
        }
        if (filter.getQualitative() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE + " = :" + RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE;
            args.put(RefProtocoleVgObs.PROPERTY_CLASSE_VALEUR_QUALITATIVE, filter.getQualitative());
        }
        if (filter.getUnit() != null) {
            query += " AND " + RefProtocoleVgObs.PROPERTY_RELEVE_UNITE + " = :" + RefProtocoleVgObs.PROPERTY_RELEVE_UNITE;
            args.put(RefProtocoleVgObs.PROPERTY_RELEVE_UNITE, filter.getUnit());
        }
        return query;
    }

    public <T> List<T> findAllProperties(String property, ProtocoleVgObsFilter filter) throws TopiaException {
        String query = "";

        // if no property, return E (all entity)
        if (property != null) {
            query += "SELECT distinct(" + property + ")";
        }

        query += " FROM " + getEntityClass().getName() +
                " WHERE " + RefProtocoleVgObs.PROPERTY_ACTIVE + " = true";

        Map<String, Object> args = Maps.newHashMap();
        if (filter != null) {
            query += filterToQuery(filter, args);
        }

        if (property != null) {
            query += " ORDER BY " + property;
        }

        List<T> result = findAll(query, args);
        return result;
    }
}
