package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefOTEXTopiaDao.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefOTEXTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.utils.DaoUtils;

/**
 * @author cosse
 *
 */
public class RefOTEXTopiaDao extends AbstractRefOTEXTopiaDao<RefOTEX> {

    public Map<Integer, String> findAllActiveCodeOtex70ByOtex18code(Integer otex18code) {
        String query = "SELECT" +
            " ro." + RefOTEX.PROPERTY_CODE__OTEX_70_POSTES + "," + " ro." + RefOTEX.PROPERTY_LIBELLE__OTEX_70_POSTES +
            " FROM " + getEntityClass().getName() + " ro" +
            " where ro." + RefOTEX.PROPERTY_ACTIVE + " = true";

        Map<String, Object> args = Maps.newLinkedHashMap();

        query += DaoUtils.andAttributeEquals("ro", RefOTEX.PROPERTY_CODE__OTEX_18_POSTES, args, otex18code);

        query +=  " ORDER BY ro." + RefOTEX.PROPERTY_CODE__OTEX_70_POSTES;
        
        Map<Integer, String> otexByCodes = Maps.newLinkedHashMap();
        List<Object[]> filterdOtex = findAll(query, args);
        for (Object[] otex : filterdOtex) {
            Integer key = (Integer) otex[0]; 
            String value = otex[0] + " : " + otex[1];
            otexByCodes.put(key,value);
        }
        
        return otexByCodes;
    }
    
    public Map<Integer, String> findAllActiveOtex18Code() {
        Map<Integer, String> otex18ByCodes = Maps.newLinkedHashMap();
        String hql = "SELECT" +
                " ro." + RefOTEX.PROPERTY_CODE__OTEX_18_POSTES + "," + " ro." + RefOTEX.PROPERTY_LIBELLE__OTEX_18_POSTES +
                " FROM " +  getEntityClass().getName() + " ro" +
                " where ro." + RefOTEX.PROPERTY_ACTIVE + " = true" +
                " GROUP BY ro." + RefOTEX.PROPERTY_CODE__OTEX_18_POSTES  + "," + " ro." + RefOTEX.PROPERTY_LIBELLE__OTEX_18_POSTES +
                " ORDER BY ro." + RefOTEX.PROPERTY_CODE__OTEX_18_POSTES;
        
        List<Object[]> otex18s = findAll(hql, DaoUtils.asArgsMap());
        for (Object[] otex18 : otex18s) {
            Integer key = (Integer) otex18[0]; 
            String value = otex18[0] + " : " + otex18[1];
            otex18ByCodes.put(key,value);
        }
        return otex18ByCodes;
    }
}
