package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefNuisibleEDITopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefNuisibleEDITopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefNuisibleEDITopiaDao extends AbstractRefNuisibleEDITopiaDao<RefNuisibleEDI> {

    /**
     * Recherche des types de nuisibles (colonne reference_param) du référentiel
     * NuisiblesEDI, triés par reference_param.
     * 
     * @return types de nuisibles
     */
    public List<BioAgressorType> findAllActiveParam() {
        String query = "SELECT distinct " + RefNuisibleEDI.PROPERTY_REFERENCE_PARAM +
                " FROM " + getEntityClass().getName() +
                " ORDER BY " + RefNuisibleEDI.PROPERTY_REFERENCE_PARAM;
        List<BioAgressorType> result = findAll(query, DaoUtils.asArgsMap());

        return result;
    }
}
