package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefMesureTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefMesureTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.nuiton.topia.persistence.TopiaException;

import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefMesureTopiaDao extends AbstractRefMesureTopiaDao<RefMesure> {

    public List<VariableType> findTypeVariableValues(MeasurementType measurementType) throws TopiaException {
        String query = "SELECT distinct(" + RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE + ")" +
                " FROM " + getEntityClass().getName() +
                " WHERE " + RefMesure.PROPERTY_ACTIVE + " = true" +
                " AND " + RefMesure.PROPERTY_CATEGORIE_DE_MESURE +  " = :measurementType" +
                " ORDER BY " + RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE;

        Map<String,Object> args = DaoUtils.asArgsMap("measurementType", measurementType);
        List<VariableType> result = findAll(query, args);
        return result;
    }
    
    public List<RefMesure> findVariables(MeasurementType measurementType, VariableType variableType) throws TopiaException {
        String query = " FROM " + getEntityClass().getName() +
                " WHERE " + RefMesure.PROPERTY_ACTIVE + " = true" +
                " AND " + RefMesure.PROPERTY_CATEGORIE_DE_MESURE + " = :measurementType";
        
        // TODO check if topia have to handle = null without NPE
        if (variableType != null) {
            query += " AND " + RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE + " = :variableType";
        }
        
        query += " ORDER BY " + RefMesure.PROPERTY_TYPE_VARIABLE_MESUREE;

        List<RefMesure> result;
        if (variableType != null) {
            result = findAll(query, DaoUtils.asArgsMap("measurementType", measurementType, "variableType", variableType));
        } else {
            result = findAll(query, DaoUtils.asArgsMap("measurementType", measurementType));
        }
        return result;
    }
}
