package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefInterventionAgrosystTravailEDITopiaDao.java 3960 2014-04-01 16:59:22Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefInterventionAgrosystTravailEDITopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefInterventionAgrosystTravailEDITopiaDao extends AbstractRefInterventionAgrosystTravailEDITopiaDao<RefInterventionAgrosystTravailEDI> {

    public LinkedList<RefInterventionAgrosystTravailEDI> findAllActive(AgrosystInterventionType actionType) {
        Map<String,Object> args = DaoUtils.asArgsMap("active", true);

        String query = " FROM " + getEntityClass().getName() + " a " +
                " WHERE a." + RefInterventionAgrosystTravailEDI.PROPERTY_ACTIVE + " = :active";

        query += DaoUtils.andAttributeEquals("a", RefInterventionAgrosystTravailEDI.PROPERTY_INTERVENTION_AGROSYST, args, actionType);

        String hql = query +
                " ORDER BY a." + RefInterventionAgrosystTravailEDI.PROPERTY_REFERENCE_LABEL + " ASC ";

        List<RefInterventionAgrosystTravailEDI> result = findAll(hql, args);
        return Lists.newLinkedList(result);
    }

} //RefInterventionAgrosystTravailEDITopiaDao
