package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefFertiOrgaTopiaDao.java 2738 2014-01-14 14:43:10Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefFertiOrgaTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.utils.DaoUtils;

public class RefFertiOrgaTopiaDao extends AbstractRefFertiOrgaTopiaDao<RefFertiOrga> {

    /**
     * return all categories and ProductTypes from the actives RefFertiMinUNIFA
     *
     * @return all categories and ProductTypes from the actives RefFertiMinUNIFA
     */
    public List<RefFertiOrga> findAllActive() {
        String hql = " FROM " + getEntityClass().getName() + " orga " +
                " WHERE orga." + RefFertiOrga.PROPERTY_ACTIVE + " = true " +
                " ORDER BY orga." + RefFertiOrga.PROPERTY_LIBELLE + " ASC ";

        Map<String, Object> args = DaoUtils.asArgsMap();
        List<RefFertiOrga> result = findAll(hql, args);
        return result;
    }

} //RefFertiOrgaTopiaDao
