package fr.inra.agrosyst.api.entities.referential;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: RefFertiMinUNIFATopiaDao.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/referential/RefFertiMinUNIFATopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.services.referential.MineralProductType;
import fr.inra.agrosyst.api.utils.DaoUtils;

/**
 * @author David Cossé
 */
public class RefFertiMinUNIFATopiaDao extends AbstractRefFertiMinUNIFATopiaDao<RefFertiMinUNIFA> {

    public static final StringBuilder ORDER_BY_BUILDER = new StringBuilder();
    static {
        ArrayList<String> properties = Lists.newArrayList(
                RefFertiMinUNIFA.PROPERTY_N, RefFertiMinUNIFA.PROPERTY_P2_O5, RefFertiMinUNIFA.PROPERTY_K2_O,
                RefFertiMinUNIFA.PROPERTY_BORE, RefFertiMinUNIFA.PROPERTY_FER, RefFertiMinUNIFA.PROPERTY_CALCIUM,
                RefFertiMinUNIFA.PROPERTY_MANGANESE, RefFertiMinUNIFA.PROPERTY_MOLYBDENE,
                RefFertiMinUNIFA.PROPERTY_MG_O, RefFertiMinUNIFA.PROPERTY_OXYDE_DE_SODIUM,
                RefFertiMinUNIFA.PROPERTY_S_O3, RefFertiMinUNIFA.PROPERTY_CUIVRE, RefFertiMinUNIFA.PROPERTY_ZINC);
        for (String prop : properties) {
            if (ORDER_BY_BUILDER.length() == 0) {
                ORDER_BY_BUILDER.append(" ORDER BY ");
            } else {
                ORDER_BY_BUILDER.append(", ");
            }
            ORDER_BY_BUILDER.append("f.");
            ORDER_BY_BUILDER.append(prop);
            ORDER_BY_BUILDER.append(" ASC ");
        }
    }
    public static final String FERTI_ORDER_BY = ORDER_BY_BUILDER.toString();

    /**
     * return all categories and ProductTypes from the actives RefFertiMinUNIFA
     * @return all categories and ProductTypes from the actives RefFertiMinUNIFA
     */
    public List<MineralProductType> findAllActiveFertiMinProductType() {
        List<MineralProductType> result = Lists.newArrayList();
        String hql = "SELECT" +
                " ferti." + RefFertiMinUNIFA.PROPERTY_CATEG + "," +
                " ferti." + RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT + "," +
                " ferti." + RefFertiMinUNIFA.PROPERTY_FORME +
                " FROM " +  getEntityClass().getName() + " ferti " +
                " WHERE ferti." + RefFertiMinUNIFA.PROPERTY_ACTIVE + " = true" +
                " GROUP BY ferti." + RefFertiMinUNIFA.PROPERTY_CATEG + ", ferti." + RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT + ", ferti." + RefFertiMinUNIFA.PROPERTY_FORME +
                " ORDER BY ferti." + RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT + ", ferti." + RefFertiMinUNIFA.PROPERTY_FORME;

        Map<String, Object> args = Maps.newHashMap();
        List<Object[]> mineralProducts = findAll(hql, args);
        Map<Integer, MineralProductType> typesIndex = Maps.newHashMap();
        for (Object[] tuple : mineralProducts) {
            Integer key = (Integer) tuple[0];
            String value = (String) tuple[1];
            String shape = (String) tuple[2];
            MineralProductType type = typesIndex.get(key);
            if (type == null) {
                type = new MineralProductType(key, value, shape);
                result.add(type);
                typesIndex.put(key, type);
            } else {
                type.getShapes().add(shape);
            }
        }
        return result;
    }

    /**
     * Return all RefFertiMinUNIFA that match the category given has parameter and that are active.
     * @param categ the category to apply filter on.
     * @return all RefFertiMinUNIFA that match the category given has parameter and that are active.
     */
    public List<String> findAllActiveFertiMinShape(Integer categ) {
        Map<String, Object> args = Maps.newHashMap();
        String hql = "SELECT f." + RefFertiMinUNIFA.PROPERTY_FORME +
                " FROM " +  getEntityClass().getName() + " f" +
                " WHERE 1=1 ";
        hql += DaoUtils.andAttributeEquals("f", RefFertiMinUNIFA.PROPERTY_CATEG, args, categ);
        hql += DaoUtils.andAttributeEquals("f", RefFertiMinUNIFA.PROPERTY_ACTIVE, args, true);
        hql += " GROUP BY f." + RefFertiMinUNIFA.PROPERTY_FORME;

        List<String> result = findAll(hql, args);
        return result;
    }

    public List<RefFertiMinUNIFA> findAllActiveRefFertiMinUnifaByCategAndShape(Integer categ, String fertilizerShape, String productId) {
        Map<String, Object> args = Maps.newHashMap();
        String query = "FROM " + RefFertiMinUNIFA.class.getName() + " f";
        query += " WHERE 1=1 ";
        query += DaoUtils.andAttributeEquals("f", RefFertiMinUNIFA.PROPERTY_CATEG, args, categ);
        query += DaoUtils.andAttributeEquals("f", RefFertiMinUNIFA.PROPERTY_FORME, args, fertilizerShape);
        if (Strings.isNullOrEmpty(productId)) {
            query += DaoUtils.andAttributeEquals("f", RefFertiMinUNIFA.PROPERTY_ACTIVE, args, true);
        } else {
            args.put("productId", productId);
            query += " AND ( f." + RefFertiMinUNIFA.PROPERTY_TOPIA_ID + " LIKE :productId ";
            query += "       OR f." + RefFertiMinUNIFA.PROPERTY_ACTIVE + " = true )";
        }

        List<RefFertiMinUNIFA> result = findAll(query + FERTI_ORDER_BY, args);

        return result;
    }

}
